/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.midixui.controlui.neckui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.org.toot.midi.misc.GM;
import uk.org.toot.midix.control.neck.NeckFamily;
import uk.org.toot.midix.control.neck.StrungNeck;
import uk.org.toot.midix.control.neck.Tunings;
import uk.org.toot.swingui.midixui.controlui.neckui.NeckController;

public class GMNeckView
extends JPanel {
    private JToolBar toolBar;
    private NeckController ctrl;
    private boolean init = false;
    private ProgramCombo programCombo;

    public GMNeckView(NeckController controller) {
        super(new BorderLayout());
        this.ctrl = controller;
        this.toolBar = new GMNeckToolBar();
        this.add((Component)this.toolBar, "North");
        this.add((Component)controller, "Center");
        this.init = true;
    }

    public StrungNeck getNeck() {
        return this.ctrl.getNeck();
    }

    public void sendProgram() {
        if (this.init) {
            this.programCombo.sendProgram();
        }
    }

    private class GMNeckToolBar
    extends JToolBar {
        public GMNeckToolBar() {
            final JCheckBox octaveCheckBox = new JCheckBox("x2", GMNeckView.this.getNeck().hasOctaveStrings());
            octaveCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    GMNeckView.this.getNeck().setOctaveStrings(octaveCheckBox.isSelected());
                    GMNeckView.this.ctrl.repaint();
                }
            });
            this.add(octaveCheckBox);
            this.addSeparator();
            this.add(new JLabel("  Style  "));
            StyleCombo styleCombo = new StyleCombo();
            this.add(styleCombo);
            final JCheckBox releaseCheckBox = new JCheckBox("Release", ((GMNeckView)GMNeckView.this).ctrl.getStyle().releasing);
            releaseCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ((GMNeckView)((GMNeckToolBar)GMNeckToolBar.this).GMNeckView.this).ctrl.getStyle().releasing = releaseCheckBox.isSelected();
                }
            });
            this.add(releaseCheckBox);
            this.addSeparator();
            this.add(new JLabel("  Sound  "));
            NeckFamily f = GMNeckView.this.getNeck().getFamily();
            GMNeckView.this.programCombo = new ProgramCombo(f.getGMFamily(), 8);
            this.add(new FamilyCombo(f.getGMFamily()));
            this.add(GMNeckView.this.programCombo);
            this.addSeparator();
            this.add(Box.createHorizontalGlue());
            this.add(GMNeckView.this.ctrl.getChordLabel());
            this.add(Box.createHorizontalStrut(16));
        }
    }

    private class StyleCombo
    extends JComboBox
    implements ActionListener {
        public StyleCombo() {
            for (NeckController.PlayingStyle style : GMNeckView.this.ctrl.getStyles()) {
                this.addItem(style.getName());
            }
            this.setPrototypeDisplayValue("Chords #");
            this.setMaximumSize(new Dimension(120, 100));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            GMNeckView.this.ctrl.useStyle((String)this.getSelectedItem());
        }
    }

    private class ProgramCombo
    extends JComboBox
    implements ActionListener {
        private int offset;

        public ProgramCombo(int family, int num) {
            this.setPrototypeDisplayValue("######################");
            this.setMaximumSize(new Dimension(200, 100));
            this.addActionListener(this);
            this.setFamily(family);
        }

        public void setFamily(int family) {
            this.removeActionListener(this);
            this.offset = family * 8;
            this.removeAllItems();
            int i = 0;
            while (i < 8) {
                this.addItem(GM.melodicName(i + this.offset));
                ++i;
            }
            this.setSelectedIndex(0);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            this.sendProgram();
        }

        public void sendProgram() {
            if (this.getSelectedIndex() >= 0) {
                GMNeckView.this.getNeck().setProgram(this.getSelectedIndex() + this.offset);
            }
        }
    }

    private class FamilyCombo
    extends JComboBox
    implements ActionListener {
        public FamilyCombo(int family) {
            this.addActionListener(this);
            this.setPrototypeDisplayValue("Chromatic Perc");
            this.setMaximumSize(new Dimension(200, 100));
            this.setFamily(family);
        }

        public void setFamily(int family) {
            this.removeAllItems();
            int i = 0;
            while (i < 16) {
                this.addItem(GM.melodicFamilyName(i));
                ++i;
            }
            this.setSelectedIndex(family);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.getSelectedIndex() >= 0) {
                GMNeckView.this.programCombo.setFamily(this.getSelectedIndex());
            }
        }
    }

    private class BarreCombo
    extends JComboBox
    implements ActionListener {
        public BarreCombo() {
            int i = 0;
            while (i <= GMNeckView.this.getNeck().getStringCount()) {
                this.addItem(i > 0 ? String.valueOf(i) : "Off");
                ++i;
            }
            this.setSelectedIndex(GMNeckView.this.getNeck().getBarreSize());
            this.addActionListener(this);
            this.setMaximumSize(new Dimension(50, 40));
        }

        public void actionPerformed(ActionEvent e) {
            GMNeckView.this.getNeck().setBarreSize(this.getSelectedIndex());
        }
    }

    public class TuningCombo
    extends JComboBox {
        public TuningCombo(Tunings t) {
            this.setPrototypeDisplayValue("C F# C F# C F# - Aug Fourths ##");
            this.setMaximumSize(new Dimension(200, 100));
            for (String tuning : t.getTunings()) {
                this.addItem(tuning);
            }
        }
    }
}

