/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.midixui.controlui.neckui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.org.toot.midi.core.MidiSystem;
import uk.org.toot.midix.control.neck.NeckFamily;
import uk.org.toot.midix.control.neck.Player;
import uk.org.toot.midix.control.neck.StrungNeck;
import uk.org.toot.music.tonality.Key;
import uk.org.toot.music.tonality.Pitch;
import uk.org.toot.music.tonality.Scales;
import uk.org.toot.swingui.midixui.controlui.neckui.GMNeckView;
import uk.org.toot.swingui.midixui.controlui.neckui.NeckController;
import uk.org.toot.swingui.tonalityui.RootCombo;
import uk.org.toot.swingui.tonalityui.ScaleCombo;

public class NecksView
extends JPanel {
    private MidiSystem midiSystem;
    private JTabbedPane tabbedPane;
    private JToolBar toolBar;
    private Player player = new Player();

    public NecksView(MidiSystem midiSystem) {
        super(new BorderLayout());
        this.midiSystem = midiSystem;
        this.tabbedPane = new JTabbedPane();
        this.toolBar = new NeckToolBar();
        this.add((Component)this.toolBar, "South");
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)new VelocitySlider(), "East");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GMNeckView view = (GMNeckView)NecksView.this.tabbedPane.getSelectedComponent();
                view.sendProgram();
            }
        });
    }

    public void addNeck(NeckController ctrl) {
        this.midiSystem.addMidiDevice(ctrl.getNeck());
        GMNeckView view = new GMNeckView(ctrl);
        this.tabbedPane.add(String.valueOf(ctrl.getNeck().getName()) + "  ", view);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
    }

    protected Key getKey() {
        return this.player.getKey();
    }

    protected int getVelocity() {
        return this.player.getVelocity();
    }

    protected void setVelocity(int velocity) {
        this.player.setVelocity(velocity);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Toolkit.getDefaultToolkit().getScreenSize().width - 10, 320);
    }

    private class VelocitySlider
    extends JSlider {
        public VelocitySlider() {
            super(1, 0, 127, NecksView.this.getVelocity());
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    NecksView.this.setVelocity(VelocitySlider.this.getValue());
                }
            });
        }
    }

    private class NeckToolBar
    extends JToolBar {
        public NeckToolBar() {
            for (NeckFamily family : NeckFamily.families()) {
                JButton button = new JButton(" New " + family.getName());
                button.setActionCommand(family.getName());
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String cmd = e.getActionCommand();
                        NecksView.this.addNeck(new NeckController(new StrungNeck(NeckFamily.named(cmd)), NecksView.this.player));
                    }
                });
                this.add(button);
            }
            this.addSeparator();
            this.add(new JLabel("  Tonality  "));
            final RootCombo rootCombo = new RootCombo(NecksView.this.player.getKey());
            this.add(rootCombo);
            rootCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    NecksView.this.getKey().setRoot(Pitch.classValue((String)rootCombo.getSelectedItem()));
                }
            });
            final ScaleCombo scaleCombo = new ScaleCombo();
            this.add(scaleCombo);
            scaleCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    NecksView.this.getKey().setScale(Scales.getScale((String)scaleCombo.getSelectedItem()));
                }
            });
            this.add(Box.createHorizontalStrut(16));
            this.add(new JLabel("Ctrl: sus4"));
            this.add(Box.createHorizontalStrut(12));
            this.add(new JLabel("Alt: 6"));
            this.add(Box.createHorizontalStrut(16));
            this.add(new JLabel("F1: Modes"));
            this.add(Box.createHorizontalStrut(12));
            this.add(new JLabel("F2: Chords"));
            this.add(Box.createHorizontalStrut(16));
            this.add(new JLabel("F9,F10,F11,F12: C,A,G,E-shaped Chords"));
            this.add(Box.createHorizontalGlue());
            this.add(new JLabel("toot.org.uk"));
            this.add(Box.createHorizontalStrut(16));
        }
    }
}

