/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.projectui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import uk.org.toot.project.ProjectListener;
import uk.org.toot.project.SingleProject;
import uk.org.toot.swing.DisposablePanel;

public abstract class AbstractProjectPanel
extends DisposablePanel {
    private SingleProject project;
    private ProjectListener projectListener;
    private JFileChooser fileChooser;
    protected Action openAction;
    protected Action saveAction;

    public AbstractProjectPanel(SingleProject p) {
        this.project = p;
        this.openAction = new OpenAction();
        this.saveAction = new SaveAction();
        this.projectListener = new ProjectListener(){

            public void open() {
                AbstractProjectPanel.this.updateTitle();
            }

            public void save() {
                AbstractProjectPanel.this.updateTitle();
            }
        };
        this.fileChooser = new JFileChooser(this.project.getProjectsRoot());
        this.fileChooser.setFileSelectionMode(1);
    }

    protected void dispose() {
        this.saveIfConfirmed();
        this.projectListener = null;
        this.removeAll();
    }

    protected void saveIfConfirmed() {
        if (!this.project.canSaveProject()) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog(this, "Save " + this.project.getCurrentProjectTitle(), "Toot", 0);
        if (opt == 0) {
            this.project.saveProject();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.project.addProjectListener(this.projectListener);
        this.updateTitle();
    }

    public void removeNotify() {
        this.project.removeProjectListener(this.projectListener);
        super.removeNotify();
    }

    protected void updateTitle() {
        String name = String.valueOf(this.project.getCurrentProjectTitle()) + " / " + this.project.getCurrentProjectArtist();
        if (this.getTopLevelAncestor() instanceof Frame) {
            ((Frame)this.getTopLevelAncestor()).setTitle(String.valueOf(name) + " - Toot");
        }
    }

    protected class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super("Open");
        }

        public void actionPerformed(ActionEvent ae) {
            int ret = AbstractProjectPanel.this.fileChooser.showOpenDialog(AbstractProjectPanel.this);
            if (ret == 0) {
                AbstractProjectPanel.this.saveIfConfirmed();
                AbstractProjectPanel.this.project.openProject(AbstractProjectPanel.this.fileChooser.getSelectedFile().getName());
            }
        }
    }

    protected class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save");
        }

        public void actionPerformed(ActionEvent ae) {
            if (AbstractProjectPanel.this.project.canSaveProject()) {
                AbstractProjectPanel.this.project.saveProject();
            }
        }
    }
}

