/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.player.DefaultMixer;
import com.vwp.sound.mod.modplay.player.ModuleState;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.sound.output.Output;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class Player {
    private ModuleState ms;
    private Output out;
    private Class lowLevelMixerClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean init(Output output, boolean interpolate) {
        Class<?> clazz;
        block5: {
            block6: {
                this.out = output;
                if (!interpolate) break block6;
                clazz = class$0;
                if (clazz != null) break block5;
                try {
                    clazz = class$0 = Class.forName("com.vwp.sound.mod.modplay.player.InterpolatingMixer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                break block5;
            }
            clazz = class$1;
            if (clazz == null) {
                try {
                    class$1 = Class.forName("com.vwp.sound.mod.modplay.player.FastMixer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$1;
            }
        }
        this.lowLevelMixerClass = clazz;
        return true;
    }

    public boolean load(String fileName) throws InvalidFormatException, IOException {
        ModuleLoader ml = ModuleLoader.getModuleLoader(new File(fileName));
        Module module = ml.getModule();
        return this.load(module);
    }

    public boolean load(InputStream in, String name) throws InvalidFormatException, IOException {
        ModuleLoader ml = ModuleLoader.getModuleLoader(in, name);
        Module module = ml.getModule();
        return this.load(module);
    }

    public boolean load(Module module) {
        Instrument[] instr = module.getInstruments();
        int tracks = module.getPatternAtPos(0).getTrackCount();
        DefaultMixer mixer = new DefaultMixer(this.out, this.lowLevelMixerClass, tracks);
        this.ms = new ModuleState(module, mixer);
        mixer.setAmplification(this.getDefaultAmplification());
        return this.out.open();
    }

    public boolean play() throws PlayerException {
        return this.ms.play();
    }

    public boolean close() {
        return this.out.close();
    }

    public ModuleState getModuleState() {
        return this.ms;
    }

    public Module getModule() {
        return this.getModuleState().getModule();
    }

    public double getDefaultAmplification() {
        return (double)this.getModuleState().getModule().getPatternAtPos(0).getTrackCount() / 4.0;
    }

    public void setAmplification(double amp) {
        this.getModuleState().getMixer().setAmplification(amp);
    }

    public double getAmplification() {
        return this.getModuleState().getMixer().getAmplification();
    }

    public void mute(int track, boolean mute) {
        this.getModuleState().getMixer().setMute(track, mute);
    }

    public void mute(boolean[] mute) {
        int n = 0;
        while (n < mute.length && n < this.getModule().getTrackCount()) {
            this.mute(n, mute[n]);
            ++n;
        }
    }

    public void setVolume(double volume) {
        this.getModuleState().getMixer().setVolume(volume);
    }

    public double getVolume() {
        return this.getModuleState().getMixer().getVolume();
    }

    public void setBalance(double balance) {
        this.getModuleState().getMixer().setBalance(balance);
    }

    public double getBalance() {
        return this.getModuleState().getMixer().getBalance();
    }

    public void setSeparation(double separation) {
        this.getModuleState().getMixer().setSeparation(separation);
    }

    public double getSeparation() {
        return this.getModuleState().getMixer().getSeparation();
    }

    public void setPosition(int pos) {
        this.getModuleState().setPosition(pos);
    }

    public int getPosition() {
        return this.getModuleState().getPosition();
    }

    public int getDivision() {
        return this.getModuleState().getDivision();
    }

    public int getTick() {
        return this.getModuleState().getTick();
    }

    public int getNote(int track) {
        return this.getModuleState().getModule().getPatternAtPos(this.getPosition()).getTrack(track).getNote(this.getDivision());
    }
}

