/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.module.ModuleUnits;

public class S3MUnits
implements ModuleUnits {
    private static final String NAME = "s3m";
    private double c4hz;
    private boolean amigaPeriods;
    private static final int MAX_PERIOD = 1712;
    private static final int MIN_PERIOD = 57;
    private static final double STANDARD_C4HZ = 8363.0;
    private double ac;

    public S3MUnits(int c4hz, boolean amigaPeriods) {
        this.c4hz = c4hz;
        this.amigaPeriods = amigaPeriods;
        this.ac = 7159090.5 * (double)c4hz / 8363.0;
    }

    public double note2period(double note) {
        return this.rate2period(this.note2rate(note));
    }

    public double period2note(double period) {
        return this.rate2note(this.period2rate(period));
    }

    public double period2rate(double period) {
        return this.ac / (this.amigaPeriods ? period * 2.0 : period * 2.0);
    }

    public double rate2period(double rate) {
        return this.ac / (this.amigaPeriods ? rate * 2.0 : rate * 2.0);
    }

    public double note2rate(double note) {
        double c0hz = this.c4hz / 16.0;
        return c0hz * Math.pow(2.0, note / 12.0);
    }

    public double rate2note(double rate) {
        double c0hz = this.c4hz / 16.0;
        return 12.0 * Math.log(rate / c0hz) / Math.log(2.0);
    }

    public double getUpperNoteLimit() {
        return this.period2note(57.0);
    }

    public double getLowerNoteLimit() {
        return this.period2note(1712.0);
    }

    public double addPeriod(double note, double period) {
        return this.period2note(this.note2period(note) + period);
    }

    public String getName() {
        return NAME;
    }
}

