/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.loader.STMUnits;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.util.Util;
import com.vwp.sound.mod.util.io.RandomAccess;
import com.vwp.sound.mod.util.io.RandomAccessArray;
import java.io.IOException;

public class STMLoader
extends ModuleLoader {
    private Module module;
    private static final int TYPE_MODULE = 2;

    public STMLoader(String name, byte[] d) {
        RandomAccessArray raf = new RandomAccessArray(d);
        try {
            int data = -1;
            StringBuffer nameSB = new StringBuffer();
            while (raf.getPosition() < 20L && (data = raf.read()) != 0) {
                nameSB.append((char)data);
            }
            raf.seek(20L);
            String stmname = nameSB.toString();
            StringBuffer trackerSB = new StringBuffer();
            while (raf.getPosition() < 28L && (data = raf.read()) != 0) {
                trackerSB.append((char)data);
            }
            raf.seek(28L);
            String tracker = trackerSB.toString();
            int id = raf.read();
            int fileType = raf.read();
            if (fileType != 2) {
                System.err.println("Wrong file type: " + fileType);
            }
            int versionMajor = raf.read();
            int versionMinor = raf.read();
            int initialTempo = raf.read();
            int numPatterns = raf.read();
            int initialGlobalVolume = raf.read();
            System.out.println("Name: " + stmname);
            System.out.println("Tracker: " + tracker);
            System.out.println("ID: " + Integer.toString(id, 16));
            System.out.println("FileType: " + fileType);
            System.out.println("Version: " + versionMajor + "." + versionMinor);
            System.out.println("Initial tempo: " + initialTempo);
            System.out.println("Number of patterns: " + numPatterns);
            System.out.println("Initial global volume: " + initialGlobalVolume);
            raf.seek(48L);
            Instrument[] instruments = new Instrument[31];
            int n = 0;
            while (n < 31) {
                raf.seek(48 + n * 32);
                StringBuffer instrumentSB = new StringBuffer();
                int count = 0;
                while (count++ < 12 && (data = raf.read()) != 0) {
                    instrumentSB.append((char)data);
                }
                String instrumentName = instrumentSB.toString();
                raf.read();
                raf.read();
                raf.skipBytes(2);
                int sampleLen = this.readWord(raf);
                int loopStart = this.readWord(raf);
                int loopEnd = this.readWord(raf);
                int sampleVolume = raf.read();
                raf.skipBytes(1);
                int c3 = this.readWord(raf);
                raf.skipBytes(4);
                this.readWord(raf);
                int loopType = loopStart >= 0 && loopStart < sampleLen && loopEnd > loopStart && loopEnd <= sampleLen ? 1 : 0;
                STMUnits units = new STMUnits(c3);
                int[] note2sample = new int[120];
                Sample sample = new Sample("sample-" + n, instrumentName, (double)sampleVolume / 64.0, 0.5, sampleLen, loopType, loopStart, loopEnd - loopStart, 0.0, 0.0, units);
                instruments[n] = new Instrument(instrumentName, note2sample, new Sample[]{sample}, null, 0.5);
                ++n;
            }
            raf.skipBytes(4);
            int[] orders = new int[128];
            int n2 = 0;
            while (n2 < orders.length) {
                orders[n2] = raf.read();
                ++n2;
            }
            n2 = 0;
            while (n2 < numPatterns) {
                Track[] tracks = new Track[4];
                int t = 0;
                while (t < 4) {
                    tracks[t] = new Track(64);
                    ++t;
                }
                System.out.println();
                int y = 0;
                while (y < 64) {
                    System.out.println();
                    int x = 0;
                    while (x < 4) {
                        int byte1 = raf.read() & 0xFF;
                        int note = 0;
                        int volume = 0;
                        int octave = 0;
                        int instrument = 0;
                        int command = 0;
                        int arg1 = 0;
                        int arg2 = 0;
                        if (byte1 == 251 || byte1 == 252 || byte1 == 253) {
                            note = 15;
                            octave = 0;
                            volume = 0;
                            instrument = 0;
                            command = 0;
                            arg1 = 0;
                            arg2 = 0;
                            System.out.print("-");
                        } else {
                            note = byte1 & 0xF;
                            octave = byte1 >>> 4 & 0xF;
                            instrument = (byte1 & 0xF0) << 4;
                            int byte2 = raf.read() & 0xFF;
                            volume = byte2 & 7;
                            instrument = byte2 >> 3;
                            int byte3 = raf.read() & 0xFF;
                            command = byte3 & 0xF;
                            volume += byte3 >>> 4 << 3;
                            int byte4 = raf.read() & 0xFF;
                            arg2 = byte4 & 0xF;
                            arg1 = byte4 >>> 4;
                        }
                        if (n2 < 2) {
                            System.out.print(String.valueOf(this.getNoteSymbol(note, octave)) + " " + this.getInstrument(instrument) + " " + this.getVolume(volume) + " " + this.getEffect(command, arg1, arg2) + " | ");
                        } else {
                            Util.exit(1);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++n2;
            }
            new Module(stmname, "", tracker, instruments, null, orders, 0, 0, 0, 0.0, 0, null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            Util.exit(1);
        }
        Util.exit(1);
    }

    public String getVolume(int vol) {
        if (vol > 64) {
            return "..";
        }
        String str = String.valueOf(vol);
        if (str.length() == 1) {
            str = "0" + str;
        }
        return str;
    }

    public String getInstrument(int vol) {
        if (vol == 0) {
            return "..";
        }
        String str = String.valueOf(vol);
        if (str.length() == 1) {
            str = "0" + str;
        }
        return str;
    }

    public String getEffect(int eff, int a1, int a2) {
        char effc = (char)(eff > 0 ? 64 + eff : 46);
        char a1c = (char)(a1 <= 9 ? 48 + a1 : 65 + a1 - 10);
        char a2c = (char)(a2 <= 9 ? 48 + a2 : 65 + a2 - 10);
        return String.valueOf(effc) + a1c + a2c;
    }

    private String getNoteSymbol(int note, int period) {
        if (note == -2) {
            return "---";
        }
        String code = null;
        switch (note) {
            case 0: {
                code = "C-";
                break;
            }
            case 1: {
                code = "C#";
                break;
            }
            case 2: {
                code = "D-";
                break;
            }
            case 3: {
                code = "D#";
                break;
            }
            case 4: {
                code = "E-";
                break;
            }
            case 5: {
                code = "F-";
                break;
            }
            case 6: {
                code = "F#";
                break;
            }
            case 7: {
                code = "G-";
                break;
            }
            case 8: {
                code = "G#";
                break;
            }
            case 9: {
                code = "A-";
                break;
            }
            case 10: {
                code = "A#";
                break;
            }
            case 11: {
                code = "B-";
                break;
            }
            default: {
                code = "...";
                return code;
            }
        }
        code = String.valueOf(code) + period;
        return code;
    }

    public Module getModule() {
        return this.module;
    }

    int readWord(RandomAccess raf) throws IOException {
        return (raf.read() & 0xFF) + (raf.read() & 0xFF) * 256 & 0xFFFF;
    }

    int readDWord(RandomAccess raf) throws IOException {
        return raf.read() & 0xFF | (raf.read() & 0xFF) >>> 8 | (raf.read() & 0xFF) >>> 16 | (raf.read() & 0xFF) >>> 24;
    }
}

