/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.loader.XmUnits;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Pattern;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoVibrato;
import com.vwp.sound.mod.modplay.player.autoeffect.Fadeout;
import com.vwp.sound.mod.modplay.player.autoeffect.PanningEnvelope;
import com.vwp.sound.mod.modplay.player.autoeffect.VolumeEnvelope;
import com.vwp.sound.mod.modplay.player.autoeffect.XmAutoEffects;
import com.vwp.sound.mod.util.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class XMLoader
extends ModuleLoader {
    private Module module;

    public XMLoader(String name, byte[] data) throws InvalidFormatException, IOException {
        this.module = this.load(name, data);
    }

    private Module load(String name, byte[] fileData) throws InvalidFormatException, IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(fileData));
        String id = Util.readZeroPaddedString(dis, 17);
        String xmname = Util.readZeroPaddedString(dis, 20);
        XMLoader.skip(dis, 1);
        String trackerName = Util.readZeroPaddedString(dis, 20);
        byte vMinor = dis.readByte();
        byte vMajor = dis.readByte();
        if (vMajor != 1 || vMinor < 4) {
            throw new InvalidFormatException("Unknown version: " + vMajor + "." + vMinor);
        }
        Util.readLEInt(dis);
        int numOrders = Util.readLEShort(dis);
        int restart = Util.readLEShort(dis);
        int numChannels = Util.readLEShort(dis);
        int numPatterns = Util.readLEShort(dis);
        int numInstruments = Util.readLEShort(dis);
        Util.readLEShort(dis);
        int tempo = Util.readLEShort(dis);
        if (tempo == 0) {
            tempo = 1;
        }
        int BPM = Util.readLEShort(dis);
        int[] patternOrderTab = new int[numOrders];
        int n = 0;
        while (n < numOrders) {
            patternOrderTab[n] = dis.readByte() & 0xFF;
            ++n;
        }
        XMLoader.skip(dis, 256 - numOrders);
        Instrument[] instruments = this.loadInstruments(fileData, numInstruments);
        int highestPattern = 0;
        int n2 = 0;
        while (n2 < patternOrderTab.length) {
            if (patternOrderTab[n2] > highestPattern) {
                highestPattern = patternOrderTab[n2];
            }
            ++n2;
        }
        Pattern[] patterns = new Pattern[Math.max(highestPattern + 1, numPatterns)];
        int n3 = 0;
        while (n3 < numPatterns) {
            patterns[n3] = this.loadPattern(dis, numChannels);
            ++n3;
        }
        n3 = numPatterns;
        while (n3 <= highestPattern) {
            Track[] emptyTracks = new Track[numChannels];
            int m = 0;
            while (m < numChannels) {
                emptyTracks[m] = new Track(64);
                int p = 0;
                while (p < 64) {
                    emptyTracks[m].initDivision(p, -1, -2, null, null, null);
                    ++p;
                }
                ++m;
            }
            patterns[n3] = new Pattern(emptyTracks, 64);
            ++n3;
        }
        double r = 1.0;
        double l = 0.0;
        double[] panning = new double[]{l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l};
        double[] pann = new double[numChannels];
        double[] volume = new double[numChannels];
        int n4 = 0;
        while (n4 < numChannels) {
            pann[n4] = panning[n4];
            volume[n4] = 1.0;
            ++n4;
        }
        this.module = new Module(xmname, id, trackerName, instruments, patterns, patternOrderTab, restart, BPM, tempo, 1.0, 2, volume, pann);
        return this.module;
    }

    private Instrument[] loadInstruments(byte[] fileData, int numInstruments) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(fileData));
        XMLoader.skip(dis, 60);
        int hlen = Util.readLEInt(dis);
        XMLoader.skip(dis, 6);
        int numPatterns = Util.readLEShort(dis);
        XMLoader.skip(dis, hlen - 12);
        int n = 0;
        while (n < numPatterns) {
            XMLoader.skip(dis, 7);
            int plen = Util.readLEShort(dis);
            XMLoader.skip(dis, plen);
            ++n;
        }
        Instrument[] instruments = new Instrument[numInstruments];
        int n2 = 0;
        while (n2 < numInstruments) {
            int sampleLen;
            int instSize = Util.readLEInt(dis);
            String name = Util.readZeroPaddedString(dis, 22);
            dis.readByte();
            int numSamples = Util.readLEShort(dis);
            int[] note2sample = null;
            AutoEffect[] autoEffects = null;
            if (numSamples > 0) {
                XMLoader.skip(dis, 4);
                note2sample = new int[98];
                int m = 0;
                while (m < 96) {
                    note2sample[m] = dis.readByte() & 0xFF;
                    ++m;
                }
                int[] volEnvOfs = new int[12];
                double[] volEnvVol = new double[12];
                int m2 = 0;
                while (m2 < 12) {
                    volEnvOfs[m2] = Util.readLEShort(dis);
                    volEnvVol[m2] = (double)Util.readLEShort(dis) / 64.0;
                    ++m2;
                }
                int[] panEnvOfs = new int[12];
                double[] panEnvPan = new double[12];
                int m3 = 0;
                while (m3 < 12) {
                    panEnvOfs[m3] = Util.readLEShort(dis);
                    panEnvPan[m3] = (double)Util.readLEShort(dis) / 64.0;
                    ++m3;
                }
                byte numVolPoints = dis.readByte();
                byte numPanPoints = dis.readByte();
                byte vSust = dis.readByte();
                byte vLoopStart = dis.readByte();
                byte vLoopEnd = dis.readByte();
                byte pSust = dis.readByte();
                byte pLoopStart = dis.readByte();
                byte pLoopEnd = dis.readByte();
                byte vType = dis.readByte();
                byte pType = dis.readByte();
                VolumeEnvelope volEnv = new VolumeEnvelope(volEnvOfs, volEnvVol, numVolPoints, vSust, vLoopStart, vLoopEnd, vType);
                PanningEnvelope panEnv = new PanningEnvelope(panEnvOfs, panEnvPan, numPanPoints, pSust, pLoopStart, pLoopEnd, pType);
                AutoVibrato vibrato = new AutoVibrato(dis.readByte(), dis.readByte(), dis.readByte(), dis.readByte());
                double fade = (double)(Util.readLEShort(dis) & 0xFFFF) / 32768.0;
                Fadeout volFade = new Fadeout(fade);
                XmAutoEffects xmAuto = new XmAutoEffects(volEnv, panEnv, vibrato, volFade);
                autoEffects = new AutoEffect[]{xmAuto};
                XMLoader.skip(dis, 2);
                XMLoader.skip(dis, instSize - 243);
            } else {
                XMLoader.skip(dis, instSize - 29);
            }
            Sample[] samples = null;
            if (numSamples > 0) {
                samples = new Sample[numSamples];
            }
            int[] sampleTypes = new int[numSamples];
            XmUnits xmUnits = new XmUnits();
            int m = 0;
            while (m < numSamples) {
                byte sampleType;
                sampleLen = Util.readLEInt(dis);
                int loopStart = Util.readLEInt(dis);
                int loopLen = Util.readLEInt(dis);
                double volume = (double)dis.readByte() / 64.0;
                double fineTune = (double)dis.readByte() / 128.0;
                sampleTypes[m] = dis.readByte();
                if ((sampleType & 3) == 0) {
                    loopLen = 0;
                    loopStart = 0;
                }
                int p = (dis.readByte() & 0xFF) - 128;
                double panning = ((double)p / 128.0 + 1.0) / 2.0;
                byte relNote = dis.readByte();
                dis.readByte();
                String sampleName = Util.readZeroPaddedString(dis, 22);
                int loopType = 0;
                if ((sampleType & 3) == 0 || loopLen == 0) {
                    loopType = 0;
                } else if ((sampleType & 3) == 1) {
                    loopType = 1;
                } else if ((sampleType & 3) == 2) {
                    loopType = 2;
                }
                if ((sampleType & 0x10) != 0) {
                    sampleLen /= 2;
                    loopStart /= 2;
                    loopLen /= 2;
                }
                samples[m] = new Sample("sample-" + n2 + "-" + m, sampleName, volume, panning, sampleLen, loopType, loopStart, loopLen, relNote, fineTune, xmUnits);
                ++m;
            }
            m = 0;
            while (m < numSamples) {
                short old;
                short[] sampleData;
                sampleLen = samples[m].getLength();
                if ((sampleTypes[m] & 0x10) != 0) {
                    sampleData = new short[sampleLen];
                    old = 0;
                    int i = 0;
                    while (i < sampleLen) {
                        short newData;
                        sampleData[i] = newData = (short)(old + (short)Util.readLEShort(dis));
                        old = newData;
                        ++i;
                    }
                } else {
                    sampleData = new short[sampleLen];
                    old = 0;
                    int i = 0;
                    while (i < sampleLen) {
                        short newData;
                        sampleData[i] = newData = (short)(old + dis.readByte() * 256);
                        old = newData;
                        ++i;
                    }
                }
                samples[m].setData(sampleData);
                ++m;
            }
            instruments[n2] = new Instrument(name, note2sample, samples, autoEffects, 0.0);
            ++n2;
        }
        return instruments;
    }

    /*
     * Unable to fully structure code
     */
    private Pattern loadPattern(DataInputStream dis, int numChannels) throws IOException {
        Util.readLEInt(dis);
        dis.readByte();
        numRows = Util.readLEShort(dis);
        packedSize = Util.readLEShort(dis);
        tracks = new Track[numChannels];
        n = 0;
        while (n < numChannels) {
            tracks[n] = new Track(numRows);
            ++n;
        }
        division = 0;
        n = 0;
        if (packedSize != 0) ** GOTO lbl166
        emptyTracks = new Track[numChannels];
        m = 0;
        while (m < numChannels) {
            emptyTracks[m] = new Track(64);
            p = 0;
            while (p < 64) {
                emptyTracks[m].initDivision(p, -1, -2, null, null, null);
                ++p;
            }
            ++m;
        }
        return new Pattern(emptyTracks, 64);
lbl-1000:
        // 1 sources

        {
            m = 0;
            while (m < numChannels) {
                numEffects = 0;
                note = 0;
                instrument = 0;
                volume = 0;
                effect = 0;
                effectParam = 0;
                fst = dis.readByte();
                ++n;
                if (fst >= 0) {
                    note = fst & 255;
                    instrument = dis.readByte() & 255;
                    ++n;
                    volume = dis.readByte() & 255;
                    ++n;
                    effect = dis.readByte() & 255;
                    ++n;
                    effectParam = dis.readByte() & 255;
                    ++n;
                } else {
                    if ((fst & 1) != 0) {
                        note = dis.readByte() & 255;
                        ++n;
                    }
                    if ((fst & 2) != 0) {
                        instrument = dis.readByte() & 255;
                        ++n;
                    }
                    if ((fst & 4) != 0) {
                        volume = dis.readByte() & 255;
                        ++n;
                    }
                    if ((fst & 8) != 0) {
                        effect = dis.readByte() & 255;
                        ++n;
                    }
                    if ((fst & 16) != 0) {
                        effectParam = dis.readByte() & 255;
                        ++n;
                    }
                }
                keyOff = false;
                if (note == 0) {
                    note = -2;
                } else if (note == 97) {
                    keyOff = true;
                    note = -2;
                } else {
                    --note;
                }
                instrument = instrument == 0 ? -1 : --instrument;
                if (effect != 0 || effectParam != 0) {
                    ++numEffects;
                }
                if (volume >= 16) {
                    ++numEffects;
                }
                if (keyOff) {
                    ++numEffects;
                }
                effects = new int[numEffects];
                effectArg1 = new int[numEffects];
                effectArg2 = new int[numEffects];
                effectIndex = 0;
                if (volume >= 16 && volume <= 80) {
                    effects[effectIndex] = 12;
                    effectArg1[effectIndex] = volume - 16 >>> 4 & 15;
                    effectArg2[effectIndex] = volume - 16 & 15;
                    ++effectIndex;
                } else if (volume >= 96 && volume <= 111) {
                    effects[effectIndex] = 10;
                    effectArg1[effectIndex] = 0;
                    effectArg2[effectIndex] = volume & 15;
                    ++effectIndex;
                } else if (volume >= 112 && volume <= 127) {
                    effects[effectIndex] = 10;
                    effectArg1[effectIndex] = volume & 15;
                    effectArg2[effectIndex] = 0;
                    ++effectIndex;
                } else if (volume >= 128 && volume <= 143) {
                    effects[effectIndex] = 27;
                    effectArg1[effectIndex] = 11;
                    effectArg2[effectIndex] = volume & 15;
                    ++effectIndex;
                } else if (volume >= 144 && volume <= 159) {
                    effects[effectIndex] = 26;
                    effectArg1[effectIndex] = 10;
                    effectArg2[effectIndex] = volume & 15;
                    ++effectIndex;
                } else if (volume >= 160 && volume <= 175) {
                    effects[effectIndex] = 4;
                    effectArg1[effectIndex] = volume & 15;
                    effectArg2[effectIndex] = 0;
                    ++effectIndex;
                } else if (volume >= 176 && volume <= 191) {
                    effects[effectIndex] = 4;
                    effectArg1[effectIndex] = 0;
                    effectArg2[effectIndex] = volume & 15;
                    ++effectIndex;
                } else if (volume >= 192 && volume <= 207) {
                    effects[effectIndex] = 8;
                    effectArg1[effectIndex] = volume & 15;
                    effectArg2[effectIndex] = 0;
                    ++effectIndex;
                } else if (volume >= 208 && volume <= 223) {
                    effects[effectIndex] = 52;
                    effectArg1[effectIndex] = 0;
                    effectArg2[effectIndex] = volume & 15;
                    ++effectIndex;
                } else if (volume >= 224 && volume <= 239) {
                    effects[effectIndex] = 52;
                    effectArg1[effectIndex] = volume & 15;
                    effectArg2[effectIndex] = 0;
                    ++effectIndex;
                } else if (volume >= 240 && volume <= 255) {
                    effects[effectIndex] = 3;
                    effectArg1[effectIndex] = 0;
                    effectArg2[effectIndex] = volume & 15;
                    ++effectIndex;
                } else if (keyOff) {
                    effects[effectIndex] = 50;
                    effectArg1[effectIndex] = 0;
                    effectArg2[effectIndex] = 0;
                    ++effectIndex;
                }
                if (effect != 0 || effectParam != 0) {
                    arg1 = effectParam >>> 4 & 15;
                    arg2 = effectParam & 15;
                    effects[effectIndex] = this.translateEffectNum(effect, arg1);
                    effectArg1[effectIndex] = arg1;
                    effectArg2[effectIndex] = arg2;
                    ++effectIndex;
                }
                tracks[m].initDivision(division, instrument, note, effects, effectArg1, effectArg2);
                ++m;
            }
            ++division;
lbl166:
            // 2 sources

            ** while (n < packedSize)
        }
lbl167:
        // 1 sources

        return new Pattern(tracks, numRows);
    }

    private int translateEffectNum(int effectNum, int arg1) {
        switch (effectNum) {
            case 0: {
                return 0;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 41;
            }
            case 3: {
                return 42;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 43;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                switch (arg1) {
                    case 0: {
                        return 16;
                    }
                    case 1: {
                        return 44;
                    }
                    case 2: {
                        return 45;
                    }
                    case 3: {
                        return 19;
                    }
                    case 4: {
                        return 20;
                    }
                    case 5: {
                        return 21;
                    }
                    case 6: {
                        return 22;
                    }
                    case 7: {
                        return 23;
                    }
                    case 8: {
                        return 24;
                    }
                    case 9: {
                        return 25;
                    }
                    case 10: {
                        return 46;
                    }
                    case 11: {
                        return 47;
                    }
                    case 12: {
                        return 28;
                    }
                    case 13: {
                        return 29;
                    }
                    case 14: {
                        return 30;
                    }
                    case 15: {
                        return 31;
                    }
                }
                break;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 48;
            }
            case 17: {
                return 49;
            }
            case 20: {
                return 50;
            }
            case 21: {
                return 51;
            }
            case 25: {
                return 52;
            }
            case 27: {
                return 53;
            }
            case 29: {
                return 60;
            }
            case 32: {
                return 54;
            }
            case 33: {
                if (arg1 == 1) {
                    return 55;
                }
                if (arg1 != 2) break;
                return 56;
            }
        }
        System.err.println("Bad effect number: " + effectNum);
        return -1;
    }

    public Module getModule() {
        return this.module;
    }
}

