/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;

public class Instrument {
    private String name;
    private Sample[] samples;
    private int[] note2sample;
    private AutoEffect[] autoEffects;
    private double panning;
    public static final int NO_NOTE = -2;

    public Instrument(String name, int[] note2sample, Sample[] samples, AutoEffect[] autoEffects, double panning) {
        this.name = name;
        this.note2sample = note2sample;
        this.samples = samples;
        this.autoEffects = autoEffects;
        this.panning = panning;
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Instrument name: ");
        sb.append(this.name);
        sb.append("\n");
        sb.append("#samples:        ");
        sb.append(this.getNumberOfSamples());
        sb.append("\n");
        int n = 0;
        while (n < this.getNumberOfSamples()) {
            sb.append(this.samples[n].getInfo());
            ++n;
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public Sample getSampleByNum(int num) {
        if (num > this.samples.length || num < 0) {
            return null;
        }
        return this.samples[num];
    }

    public Sample getSampleByNote(int note) {
        if (note == -2 || this.note2sample == null || note >= this.note2sample.length || note < 0) {
            return null;
        }
        return this.samples[this.note2sample[note]];
    }

    public int getNumberOfSamples() {
        if (this.samples == null) {
            return 0;
        }
        return this.samples.length;
    }

    public int getNumberOfAutoEffects() {
        if (this.autoEffects == null) {
            return 0;
        }
        return this.autoEffects.length;
    }

    public AutoEffect getAutoEffect(int num) {
        if (this.autoEffects == null || num >= this.autoEffects.length || num < 0) {
            return null;
        }
        return this.autoEffects[num];
    }

    public AutoEffect[] getAutoEffects() {
        return this.autoEffects;
    }

    public double getPanning() {
        return this.panning;
    }
}

