/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player;

import com.vwp.sound.mod.modplay.player.LowLevelMixer;
import com.vwp.sound.mod.modplay.player.Mixer;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.sound.output.Output;
import java.io.IOException;

public class DefaultMixer
implements Mixer {
    private int[] mixerBufferLeft = new int[44100];
    private int[] mixerBufferRight = new int[44100];
    private byte[] mixedData = new byte[352800];
    private Output output;
    private Class lowLevelMixerClass;
    private int numberOfTracks;
    private double amplification = 1.0;
    private double volume = 1.0;
    private double balance = 0.5;
    private double separation = 1.0;
    private Track[] tracks;

    public DefaultMixer(Output output, Class lowLevelMixerClass, int numberOfTracks) {
        this.lowLevelMixerClass = lowLevelMixerClass;
        this.output = output;
        this.numberOfTracks = numberOfTracks;
        this.tracks = new Track[numberOfTracks];
        int n = 0;
        while (n < numberOfTracks) {
            this.tracks[n] = new Track();
            ++n;
        }
    }

    public void setTrack(short[] sampleData, double offset, double rate, double volume, double panning, int loopType, int loopStart, int looplength, int track) throws PlayerException {
        try {
            if (this.tracks[track] == null) {
                this.tracks[track] = new Track((LowLevelMixer)this.lowLevelMixerClass.newInstance(), sampleData, offset, rate, volume, panning, loopType, loopStart, looplength);
            } else {
                this.tracks[track].init((LowLevelMixer)this.lowLevelMixerClass.newInstance(), sampleData, offset, rate, volume, panning, loopType, loopStart, looplength);
            }
        }
        catch (Exception e) {
            throw new PlayerException("Could not initialize track " + track);
        }
    }

    public int getNumberOfTracks() {
        return this.numberOfTracks;
    }

    public void setAmplification(double amp) {
        this.amplification = amp;
    }

    public double getAmplification() {
        return this.amplification;
    }

    public void setVolume(double volume) {
        if (volume > 1.0) {
            volume = 1.0;
        } else if (volume < 0.0) {
            volume = 0.0;
        }
        this.volume = volume;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setSeparation(double separation) {
        this.separation = separation;
    }

    public double getSeparation() {
        return this.separation;
    }

    public void setMute(int track, boolean mute) {
        if (this.tracks[track] != null) {
            this.tracks[track].setMute(mute);
        }
    }

    public boolean isMute(int track) {
        return this.tracks[track].isMute();
    }

    public void play(double millisecs) throws PlayerException {
        try {
            int len = (int)(millisecs * 44100.0 / 1000.0) * 2 * 2;
            this.mix(this.mixedData, len);
            this.output.write(this.mixedData, 0, len);
        }
        catch (IOException e) {
            throw new PlayerException("Could not ply mixed data");
        }
    }

    private void mix(byte[] data, int len) {
        double mulL;
        int length = len / 4;
        int n = 0;
        while (n < this.numberOfTracks) {
            if (this.tracks[n] != null) {
                this.tracks[n].mix(length, 1);
                this.tracks[n].mix(length, 2);
            }
            ++n;
        }
        double mulR = mulL = this.amplification * this.volume / (double)this.numberOfTracks;
        if (this.balance < 0.5) {
            mulR *= 2.0 * this.balance;
        } else if (this.balance > 0.5) {
            mulL *= 2.0 * (1.0 - this.balance);
        }
        int n2 = 0;
        int m = 0;
        while (n2 < len) {
            double rval = (double)this.mixerBufferRight[m] * mulR;
            if (rval > 32767.0) {
                rval = 32767.0;
            } else if (rval < -32768.0) {
                rval = -32768.0;
            }
            double lval = (double)this.mixerBufferLeft[m] * mulL;
            if (lval > 32767.0) {
                lval = 32767.0;
            } else if (lval < -32768.0) {
                lval = -32768.0;
            }
            int irval = (int)(rval * this.separation + lval * (1.0 - this.separation));
            int ilval = (int)(lval * this.separation + rval * (1.0 - this.separation));
            data[n2 + 0] = (byte)ilval;
            data[n2 + 1] = (byte)(ilval >>> 8);
            data[n2 + 2] = (byte)irval;
            data[n2 + 3] = (byte)(irval >>> 8);
            n2 += 4;
            ++m;
        }
        n2 = 0;
        while (n2 < length) {
            this.mixerBufferLeft[n2] = 0;
            this.mixerBufferRight[n2] = 0;
            ++n2;
        }
    }

    private class Track {
        public static final int LEFT = 1;
        public static final int RIGHT = 2;
        public static final int MONO = 3;
        private short[] sampleData;
        private double offset;
        private double offsetLeft;
        private double offsetRight;
        private double rate;
        private double volume;
        private double panning;
        private int loopType;
        private int loopStart;
        private int loopLength;
        private boolean mute = false;
        private LowLevelMixer llm;
        int TBL = 256;
        short[] tmpBuffer = new short[this.TBL];
        int tmpBufferStart = 0;
        int tmpBufferEnd = 0;

        public Track() {
        }

        public Track(LowLevelMixer llm, short[] sampleData, double offset, double rate, double volume, double panning, int loopType, int loopStart, int loopLength) {
            this.init(llm, sampleData, offset, rate, volume, panning, loopType, loopStart, loopLength);
        }

        public void init(LowLevelMixer llm, short[] sampleData, double offset, double rate, double volume, double panning, int loopType, int loopStart, int loopLength) {
            this.llm = llm;
            this.sampleData = sampleData;
            this.offsetLeft = this.offsetRight = offset;
            this.offset = this.offsetRight;
            this.rate = rate;
            this.volume = volume;
            this.panning = panning;
            this.loopType = loopType;
            this.loopStart = loopStart;
            this.loopLength = loopLength;
        }

        public void setMute(boolean mute) {
            this.mute = mute;
        }

        public boolean isMute() {
            return this.mute;
        }

        public void mix(int length, int channel) {
            int intOffset;
            int[] outBuffer;
            double vol = this.volume;
            if (channel == 1) {
                vol = this.volume * (1.0 - this.panning);
            } else if (channel == 2) {
                vol = this.volume * this.panning;
            } else if (channel == 3) {
                vol = this.volume;
            }
            if (this.sampleData == null || this.mute || vol == 0.0) {
                return;
            }
            double grad = this.rate / 44100.0;
            if (channel == 3 || channel == 1) {
                outBuffer = DefaultMixer.this.mixerBufferLeft;
                this.offset = this.offsetLeft;
            } else {
                outBuffer = DefaultMixer.this.mixerBufferRight;
                this.offset = this.offsetRight;
            }
            this.tmpBufferStart = intOffset = (int)this.offset;
            this.tmpBufferEnd = intOffset;
            int outOffset = 0;
            while (outOffset < length) {
                if (this.tmpBufferEnd - this.tmpBufferStart <= 16) {
                    this.tmpBufferStart = this.tmpBufferEnd;
                    this.tmpBufferEnd += this.TBL / 2;
                    this.getTrackData(this.tmpBuffer, this.tmpBufferStart, this.tmpBufferEnd, intOffset, vol);
                    intOffset += this.TBL / 2;
                }
                int[] outOffsetH = new int[]{outOffset};
                double[] inOffsetH = new double[]{this.offset};
                this.llm.mix(outBuffer, outOffsetH, length, this.tmpBuffer, inOffsetH, this.tmpBufferEnd, this.TBL, grad);
                outOffset = outOffsetH[0];
                this.offset = inOffsetH[0];
                this.tmpBufferStart = (int)this.offset;
            }
            if (channel == 3 || channel == 1) {
                this.offsetLeft = this.offset;
            } else {
                this.offsetRight = this.offset;
            }
        }

        private int getTrackData(short[] buffer, int bufferStart, int bufferEnd, int sampleOffset, double vol) {
            int res = 0;
            if (this.loopType == 0) {
                res = this.noLoop(buffer, bufferStart, bufferEnd, this.sampleData, sampleOffset, vol);
            } else if (this.loopType == 1) {
                res = this.forwardLoop(buffer, bufferStart, bufferEnd, this.sampleData, sampleOffset, vol, this.loopStart, this.loopLength);
            } else if (this.loopType == 2) {
                res = this.pingPongLoop(buffer, bufferStart, bufferEnd, this.sampleData, sampleOffset, vol, this.loopStart, this.loopLength);
            }
            return res;
        }

        public int noLoop(short[] buffer, int bufferStart, int bufferEnd, short[] sampleData, int sampleOffset, double vol) {
            int bufferLength = buffer.length - 1;
            int bufferOffset = bufferStart;
            int sampleLength = sampleData.length;
            int volume = (int)(vol * 256.0);
            while (sampleOffset < sampleLength && bufferOffset < bufferEnd) {
                buffer[bufferOffset & bufferLength] = (short)(sampleData[sampleOffset] * volume >>> 8);
                ++sampleOffset;
                ++bufferOffset;
            }
            while (bufferOffset < bufferEnd) {
                buffer[bufferOffset & bufferLength] = 0;
                ++bufferOffset;
            }
            return bufferOffset;
        }

        public int forwardLoop(short[] buffer, int bufferStart, int bufferEnd, short[] sampleData, int sampleOffset, double vol, int loopStart, int loopLength) {
            int bufferLength = buffer.length - 1;
            int bufferOffset = bufferStart;
            int sampleLength = loopStart + loopLength;
            if (sampleLength >= sampleData.length) {
                sampleLength = sampleData.length;
            }
            int volume = (int)(vol * 256.0);
            while (sampleOffset < loopStart && bufferOffset < bufferEnd) {
                buffer[bufferOffset & bufferLength] = (short)(sampleData[sampleOffset] * volume >>> 8);
                ++sampleOffset;
                ++bufferOffset;
            }
            while (bufferOffset < bufferEnd) {
                if (sampleOffset >= sampleLength) {
                    sampleOffset = (sampleOffset - loopStart) % loopLength + loopStart;
                }
                buffer[bufferOffset & bufferLength] = (short)(sampleData[sampleOffset] * volume >>> 8);
                ++sampleOffset;
                ++bufferOffset;
            }
            return bufferOffset;
        }

        /*
         * Unable to fully structure code
         */
        public int pingPongLoop(short[] buffer, int bufferStart, int bufferEnd, short[] sampleData, int sampleOffset, double vol, int loopStart, int loopLength) {
            bufferLength = buffer.length - 1;
            bufferOffset = bufferStart;
            volume = (int)(vol * 256.0);
            sampleLength = loopStart + loopLength;
            if (sampleLength >= sampleData.length) {
                sampleLength = sampleData.length;
            }
            while (sampleOffset < sampleLength && bufferOffset < bufferEnd) {
                buffer[bufferOffset & bufferLength] = (short)(sampleData[sampleOffset] * volume >>> 8);
                ++sampleOffset;
                ++bufferOffset;
            }
            sampleOffset = (sampleOffset - loopStart) % (loopLength * 2) + loopStart;
            sampleLengthX2 = sampleLength * 2;
            ** GOTO lbl25
            {
                buffer[bufferOffset & bufferLength] = (short)(sampleData[sampleOffset] * volume >>> 8);
                ++sampleOffset;
                ++bufferOffset;
                do {
                    if (sampleOffset < sampleLength && bufferOffset < bufferEnd) continue block1;
                    while (sampleLengthX2 - sampleOffset > loopStart && bufferOffset < bufferEnd) {
                        buffer[bufferOffset & bufferLength] = (short)(sampleData[sampleLengthX2 - ++sampleOffset] * volume >>> 8);
                        ++bufferOffset;
                    }
                    sampleOffset = loopStart;
lbl25:
                    // 2 sources

                } while (bufferOffset < bufferEnd);
            }
            return bufferOffset;
        }
    }
}

