/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player.effect;

import com.vwp.sound.mod.modplay.player.ModuleState;
import com.vwp.sound.mod.modplay.player.effect.Effect;

public class GlobalEffects
implements Effect {
    private int loopStart;
    private int patternToLoop;
    private int loopCount = -1;
    private double globalVolumeSlideSpeed;

    public void preEffect(ModuleState state, int track, int pattern, int division, int tick, int effectNumber, int arg1, int arg2) {
    }

    public void doEffect(ModuleState state, int track, int pattern, int division, int tick, int effectNumber, int arg1, int arg2) {
        switch (effectNumber) {
            case 15: {
                this.modSetSpeed(state, tick, arg1, arg2);
                break;
            }
            case 16: {
                System.err.println("Set filter not supported @ GlobalEffects.doEffect()");
                break;
            }
            case 22: {
                this.modLoopPatternStart(state, tick, arg1, arg2);
                break;
            }
            case 30: {
                if (tick != 0) break;
                state.setPatternDelay(arg2);
                break;
            }
            case 48: {
                if (tick != 0) break;
                state.getMixer().setVolume((double)(arg1 * 16 + arg2) / 64.0);
                break;
            }
            case 49: {
                this.xmGlobalVolumeSlide(state, tick, arg1, arg2);
                break;
            }
        }
    }

    public void postEffect(ModuleState state, int track, int pattern, int division, int tick, int effectNumber, int arg1, int arg2) {
        switch (effectNumber) {
            case 11: {
                this.modPositionJump(state, tick, arg1, arg2);
                break;
            }
            case 13: {
                this.modPatternBreak(state, tick, arg1, arg2);
                break;
            }
            case 22: {
                this.modLoopPatternEnd(state, tick, arg1, arg2);
            }
        }
    }

    private void modPositionJump(ModuleState state, int tick, int arg1, int arg2) {
        if (tick == state.getTicksInDivision() - 1) {
            if (arg1 * 16 + arg2 > 0) {
                state.jump(arg1 * 16 + arg2 - 1, state.getDivisionsInPattern() - 1, state.getTicksInDivision() - 1);
            } else {
                state.jump(0, 0, state.getTicksInDivision() - 1);
            }
        }
    }

    private void modPatternBreak(ModuleState state, int tick, int arg1, int arg2) {
        if (tick == state.getTicksInDivision() - 1) {
            if (arg1 * 10 + arg2 == 0) {
                state.jump(state.getPosition(), state.getDivisionsInPattern() - 1, state.getTicksInDivision() - 1);
            } else {
                state.jump(state.getPosition() + 1, arg1 * 10 + arg2 - 1, state.getTicksInDivision() - 1);
            }
        }
    }

    private void modLoopPatternStart(ModuleState state, int tick, int arg1, int arg2) {
        if (tick == 0 && arg2 == 0) {
            this.loopStart = state.getDivision();
            this.patternToLoop = state.getPosition();
        }
    }

    private void modLoopPatternEnd(ModuleState state, int tick, int arg1, int arg2) {
        if (tick == state.getTicksInDivision() - 1 && arg2 != 0) {
            if (this.patternToLoop != state.getPosition()) {
                this.patternToLoop = state.getPosition();
                this.loopStart = 0;
            }
            if (this.loopCount == -1) {
                this.loopCount = arg2 - 1;
                state.jump(state.getPosition(), this.loopStart - 1, state.getTicksInDivision() - 1);
            } else if (this.loopCount > 0) {
                --this.loopCount;
                state.jump(state.getPosition(), this.loopStart - 1, state.getTicksInDivision() - 1);
            } else {
                this.loopCount = -1;
            }
        }
    }

    private void xmGlobalVolumeSlide(ModuleState state, int tick, int arg1, int arg2) {
        if (tick == 0) {
            if (arg1 != 0) {
                this.globalVolumeSlideSpeed = (double)arg1 / 64.0;
            } else if (arg2 != 0) {
                this.globalVolumeSlideSpeed = (double)(-arg2) / 64.0;
            }
        }
        if (tick > 0) {
            double vol = state.getMixer().getVolume();
            state.getMixer().setVolume(vol += this.globalVolumeSlideSpeed);
        }
    }

    private void modSetSpeed(ModuleState state, int tick, int arg1, int arg2) {
        if (tick == 0) {
            int z = arg1 * 16 + arg2;
            if (z == 0) {
                z = 1;
            }
            if (z <= 32) {
                state.setSpeed(z);
            } else {
                state.setBpm(z);
            }
        }
    }
}

