/*
 * Decompiled with CFR 0.152.
 */
package examples.applet;

import com.vwp.sound.mod.modplay.ThreadedPlayer;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.sound.output.JavaSoundOutput;
import com.vwp.sound.mod.sound.output.SoundDataFormat;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ThreadedAppletPlayer
extends Applet
implements ActionListener {
    public static final int BITS = 16;
    public static final int RATE = 44100;
    public static final int CHANNELS = 2;
    public static final boolean INTERPOLATE = true;
    public static final int BUFFERSIZE = 500;
    private Module module;
    private URL theUrl;
    private ThreadedPlayer tp;
    private JButton pauseButton;
    private JButton stopButton;
    private JButton playButton;
    private JButton nextButton;
    private JButton prevButton;
    private JLabel moduleLabel;
    private String protocol;
    private String host;
    private int port;
    private List fileList = new ArrayList();
    private int nextModule = 0;

    public void init() {
        this.protocol = this.getParameter("protocol");
        this.host = this.getParameter("host");
        this.port = Integer.parseInt(this.getParameter("port"));
        StringTokenizer st = new StringTokenizer(this.getParameter("files"), ",");
        while (st.hasMoreTokens()) {
            this.fileList.add(st.nextToken());
        }
        this.module = this.loadModule(this.nextModule++);
        this.setLayout(new BorderLayout());
        this.moduleLabel = new JLabel(this.module.getName());
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel("JMOD"));
        p.add(this.moduleLabel);
        this.add((Component)p, "North");
        JPanel playerPanel = new JPanel();
        playerPanel.setLayout(new BoxLayout(playerPanel, 0));
        this.playButton = new JButton(">");
        this.playButton.addActionListener(this);
        this.pauseButton = new JButton("\u2225");
        this.pauseButton.addActionListener(this);
        this.stopButton = new JButton("\u25a1");
        this.stopButton.addActionListener(this);
        this.nextButton = new JButton("\u226b");
        this.nextButton.addActionListener(this);
        this.prevButton = new JButton("\u226a");
        this.prevButton.addActionListener(this);
        playerPanel.add(this.playButton);
        playerPanel.add(this.pauseButton);
        playerPanel.add(this.stopButton);
        playerPanel.add(this.prevButton);
        playerPanel.add(this.nextButton);
        this.add((Component)playerPanel, "South");
        this.tp = this.createPlayer(this.module);
        this.tp.start();
    }

    private ThreadedPlayer createPlayer(Module module) {
        ThreadedPlayer player = new ThreadedPlayer();
        try {
            player.init(new JavaSoundOutput(new SoundDataFormat(16, 44100, 2), 500), true);
            player.load(module);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        player.pause(true);
        return player;
    }

    private Module loadModule(int nextModule) {
        int mc = this.fileList.size();
        while (nextModule <= 0) {
            nextModule += mc;
        }
        try {
            this.theUrl = new URL(this.protocol, this.host, this.port, (String)this.fileList.get((nextModule + mc) % mc));
            return ModuleLoader.getModuleLoader(this.theUrl).getModule();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void start() {
        this.tp.pause(false);
    }

    public void stop() {
        this.tp.pause(true);
    }

    public void destroy() {
        this.tp.stop();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pauseButton) {
            this.tp.pause(!this.tp.isPaused());
        } else if (e.getSource() == this.stopButton) {
            this.tp.stop();
        } else if (e.getSource() == this.playButton) {
            if (!this.tp.isRunning()) {
                this.tp = this.createPlayer(this.module);
                this.tp.pause(false);
                this.tp.start();
            } else if (this.tp.isPaused()) {
                this.tp.pause(false);
            }
        } else if (e.getSource() == this.nextButton) {
            this.tp.stop();
            this.module = this.loadModule(this.nextModule++);
            this.moduleLabel.setText(this.module.getName());
            this.validate();
            this.tp = this.createPlayer(this.module);
            this.tp.start();
            this.tp.pause(false);
        } else if (e.getSource() == this.prevButton) {
            this.tp.stop();
            this.module = this.loadModule(this.nextModule--);
            this.moduleLabel.setText(this.module.getName());
            this.validate();
            this.tp = this.createPlayer(this.module);
            this.tp.start();
            this.tp.pause(false);
        }
    }
}

