/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.toot.javasoundmultiplexed;

import com.frinika.toot.javasoundmultiplexed.JavaSoundDevice;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

class JavaSoundInDevice
extends JavaSoundDevice {
    private int latencyFrames;
    private boolean doFlush = true;
    private long framesRead = 0L;

    public JavaSoundInDevice(Mixer mixer, AudioFormat af, DataLine.Info info, int bufferSizeInFrames) {
        super(mixer, af, info, bufferSizeInFrames);
    }

    public void fillBuffer() {
        if (this.line.available() < this.byteBuffer.length) {
            System.out.println('_');
        } else if (this.doFlush) {
            this.doFlush = false;
            this.line.flush();
            System.out.println(String.valueOf(this.getName()) + " flushed");
        } else {
            this.latencyFrames = (int)(this.line.getLongFramePosition() - this.framesRead);
            try {
                int nread = ((TargetDataLine)this.line).read(this.byteBuffer, 0, this.byteBuffer.length);
                this.framesRead += (long)(nread / 2 / this.af.getChannels());
                if (nread == 0) {
                    System.out.println("active :" + this.line.isActive() + " available:" + this.line.available() + " nByte: " + this.byteBuffer.length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void flush() {
        this.doFlush = true;
    }

    public void start() throws Exception {
        this.framesRead = 0L;
        this.open();
    }

    public void stop() throws Exception {
        this.close();
    }

    public void open() {
        System.out.println(" Opening MixrerAudioDevice line");
        if (this.isOpen()) {
            return;
        }
        try {
            if (this.line == null) {
                this.line = (TargetDataLine)this.mixer.getLine(this.info);
            }
            ((TargetDataLine)this.line).open(this.af);
            System.out.println("  . . ..  Open");
            this.line.flush();
            this.line.start();
            System.out.println("  . . ..  Start  " + this.isOpen());
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.line.close();
    }

    public boolean isActive() {
        if (this.line == null) {
            return false;
        }
        return this.line.isActive();
    }

    public int getLatencyFrames() {
        return this.latencyFrames;
    }
}

