/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.toot.javasoundmultiplexed;

import com.frinika.toot.javasoundmultiplexed.JavaSoundInDevice;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.server.AudioLine;

class MonoInConnection
implements AudioLine {
    private JavaSoundInDevice dev;
    private int chan;
    ChannelFormat chanFormat;
    boolean isBigendian;

    public MonoInConnection(JavaSoundInDevice dev, int channel) {
        this.dev = dev;
        this.chan = channel;
        this.isBigendian = dev.getFormat().isBigEndian();
    }

    public void open() {
        System.out.println(" JavaSoundConnection OPEN" + this.dev);
        this.dev.open();
    }

    public int processAudio(AudioBuffer buffer) {
        float[] out = buffer.getChannel(0);
        byte[] bytes = this.dev.getBuffer();
        if (bytes == null) {
            int n = buffer.getSampleCount();
            int i = 0;
            while (i < n) {
                out[i] = 0.0f;
                ++i;
            }
            return 0;
        }
        int n = buffer.getSampleCount();
        int nchan = this.dev.getChannels();
        if (this.isBigendian) {
            int i = 0;
            while (i < n) {
                float val;
                int ib = i * 2 * nchan + this.chan * 2;
                short sample = (short)((0xFF & bytes[ib + 1]) + (0xFF & bytes[ib]) * 256);
                out[i] = val = (float)sample / 32768.0f;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                float val;
                int ib = i * 2 * nchan + this.chan * 2;
                short sample = (short)((0xFF & bytes[ib]) + (0xFF & bytes[ib + 1]) * 256);
                out[i] = val = (float)sample / 32768.0f;
                ++i;
            }
        }
        return 0;
    }

    public void close() {
    }

    public float getLatencyMilliseconds() {
        return 0.0f;
    }

    public String getName() {
        return "in " + (this.chan + 1);
    }

    public int getLatencyFrames() {
        return 0;
    }

    public ChannelFormat getChannelFormat() {
        return ChannelFormat.MONO;
    }
}

