/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.toot.javasoundmultiplexed;

import com.frinika.toot.javasoundmultiplexed.JavaSoundInDevice;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.server.AudioLine;

class StereoInConnection
implements AudioLine {
    private JavaSoundInDevice dev;
    private int[] chan;
    ChannelFormat chanFormat;
    boolean isBigendian;

    public StereoInConnection(JavaSoundInDevice dev, int[] chan) {
        this.dev = dev;
        this.isBigendian = dev.getFormat().isBigEndian();
        this.chan = new int[chan.length];
        int i = 0;
        while (i < chan.length) {
            this.chan[i] = chan[i];
            ++i;
        }
    }

    public void open() {
        System.out.println(" JavaSoundConnection OPEN" + this.dev);
        this.dev.open();
    }

    public int processAudio(AudioBuffer buffer) {
        byte[] bytes = this.dev.getBuffer();
        if (bytes == null) {
            int n = buffer.getSampleCount();
            int ch = 0;
            while (ch < this.chan.length) {
                float[] out = buffer.getChannel(ch);
                int i = 0;
                while (i < n) {
                    out[i] = 0.0f;
                    ++i;
                }
                ++ch;
            }
            return 0;
        }
        int n = buffer.getSampleCount();
        int nchan = this.dev.getChannels();
        if (this.isBigendian) {
            int ch = 0;
            while (ch < this.chan.length) {
                int chanO = this.chan[ch];
                float[] out = buffer.getChannel(ch);
                int i = 0;
                while (i < n) {
                    float val;
                    int ib = i * 2 * nchan + chanO * 2;
                    short sample = (short)((0xFF & bytes[ib + 1]) + (0xFF & bytes[ib]) * 256);
                    out[i] = val = (float)sample / 32768.0f;
                    ++i;
                }
                ++ch;
            }
        } else {
            int ch = 0;
            while (ch < this.chan.length) {
                int chanO = this.chan[ch];
                float[] out = buffer.getChannel(ch);
                int i = 0;
                while (i < n) {
                    float val;
                    int ib = i * 2 * nchan + chanO * 2;
                    short sample = (short)((0xFF & bytes[ib]) + (0xFF & bytes[ib + 1]) * 256);
                    out[i] = val = (float)sample / 32768.0f;
                    ++i;
                }
                ++ch;
            }
        }
        return 0;
    }

    public void close() {
    }

    public float getLatencyMilliseconds() {
        return 0.0f;
    }

    public String getName() {
        return "in " + (this.chan[0] + 1) + "/" + (this.chan[1] + 1);
    }

    public int getLatencyFrames() {
        return 0;
    }

    public ChannelFormat getChannelFormat() {
        return ChannelFormat.STEREO;
    }
}

