/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.toot.javasoundmultiplexed;

import com.frinika.toot.javasoundmultiplexed.JavaSoundOutDevice;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.server.AudioLine;

class StereoOutConnection
implements AudioLine {
    private JavaSoundOutDevice dev;
    private int[] chan;
    ChannelFormat chanFormat;
    boolean isBigEndian;

    public StereoOutConnection(JavaSoundOutDevice dev, int[] chan) {
        this.dev = dev;
        this.chan = new int[chan.length];
        int i = 0;
        while (i < chan.length) {
            this.chan[i] = chan[i];
            ++i;
        }
        this.isBigEndian = dev.getFormat().isBigEndian();
    }

    public int processAudio(AudioBuffer buffer) {
        byte[] bytes = this.dev.getBuffer();
        assert (bytes != null);
        int n = buffer.getSampleCount();
        int nchan = this.dev.getChannels();
        int chPtr = 0;
        while (chPtr < this.chan.length) {
            short sample;
            int ib;
            int i;
            int ch = this.chan[chPtr];
            float[] out = buffer.getChannel(chPtr);
            if (this.isBigEndian) {
                i = 0;
                while (i < n) {
                    ib = i * 2 * nchan + ch * 2;
                    sample = (short)(out[i] * 32768.0f);
                    bytes[ib + 1] = (byte)(0xFF & sample);
                    bytes[ib] = (byte)(0xFF & sample >> 8);
                    ++i;
                }
            } else {
                i = 0;
                while (i < n) {
                    ib = i * 2 * nchan + ch * 2;
                    sample = (short)(out[i] * 32768.0f);
                    bytes[ib + 1] = (byte)(0xFF & sample >> 8);
                    bytes[ib] = (byte)(0xFF & sample);
                    ++i;
                }
            }
            ++chPtr;
        }
        return 0;
    }

    public void close() {
    }

    public float getLatencyMilliseconds() {
        return 0.0f;
    }

    public String getName() {
        return "out " + (this.chan[0] + 1) + "/" + (this.chan[1] + 1);
    }

    public int getLatencyFrames() {
        return 0;
    }

    public ChannelFormat getChannelFormat() {
        return ChannelFormat.MONO;
    }

    public void open() {
    }
}

