/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.server;

import java.util.ArrayList;
import java.util.List;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.server.AbstractAudioServer;

public abstract class BasicAudioServer
extends AbstractAudioServer {
    private List<AudioBuffer> audioBuffers = new ArrayList<AudioBuffer>();
    private float sampleRate = 44100.0f;
    protected int channelCount = 2;
    private int bufferFrames;

    public BasicAudioServer() {
    }

    public BasicAudioServer(float sampleRate, int channels) {
        this.sampleRate = sampleRate;
        this.channelCount = channels;
    }

    protected AudioBuffer _createAudioBuffer(String name) {
        this.bufferFrames = this.calculateBufferFrames();
        return new AudioBuffer(name, this.channelCount, this.bufferFrames, this.sampleRate);
    }

    public AudioBuffer createAudioBuffer(String name) {
        AudioBuffer buffer = this._createAudioBuffer(name);
        this.audioBuffers.add(buffer);
        return buffer;
    }

    public void removeAudioBuffer(AudioBuffer buffer) {
        this.audioBuffers.remove(buffer);
    }

    protected int calculateBufferFrames() {
        return (int)(this.sampleRate * this.getBufferMilliseconds() / 1000.0f);
    }

    protected void resizeBuffers() {
        this.bufferFrames = this.calculateBufferFrames();
        for (AudioBuffer buffer : this.audioBuffers) {
            buffer.changeSampleCount(this.bufferFrames, false);
        }
    }

    protected void work() {
        this.client.work(this.bufferFrames);
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float sampleRate) {
        this.sampleRate = sampleRate;
    }
}

