/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.audioui.serverui;

import com.frinika.toot.PriorityAudioServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.org.toot.audio.server.AudioServerConfiguration;
import uk.org.toot.audio.server.ExtendedAudioServer;
import uk.org.toot.audio.server.JavaSoundAudioServer;
import uk.org.toot.swing.SpringUtilities;

public class AudioServerPanel
extends JPanel
implements ActionListener {
    private ExtendedAudioServer server;
    private AudioServerConfiguration config;
    private int periodMilliseconds = 2000;
    private JFormattedTextField hardwareFrames;
    private JSpinner bufferMillis;
    private JSpinner latencyMillis;
    private JLabel actualLatencyMillis;
    private JLabel lowestLatencyMillis;
    private JLabel totalLatencyMillis;
    private JLabel maxJitterMillis;
    private JLabel bufferUnderRuns;
    private JLabel loadTimePercent;
    private JLabel peakLoadTimePercent;
    private JLabel cpuPercent;
    private JLabel userPercent;
    private JLabel blockedPercent;
    private JLabel waitedPercent;
    private JLabel gc1Count;
    private JLabel gc1Millis;
    private JLabel gc2Count;
    private JLabel gc2Millis;
    private List<JLabel> outputLatencyLabels = new ArrayList<JLabel>();
    private List<JLabel> inputLatencyLabels = new ArrayList<JLabel>();
    private long prevNanos = 0L;
    private long prevCpuNanos = 0L;
    private long prevUserNanos = 0L;
    private long prevBlockedMillis = 0L;
    private long prevWaitedMillis = 0L;
    private boolean eachIOlatency = true;
    private boolean gcAccounting = false;
    private int underRunCount = 0;
    private Timer timer;
    private DateFormat shortTime;
    private static long id = -1L;
    private static ThreadMXBean mxbean;
    private static boolean hasCpuTime;
    private static boolean hasContentionMonitoring;
    private static boolean isLinux;
    private static Dimension spinnerSize;

    static {
        hasCpuTime = false;
        hasContentionMonitoring = false;
        isLinux = System.getProperty("os.name").equals("Linux");
        spinnerSize = new Dimension(50, 24);
    }

    public AudioServerPanel(ExtendedAudioServer server, AudioServerConfiguration config) {
        this.server = server;
        this.config = config;
        this.eachIOlatency = server instanceof JavaSoundAudioServer;
        this.shortTime = DateFormat.getTimeInstance(3);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildManagementPanel(), "West");
        this.add((Component)this.buildButtonPanel(), "South");
        this.timer = new Timer(this.periodMilliseconds, this);
        this.timer.start();
    }

    protected void dispose() {
        this.timer.stop();
        this.removeAll();
        mxbean = null;
        this.server = null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.server == null) {
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        this.actualLatencyMillis.setText(this.dpString(this.server.getActualLatencyMilliseconds(), 1));
        this.lowestLatencyMillis.setText(this.dpString(this.server.getLowestLatencyMilliseconds(), 1));
        float totalLatencyFrames = this.server.getTotalLatencyFrames();
        float totalLatency = 1000.0f * totalLatencyFrames / this.server.getSampleRate();
        this.totalLatencyMillis.setText(this.dpString(totalLatency, 1));
        this.maxJitterMillis.setText(this.dpString(this.server.getMaximumJitterMilliseconds(), 1));
        int underRuns = this.server.getBufferUnderRuns();
        this.bufferUnderRuns.setText(String.valueOf(underRuns));
        this.loadTimePercent.setText(String.valueOf(Math.round(100.0f * this.server.getLoad())));
        this.peakLoadTimePercent.setText(String.valueOf(Math.round(100.0f * this.server.getPeakLoad())));
        this.hardwareFrames.setValue(this.server.getHardwareLatencyFrames());
        if (underRuns != this.underRunCount) {
            String time = this.shortTime.format(new Date());
            System.err.println(String.valueOf(time) + " UnderRun " + underRuns + ", L=" + this.dpString(this.server.getLowestLatencyMilliseconds(), 1) + "ms, J=" + this.dpString(this.server.getMaximumJitterMilliseconds(), 1) + "ms, T=" + String.valueOf(Math.round(100.0f * this.server.getPeakLoad())) + "%");
            this.underRunCount = underRuns;
            this.server.resetMetrics(false);
        }
        if (this.eachIOlatency) {
            float latencyMillis;
            int i = 0;
            while (i < this.outputLatencyLabels.size()) {
                latencyMillis = (float)(1000 * this.server.getOutputs().get(i).getLatencyFrames()) / this.server.getSampleRate();
                this.outputLatencyLabels.get(i).setText(this.dpString(latencyMillis, 1));
                ++i;
            }
            i = 0;
            while (i < this.inputLatencyLabels.size()) {
                latencyMillis = (float)(1000 * this.server.getInputs().get(i).getLatencyFrames()) / this.server.getSampleRate();
                this.inputLatencyLabels.get(i).setText(this.dpString(latencyMillis, 1));
                ++i;
            }
        }
        if (mxbean == null) {
            return;
        }
        if (id < 0L) {
            id = AudioServerPanel.getThreadId("AudioServer");
        }
        if (id < 0L) {
            return;
        }
        long nanos = System.nanoTime();
        long elapsed = nanos - this.prevNanos;
        this.prevNanos = nanos;
        if (hasCpuTime) {
            long cpuNanos = mxbean.getThreadCpuTime(id);
            this.cpuPercent.setText(String.valueOf(Math.round(100L * (cpuNanos - this.prevCpuNanos) / elapsed)));
            this.prevCpuNanos = cpuNanos;
            long userNanos = mxbean.getThreadUserTime(id);
            this.userPercent.setText(String.valueOf(Math.round(100L * (userNanos - this.prevUserNanos) / elapsed)));
            this.prevUserNanos = userNanos;
        }
        if (hasContentionMonitoring) {
            ThreadInfo info = mxbean.getThreadInfo(id);
            if (info == null) {
                return;
            }
            long blockedMillis = info.getBlockedTime();
            this.blockedPercent.setText(String.valueOf(Math.round(100L * (blockedMillis - this.prevBlockedMillis) / (elapsed /= 1000000L))));
            this.prevBlockedMillis = blockedMillis;
            long waitedMillis = info.getWaitedTime();
            this.waitedPercent.setText(String.valueOf(Math.round(100L * (waitedMillis - this.prevWaitedMillis) / elapsed)));
            this.prevWaitedMillis = waitedMillis;
        }
        if (this.gcAccounting) {
            List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
            int ngc = gcbeans.size();
            if (ngc > 0) {
                GarbageCollectorMXBean gcbean = gcbeans.get(0);
                this.gc1Count.setText(String.valueOf(gcbean.getCollectionCount()));
                this.gc1Millis.setText(String.valueOf(gcbean.getCollectionTime()));
            }
            if (ngc > 1) {
                GarbageCollectorMXBean gcbean = gcbeans.get(1);
                this.gc1Count.setText(String.valueOf(gcbean.getCollectionCount()));
                this.gc1Millis.setText(String.valueOf(gcbean.getCollectionTime()));
            }
        }
    }

    protected String dpString(float ms, int dp) {
        return String.format("%1$." + dp + "f", Float.valueOf(ms));
    }

    protected static long getThreadId(String threadName) {
        long[] ids = mxbean.getAllThreadIds();
        int i = 0;
        while (i < ids.length) {
            if (mxbean.getThreadInfo(ids[i]).getThreadName().equals(threadName)) {
                return ids[i];
            }
            ++i;
        }
        return -1L;
    }

    protected void addRow(JPanel p, String label, JComponent comp, String units) {
        JLabel l = new JLabel(String.valueOf(label) + " :", 11);
        p.add(l);
        l.setLabelFor(comp);
        p.add(comp);
        l = new JLabel(units, 10);
        p.add(l);
        l.setLabelFor(comp);
    }

    protected JPanel buildButtonPanel() {
        JPanel p = new JPanel();
        JButton reset = new JButton("Reset");
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AudioServerPanel.this.server.resetMetrics(true);
            }
        });
        p.add(reset);
        return p;
    }

    protected JPanel buildManagementPanel() {
        JPanel p = new JPanel(new SpringLayout());
        int nrows = 0;
        this.addRow(p, "Sample Rate", new JLabel(String.valueOf((int)this.server.getSampleRate()), 0), "Hz");
        this.addRow(p, "Sample Size", new JLabel(String.valueOf(this.server.getSampleSizeInBits()), 0), "bits");
        nrows += 2;
        if (isLinux && this.server instanceof PriorityAudioServer) {
            final PriorityAudioServer pas = (PriorityAudioServer)this.server;
            int prio = pas.getPriority();
            if (prio < 0 || prio > 99) {
                prio = 0;
            }
            final SpinnerNumberModel priorityModel = new SpinnerNumberModel(prio, 0, 99, 1);
            Spinner priority = new Spinner(priorityModel);
            priority.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    pas.requestPriority(priorityModel.getNumber().intValue());
                    AudioServerPanel.this.config.update();
                }
            });
            this.addRow(p, "Priority", priority, "");
            ++nrows;
        }
        this.hardwareFrames = new JFormattedTextField();
        this.hardwareFrames.setValue(new Integer(this.server.getHardwareLatencyFrames()));
        this.hardwareFrames.setColumns(4);
        this.hardwareFrames.setHorizontalAlignment(11);
        this.hardwareFrames.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AudioServerPanel.this.server.setHardwareLatencyFrames(((Number)AudioServerPanel.this.hardwareFrames.getValue()).intValue());
                AudioServerPanel.this.config.update();
            }
        });
        this.addRow(p, "Hardware Buffer", this.hardwareFrames, "frames");
        ++nrows;
        final SpinnerNumberModel bufferModel = new SpinnerNumberModel((int)this.server.getBufferMilliseconds(), 1, 10, 1);
        this.bufferMillis = new Spinner(bufferModel);
        this.bufferMillis.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AudioServerPanel.this.server.setBufferMilliseconds(bufferModel.getNumber().intValue());
                AudioServerPanel.this.config.update();
            }
        });
        final SpinnerNumberModel latencyModel = new SpinnerNumberModel((int)this.server.getLatencyMilliseconds(), (int)this.server.getMinimumLatencyMilliseconds(), (int)this.server.getMaximumLatencyMilliseconds(), 1);
        this.latencyMillis = new Spinner(latencyModel);
        this.latencyMillis.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                float latencyms = latencyModel.getNumber().intValue();
                AudioServerPanel.this.server.setLatencyMilliseconds(latencyms);
                AudioServerPanel.this.config.update();
            }
        });
        this.actualLatencyMillis = new JLabel("n/a", 0);
        this.lowestLatencyMillis = new JLabel("n/a", 0);
        this.totalLatencyMillis = new JLabel("n/a", 0);
        this.maxJitterMillis = new JLabel("n/a", 0);
        this.bufferUnderRuns = new JLabel("n/a", 0);
        this.loadTimePercent = new JLabel("n/a", 0);
        this.peakLoadTimePercent = new JLabel("n/a", 0);
        this.addRow(p, "Internal Buffer", this.bufferMillis, "ms");
        this.addRow(p, "Requested Latency", this.latencyMillis, "ms");
        this.addRow(p, "Actual Latency", this.actualLatencyMillis, "ms");
        this.addRow(p, "Lowest Latency", this.lowestLatencyMillis, "ms");
        this.addRow(p, "Total Latency", this.totalLatencyMillis, "ms");
        this.addRow(p, "Maximum Jitter", this.maxJitterMillis, "ms");
        this.addRow(p, "Buffer UnderRuns", this.bufferUnderRuns, "");
        this.addRow(p, "Time Load", this.loadTimePercent, "%");
        this.addRow(p, "Peak Time Load", this.peakLoadTimePercent, "%");
        nrows += 9;
        if (this.eachIOlatency) {
            int i = 0;
            while (i < this.server.getOutputs().size()) {
                JLabel outputLatency = new JLabel("n/a", 0);
                this.outputLatencyLabels.add(outputLatency);
                this.addRow(p, String.valueOf(this.server.getOutputs().get(i).getName()) + " Latency", outputLatency, "ms");
                ++nrows;
                ++i;
            }
            i = 0;
            while (i < this.server.getInputs().size()) {
                JLabel inputLatency = new JLabel("n/a", 0);
                this.inputLatencyLabels.add(inputLatency);
                this.addRow(p, String.valueOf(this.server.getInputs().get(i).getName()) + " Latency", inputLatency, "ms");
                ++nrows;
                ++i;
            }
        }
        if (hasCpuTime) {
            this.cpuPercent = new JLabel("n/a", 0);
            this.userPercent = new JLabel("n/a", 0);
            this.addRow(p, "Thread CPU", this.cpuPercent, "%");
            this.addRow(p, "Thread User", this.userPercent, "%");
            nrows += 2;
        }
        if (hasContentionMonitoring) {
            this.blockedPercent = new JLabel("n/a", 0);
            this.waitedPercent = new JLabel("n/a", 0);
            this.addRow(p, "Thread Blocked", this.blockedPercent, "%");
            this.addRow(p, "Thread Waited", this.waitedPercent, "%");
            nrows += 2;
        }
        if (this.gcAccounting) {
            this.gc1Count = new JLabel("n/a", 0);
            this.gc1Millis = new JLabel("n/a", 0);
            this.gc2Count = new JLabel("n/a", 0);
            this.gc2Millis = new JLabel("n/a", 0);
            this.addRow(p, "GC [1] Count", this.gc1Count, "");
            this.addRow(p, "GC [1] Time", this.gc1Millis, "ms");
            this.addRow(p, "GC [2] Count", this.gc2Count, "");
            this.addRow(p, "GC [2] Time", this.gc2Millis, "ms");
            nrows += 4;
        }
        SpringUtilities.makeCompactGrid((Container)p, (int)nrows, (int)3, (int)6, (int)6, (int)6, (int)6);
        return p;
    }

    protected static class Spinner
    extends JSpinner {
        public Spinner(SpinnerModel model) {
            super(model);
        }

        public Dimension getMaximumSize() {
            return spinnerSize;
        }

        public Dimension getPreferredSize() {
            return spinnerSize;
        }
    }
}

