/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import rasmus.editor.RasmusEditor;
import rasmus.editor.ScriptDocument;
import rasmus.editor.TableEditor;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.midi.MidiKeyListener;
import rasmus.interpreter.parser.ScriptElement;
import rasmus.interpreter.parser.ScriptParser;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sampled.midi.InstrumentRecord;
import rasmus.midi.provider.RasmusSoundbankReader;

public class InstrumentsTree
extends JPanel {
    private static final long serialVersionUID = 1L;
    DefaultTreeModel model;
    JScrollPane scrollpane;
    JTree tree;
    ArrayList<ActionListener> actionlisteners = new ArrayList();
    HashMap<String, DefaultMutableTreeNode> insmap = new HashMap();
    HashMap<String, DefaultMutableTreeNode> gm_insmap = new HashMap();
    Variable instruments_var;
    Commitable inst_commit = new Commitable(){

        public int getRunLevel() {
            return 0;
        }

        public void commit() {
            if (InstrumentsTree.this.isInFileSelectionMode()) {
                return;
            }
            List list = ObjectsPart.asList(InstrumentsTree.this.instruments_var);
            if (list.size() == 0) {
                InstrumentsTree.this.tree.setModel(InstrumentsTree.this.gmmodel);
                InstrumentsTree.this.insmap = InstrumentsTree.this.gm_insmap;
            } else {
                DefaultMutableTreeNode instruments = new DefaultMutableTreeNode("Instruments");
                TreeSet<InstrumentRecord> ins_sort = new TreeSet<InstrumentRecord>(new Comparator<InstrumentRecord>(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public int compare(InstrumentRecord arg0, InstrumentRecord arg1) {
                        int a = arg0.bank * 128 + arg0.program;
                        int b = arg1.bank * 128 + arg1.program;
                        return a - b;
                    }
                });
                for (Object object : list) {
                    if (!(object instanceof InstrumentRecord) || !((InstrumentRecord)object).channels[0]) continue;
                    ins_sort.add((InstrumentRecord)object);
                }
                InstrumentsTree.this.insmap = new HashMap();
                DefaultMutableTreeNode bank = null;
                int curbank = -1;
                for (InstrumentRecord element : ins_sort) {
                    String desc = element.description;
                    InstrumentItem insitem = new InstrumentItem(desc, String.valueOf(element.program) + "," + element.bank);
                    DefaultMutableTreeNode ins = new DefaultMutableTreeNode(insitem);
                    if (curbank != element.bank) {
                        curbank = element.bank;
                        bank = new DefaultMutableTreeNode("Bank " + curbank);
                        instruments.add(bank);
                    }
                    bank.add(ins);
                    InstrumentsTree.this.insmap.put(insitem.program, ins);
                }
                InstrumentsTree.this.tree.setModel(new DefaultTreeModel(instruments));
            }
        }
    };
    DefaultTreeModel gmmodel;
    boolean ins_set = false;
    Receiver recv_midiin = new Receiver(){

        public void send(MidiMessage msg, long tick) {
            if (!InstrumentsTree.this.ins_set) {
                InstrumentsTree.this.procSessMidiSetup();
                InstrumentsTree.this.ins_set = true;
            }
            InstrumentsTree.this.teditor.sendMessage(msg);
        }

        public void close() {
        }
    };
    Receiver recv = new Receiver(){

        public void send(MidiMessage msg, long tick) {
            ShortMessage sms;
            if (!InstrumentsTree.this.ins_set) {
                InstrumentsTree.this.procSessMidiSetup();
                InstrumentsTree.this.ins_set = true;
            }
            if (msg instanceof ShortMessage && (sms = (ShortMessage)msg).getCommand() == 144 && sms.getData2() > 0) {
                try {
                    ShortMessage newmsg = new ShortMessage();
                    newmsg.setMessage(sms.getCommand(), sms.getChannel(), sms.getData1(), InstrumentsTree.this.teditor.midi_setup_v);
                    msg = newmsg;
                }
                catch (InvalidMidiDataException e) {
                    e.printStackTrace();
                }
            }
            InstrumentsTree.this.teditor.sendMessage(msg);
        }

        public void close() {
        }
    };
    MidiKeyListener keylistener = new MidiKeyListener();
    TableEditor teditor;
    JFileChooser soundbankpresetchooser;
    FileFilter soundfont_filefilter;
    SoundFontAccessory sfa;
    boolean is_InFileSelectionMode;
    String emptypreset;
    RasmusEditor editor;

    public void setSelectedItem(String value) {
        if (this.isInFileSelectionMode()) {
            return;
        }
        DefaultMutableTreeNode ins = this.insmap.get(value);
        if (ins == null) {
            this.tree.setSelectionPath(null);
        } else {
            TreePath path = new TreePath(ins.getPath());
            this.tree.setSelectionPath(path);
            Rectangle bounds = this.tree.getPathBounds(path);
            this.tree.scrollRectToVisible(bounds);
        }
    }

    public String getSelectedItem() {
        if (this.isInFileSelectionMode() && this.sfa != null) {
            return this.sfa.getSelectedItem();
        }
        TreePath treepath = this.tree.getSelectionPath();
        if (treepath == null) {
            return null;
        }
        DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)treepath.getLastPathComponent();
        Object uobject = treenode.getUserObject();
        if (!(uobject instanceof InstrumentItem)) {
            return null;
        }
        return ((InstrumentItem)uobject).program;
    }

    public void addActionListener(ActionListener listener) {
        this.actionlisteners.add(listener);
    }

    public void fireChangeSelection() {
        ActionEvent event = new ActionEvent(this, 0, null);
        Iterator<ActionListener> iter = this.actionlisteners.iterator();
        while (iter.hasNext()) {
            iter.next().actionPerformed(event);
        }
    }

    public void procSessMidiSetup() {
        this.teditor.midi_setup_lastbeat = 0.0;
        this.teditor.midi_setup_lastcol = -1;
        this.teditor.procSessMidiSetup(false);
        this.teditor.midi_setup_lastbeat = 0.0;
        this.teditor.midi_setup_lastcol = -1;
        String str_i = this.getSelectedItem();
        if (str_i == null) {
            return;
        }
        String program = str_i;
        String bank = null;
        int li = str_i.indexOf(",");
        if (li != -1) {
            bank = program.substring(li + 1);
            program = program.substring(0, li);
        }
        if (bank != null) {
            int i_bank = Integer.parseInt(bank);
            if (i_bank < 0) {
                i_bank = 0;
            }
            if (i_bank > 16256) {
                i_bank = 16256;
            }
            int m_bank = i_bank / 128;
            try {
                ShortMessage smsg = new ShortMessage();
                smsg.setMessage(176, this.teditor.midi_setup_c - 1, 0, m_bank);
                this.teditor.sendMessage(smsg);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            int l_bank = i_bank % 128;
            try {
                ShortMessage smsg = new ShortMessage();
                smsg.setMessage(176, this.teditor.midi_setup_c - 1, 32, l_bank);
                this.teditor.sendMessage(smsg);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
        try {
            int i_program = Integer.parseInt(program);
            ShortMessage smsg = new ShortMessage();
            smsg.setMessage(192, this.teditor.midi_setup_c - 1, i_program, 0);
            this.teditor.sendMessage(smsg);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public JFileChooser getFileChooser() {
        if (this.soundbankpresetchooser != null) {
            this.sfa.selectedPreset = null;
            return this.soundbankpresetchooser;
        }
        this.soundbankpresetchooser = new JFileChooser();
        this.soundbankpresetchooser.setDialogTitle("Add Instrument(s)");
        this.soundbankpresetchooser.addChoosableFileFilter(this.soundfont_filefilter);
        this.soundbankpresetchooser.setAcceptAllFileFilterUsed(true);
        this.soundbankpresetchooser.setFileFilter(this.soundfont_filefilter);
        this.sfa = new SoundFontAccessory(this.soundbankpresetchooser);
        this.sfa.selectedPreset = null;
        return this.soundbankpresetchooser;
    }

    public boolean isInFileSelectionMode() {
        return this.is_InFileSelectionMode;
    }

    public void setInFileSelectionMode(boolean val) {
        if (this.sfa != null) {
            this.sfa.unloadTestPreset();
        }
        this.is_InFileSelectionMode = val;
    }

    public String getEmptyPresetIdent() {
        if (this.emptypreset != null) {
            return this.emptypreset;
        }
        List list = ObjectsPart.asList(this.instruments_var);
        Iterator iter = list.iterator();
        TreeSet<InstrumentRecord> ins_sort = new TreeSet<InstrumentRecord>(new Comparator<InstrumentRecord>(){

            @Override
            public int compare(InstrumentRecord arg0, InstrumentRecord arg1) {
                int a = arg0.bank * 128 + arg0.program;
                int b = arg1.bank * 128 + arg1.program;
                return a - b;
            }
        });
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof InstrumentRecord) || !((InstrumentRecord)element).channels[0]) continue;
            InstrumentRecord ielement = (InstrumentRecord)element;
            ins_sort.add(ielement);
        }
        int targetid = 0;
        for (InstrumentRecord ielement : ins_sort) {
            int ins_id = ielement.bank * 128 + ielement.program;
            if (ins_id != targetid) break;
            ++targetid;
        }
        this.emptypreset = String.valueOf(targetid % 128) + "," + targetid / 128;
        return this.emptypreset;
    }

    public InstrumentsTree(RasmusEditor editor, TableEditor teditor) {
        this.keylistener.setReceiver(this.recv);
        this.soundbankpresetchooser = null;
        this.soundfont_filefilter = new FileFilter(){

            public boolean accept(File arg0) {
                if (!arg0.isFile()) {
                    return true;
                }
                return arg0.getName().toLowerCase().endsWith(".sf2");
            }

            public String getDescription() {
                return "SoundFont 2.x (*.sf2)";
            }
        };
        this.is_InFileSelectionMode = false;
        this.emptypreset = null;
        this.teditor = teditor;
        this.editor = editor;
        this.setLayout(new BorderLayout());
        this.tree = new JTree(){
            private static final long serialVersionUID = 1L;

            public void processKeyEvent(KeyEvent e) {
                if (e.getModifiers() > 1) {
                    super.processKeyEvent(e);
                    return;
                }
                if (e.getKeyCode() == 0) {
                    return;
                }
                if (e.getID() == 401) {
                    this.keyPressed(e);
                }
                if (e.getID() == 402) {
                    this.keyReleased(e);
                }
                if (e.getID() == 400) {
                    this.keyTyped(e);
                }
                if (!e.isConsumed()) {
                    super.processKeyEvent(e);
                }
            }

            public void keyPressed(KeyEvent e) {
                InstrumentsTree.this.keylistener.keyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
                InstrumentsTree.this.keylistener.keyReleased(e);
            }

            public void keyTyped(KeyEvent e) {
                InstrumentsTree.this.keylistener.keyTyped(e);
            }
        };
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent arg0) {
                InstrumentsTree.this.ins_set = false;
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    InstrumentsTree.this.fireChangeSelection();
                }
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                InstrumentsTree.this.keylistener.allNotesOff();
                InstrumentsTree.this.ins_set = false;
            }

            public void focusLost(FocusEvent arg0) {
                InstrumentsTree.this.keylistener.allNotesOff();
                InstrumentsTree.this.ins_set = false;
            }
        });
        DefaultMutableTreeNode instruments = new DefaultMutableTreeNode("Instruments");
        this.gm_insmap = this.insmap;
        this.gmmodel = new DefaultTreeModel(instruments);
        this.instruments_var = editor.namespace.get("instruments");
        ObjectsPart.getInstance(this.instruments_var).addListener(new ListPartListener(){

            public void objectAdded(ListPart source, Object object) {
                InstrumentsTree.this.editor.namespace.addToCommitStack(InstrumentsTree.this.inst_commit);
            }

            public void objectRemoved(ListPart source, Object object) {
                InstrumentsTree.this.editor.namespace.addToCommitStack(InstrumentsTree.this.inst_commit);
            }

            public void objectsAdded(ListPart source, List objects) {
                InstrumentsTree.this.editor.namespace.addToCommitStack(InstrumentsTree.this.inst_commit);
            }

            public void objectsRemoved(ListPart source, List objects) {
                InstrumentsTree.this.editor.namespace.addToCommitStack(InstrumentsTree.this.inst_commit);
            }
        });
        this.inst_commit.commit();
        JPanel buttonpanel = new JPanel();
        buttonpanel.setBackground(UIManager.getColor("TabbedPane.contentAreaColor"));
        JButton addbutton = new JButton("Add..");
        addbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                InstrumentsTree.this.emptypreset = null;
                JFileChooser fc = InstrumentsTree.this.getFileChooser();
                InstrumentsTree.this.ins_set = false;
                InstrumentsTree.this.setInFileSelectionMode(true);
                int ret = fc.showOpenDialog(InstrumentsTree.this.editor);
                InstrumentsTree.this.setInFileSelectionMode(false);
                InstrumentsTree.this.ins_set = false;
                if (ret == 0) {
                    int streammode;
                    String path;
                    try {
                        path = fc.getSelectedFile().getCanonicalPath();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                    String pathcode = "\"" + path + "\"";
                    if (InstrumentsTree.this.editor.session.getWorkDirectory() != null) {
                        try {
                            String wpath = InstrumentsTree.this.editor.session.getWorkDirectory().getCanonicalPath();
                            if (!wpath.endsWith(File.separator)) {
                                wpath = String.valueOf(wpath) + File.separator;
                            }
                            if (path.startsWith(wpath)) {
                                path = path.substring(wpath.length());
                                pathcode = "wrkdir & \"" + path + "\"";
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((streammode = InstrumentsTree.this.sfa.streammode.getSelectedIndex()) < 0) {
                        streammode = 0;
                    }
                    if (streammode > 1) {
                        streammode = 0;
                    }
                    String options = "";
                    if (streammode == 0) {
                        options = ",streammode=1";
                    }
                    if (InstrumentsTree.this.sfa.selectedPreset != null) {
                        String seltarget = InstrumentsTree.this.getEmptyPresetIdent();
                        Object sel = JOptionPane.showInputDialog(InstrumentsTree.this.editor, "Target program, bank:", "Add soundbank preset", 3, null, null, seltarget);
                        if (sel == null) {
                            return;
                        }
                        seltarget = sel.toString().trim();
                        String code = "\ninstruments <- instrument(" + seltarget + ",\"" + InstrumentsTree.this.sfa.selectedPresetDescription.trim() + "\"" + ") <- soundbankpreset(" + pathcode + "," + InstrumentsTree.this.sfa.selectedPreset + options + ");";
                        InstrumentsTree.this.editor.doc.getObject("instruments").add(code);
                        InstrumentsTree.this.editor.commit();
                        InstrumentsTree.this.setSelectedItem(seltarget);
                        return;
                    }
                    List list = ObjectsPart.asList(InstrumentsTree.this.instruments_var);
                    Iterator iter = list.iterator();
                    TreeSet<Integer> banksinuse = new TreeSet<Integer>();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (!(element instanceof InstrumentRecord)) continue;
                        InstrumentRecord ielement = (InstrumentRecord)element;
                        if (banksinuse.contains(ielement.bank)) continue;
                        banksinuse.add(ielement.bank);
                    }
                    int emptybank = 0;
                    while (banksinuse.contains(emptybank)) {
                        ++emptybank;
                    }
                    Object selectedbank = JOptionPane.showInputDialog(InstrumentsTree.this.editor, "Target bank:", "Add soundbank", 3, null, null, Integer.toString(emptybank));
                    if (selectedbank == null) {
                        return;
                    }
                    String s_selectedbank = selectedbank.toString().trim();
                    String code = selectedbank.equals("0") ? "\ninstruments <- soundbank(" + pathcode + options + ");" : "\ninstruments <- soundbank(" + pathcode + "," + s_selectedbank + options + ");";
                    InstrumentsTree.this.editor.doc.getObject("instruments").add(code);
                    InstrumentsTree.this.editor.commit();
                }
            }
        });
        JButton removebutton = new JButton("Remove");
        removebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TreeSet<Integer> allbanks = new TreeSet<Integer>();
                TreeSet<Integer> banks = new TreeSet<Integer>();
                TreeSet<String> programs = new TreeSet<String>();
                TreePath[] treepaths = InstrumentsTree.this.tree.getSelectionPaths();
                int i = 0;
                while (i < treepaths.length) {
                    TreePath treepath = treepaths[i];
                    DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)treepath.getLastPathComponent();
                    Object uobject = treenode.getUserObject();
                    if (uobject instanceof InstrumentItem) {
                        InstrumentItem ielement = (InstrumentItem)uobject;
                        int li = ielement.program.indexOf(",");
                        int bank = 0;
                        if (li != -1) {
                            bank = Integer.parseInt(ielement.program.substring(li + 1));
                        }
                        if (!banks.contains(bank)) {
                            banks.add(bank);
                        }
                        programs.add(ielement.program);
                    } else if (uobject.toString().startsWith("Bank ")) {
                        int bank = Integer.parseInt(uobject.toString().substring(5));
                        banks.add(bank);
                        allbanks.add(bank);
                    }
                    ++i;
                }
                List<ScriptDocument.Statement> list = InstrumentsTree.this.editor.doc.getObject("instruments").getStatements();
                ScriptDocument.Statement[] statements = new ScriptDocument.Statement[list.size()];
                list.toArray(statements);
                int i2 = 0;
                while (i2 < statements.length) {
                    block16: {
                        int bank;
                        ScriptDocument.Statement st;
                        block20: {
                            HashMap<String, ScriptElement> params;
                            ScriptElement call;
                            block17: {
                                String programid;
                                int bank2;
                                int program;
                                block19: {
                                    ScriptElement param2;
                                    block18: {
                                        ScriptElement assignment;
                                        ScriptElement element;
                                        st = statements[i2];
                                        try {
                                            element = ScriptParser.parse(st.toString());
                                        }
                                        catch (ScriptParserException e) {
                                            break block16;
                                        }
                                        if (element.getElements() == null || element.getElements().size() == 0 || (assignment = element.getElements().get(0)).getType() != 1 || assignment.getElements() == null || assignment.getElements().size() == 0 || (call = assignment.getElements().get(0)).getValue() == null) break block16;
                                        params = new HashMap<String, ScriptElement>();
                                        if (call.getElements() != null) {
                                            for (ScriptElement pelement : call.getElements()) {
                                                if (pelement.getElements() == null || pelement.getElements().size() == 0) continue;
                                                params.put(pelement.getValue().toString().toLowerCase(), pelement.getElements().get(0));
                                            }
                                        }
                                        if (!call.getValue().equals("instrument")) break block17;
                                        program = 0;
                                        bank2 = 0;
                                        ScriptElement param1 = (ScriptElement)params.get("1");
                                        param2 = (ScriptElement)params.get("2");
                                        if (param1 == null) break block18;
                                        if (param1.getType() != 5) break block16;
                                        program = (int)((Double)param1.getValue()).doubleValue();
                                    }
                                    if (param2 == null) break block19;
                                    if (param2.getType() != 5) break block16;
                                    bank2 = (int)((Double)param2.getValue()).doubleValue();
                                }
                                if (programs.contains(programid = String.valueOf(program) + "," + bank2) || allbanks.contains(bank2)) {
                                    st.remove();
                                }
                            }
                            if (!call.getValue().equals("soundbank")) break block16;
                            bank = 0;
                            ScriptElement param2 = (ScriptElement)params.get("2");
                            if (param2 == null) break block20;
                            if (param2.getType() != 5) break block16;
                            bank = (int)((Double)param2.getValue()).doubleValue();
                        }
                        if (banks.contains(bank)) {
                            st.remove();
                        }
                    }
                    ++i2;
                }
                InstrumentsTree.this.editor.commit();
            }
        });
        buttonpanel.add(addbutton);
        buttonpanel.add(removebutton);
        this.scrollpane = new JScrollPane(this.tree);
        this.add(this.scrollpane);
        this.add((Component)buttonpanel, "South");
    }

    private class InstrumentItem {
        String name;
        String program;

        public InstrumentItem(String name, String program) {
            this.name = name;
            this.program = program;
        }

        public String toString() {
            return String.valueOf(this.program) + ": " + this.name;
        }
    }

    class SoundFontAccessory
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JFileChooser filechooser;
        File curfile = null;
        PropertyChangeListener sfa = new PropertyChangeListener(this){
            final /* synthetic */ SoundFontAccessory this$1;
            {
                this.this$1 = soundFontAccessory;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if ("directoryChanged".equals(evt.getPropertyName())) {
                    this.this$1.soundfontlist.setModel(new DefaultListModel<E>());
                    this.this$1.invalidate();
                    this.this$1.validate();
                    this.this$1.repaint();
                }
                if ("SelectedFileChangedProperty".equals(evt.getPropertyName())) {
                    File newFile = (File)evt.getNewValue();
                    if (newFile != null && newFile.getName().toLowerCase().endsWith(".sf2")) {
                        try {
                            Soundbank soundbank = new RasmusSoundbankReader().getSoundbank(newFile);
                            Instrument[] instruments = soundbank.getInstruments();
                            DefaultListModel<String> listmodel = new DefaultListModel<String>();
                            listmodel.ensureCapacity(instruments.length);
                            int i = 0;
                            while (i < instruments.length) {
                                Patch patch = instruments[i].getPatch();
                                String ident = String.valueOf(patch.getProgram()) + "," + patch.getBank();
                                listmodel.addElement(String.valueOf(ident) + ": " + instruments[i].getName());
                                ++i;
                            }
                            SoundFontAccessory.access$0((SoundFontAccessory)this.this$1).ins_set = false;
                            this.this$1.soundfontlist.setModel(listmodel);
                            this.this$1.curfile = newFile;
                            this.this$1.invalidate();
                            this.this$1.validate();
                            this.this$1.repaint();
                            return;
                        }
                        catch (InvalidMidiDataException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.this$1.soundfontlist.setModel(new DefaultListModel<E>());
                    this.this$1.invalidate();
                    this.this$1.validate();
                    this.this$1.repaint();
                }
            }
        };
        JList soundfontlist = new JList(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ SoundFontAccessory this$1;
            {
                this.this$1 = soundFontAccessory;
            }

            public void processKeyEvent(KeyEvent e) {
                if (e.getModifiers() > 1) {
                    super.processKeyEvent(e);
                    return;
                }
                if (e.getKeyCode() == 0) {
                    return;
                }
                if (e.getID() == 401) {
                    this.keyPressed(e);
                }
                if (e.getID() == 402) {
                    this.keyReleased(e);
                }
                if (e.getID() == 400) {
                    this.keyTyped(e);
                }
                if (!e.isConsumed()) {
                    super.processKeyEvent(e);
                }
            }

            public void keyPressed(KeyEvent e) {
                SoundFontAccessory.access$0((SoundFontAccessory)this.this$1).keylistener.keyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
                SoundFontAccessory.access$0((SoundFontAccessory)this.this$1).keylistener.keyReleased(e);
            }

            public void keyTyped(KeyEvent e) {
                SoundFontAccessory.access$0((SoundFontAccessory)this.this$1).keylistener.keyTyped(e);
            }
        };
        public String selectedPreset;
        public String selectedPresetDescription;
        Interpreter testinterpreter = null;
        JComboBox streammode;

        public String getSelectedItem() {
            String epreset = InstrumentsTree.this.getEmptyPresetIdent();
            this.unloadTestPreset();
            if (this.soundfontlist.getSelectedIndex() == -1) {
                return null;
            }
            this.testinterpreter = new Interpreter(InstrumentsTree.this.editor.namespace);
            this.testinterpreter.setAutoCommit(false);
            String val = this.soundfontlist.getSelectedValue().toString();
            int li = val.indexOf(":");
            String selectedPresetDescription = val.substring(li + 1);
            String selectedPreset = val = val.substring(0, li);
            String pathcode = "\"" + this.curfile.getPath() + "\"";
            String code = "\ninstruments <- instrument(" + epreset + ",\"" + selectedPresetDescription.trim() + "\"" + ") <- soundbankpreset(" + pathcode + "," + selectedPreset + ");";
            try {
                this.testinterpreter.eval(code);
            }
            catch (ScriptParserException e) {
                e.printStackTrace();
            }
            InstrumentsTree.this.editor.namespace.commit();
            return epreset;
        }

        public void unloadTestPreset() {
            if (this.testinterpreter != null) {
                this.testinterpreter.close();
                this.testinterpreter = null;
                InstrumentsTree.this.editor.namespace.commit();
            }
        }

        public void selectPreset() {
            if (this.soundfontlist.getSelectedIndex() == -1) {
                return;
            }
            String val = this.soundfontlist.getSelectedValue().toString();
            int li = val.indexOf(":");
            this.selectedPresetDescription = val.substring(li + 1);
            this.selectedPreset = val = val.substring(0, li);
            InstrumentsTree.this.soundbankpresetchooser.approveSelection();
        }

        public SoundFontAccessory(JFileChooser filechooser) {
            this.soundfontlist.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
                final /* synthetic */ SoundFontAccessory this$1;
                {
                    this.this$1 = soundFontAccessory;
                }

                public void valueChanged(ListSelectionEvent arg0) {
                    SoundFontAccessory.access$0((SoundFontAccessory)this.this$1).ins_set = false;
                }
            });
            this.soundfontlist.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ SoundFontAccessory this$1;
                {
                    this.this$1 = soundFontAccessory;
                }

                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        SoundFontAccessory.access$0(this.this$1).fireChangeSelection();
                    }
                }
            });
            this.soundfontlist.addFocusListener(new FocusListener(this){
                final /* synthetic */ SoundFontAccessory this$1;
                {
                    this.this$1 = soundFontAccessory;
                }

                public void focusGained(FocusEvent arg0) {
                    SoundFontAccessory.access$0((SoundFontAccessory)this.this$1).keylistener.allNotesOff();
                    SoundFontAccessory.access$0((SoundFontAccessory)this.this$1).ins_set = false;
                }

                public void focusLost(FocusEvent arg0) {
                    SoundFontAccessory.access$0((SoundFontAccessory)this.this$1).keylistener.allNotesOff();
                    SoundFontAccessory.access$0((SoundFontAccessory)this.this$1).ins_set = false;
                }
            });
            this.filechooser = filechooser;
            filechooser.setAccessory(this);
            filechooser.addPropertyChangeListener(this.sfa);
            Dimension psize = this.getPreferredSize();
            psize.height = 300;
            psize.width = 200;
            this.setPreferredSize(psize);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.add(new JScrollPane(this.soundfontlist));
            JButton addpreset = new JButton("Open Instrument");
            addpreset.addActionListener(new ActionListener(this){
                final /* synthetic */ SoundFontAccessory this$1;
                {
                    this.this$1 = soundFontAccessory;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.this$1.selectPreset();
                }
            });
            this.soundfontlist.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ SoundFontAccessory this$1;
                {
                    this.this$1 = soundFontAccessory;
                }

                public void mouseClicked(MouseEvent arg0) {
                    if (arg0.getClickCount() == 2) {
                        this.this$1.selectPreset();
                    }
                }
            });
            JPanel buttonpanel = new JPanel();
            buttonpanel.add(addpreset);
            this.add((Component)buttonpanel, "South");
            String[] values = new String[]{"disk", "memory"};
            this.streammode = new JComboBox<String>(values);
            this.streammode.setSelectedIndex(1);
            JPanel optionpanel = new JPanel();
            optionpanel.setLayout(new FlowLayout());
            optionpanel.add(new JLabel("Stream mode:"));
            optionpanel.add(this.streammode);
            this.add((Component)optionpanel, "North");
        }

        static /* synthetic */ InstrumentsTree access$0(SoundFontAccessory soundFontAccessory) {
            return soundFontAccessory.InstrumentsTree.this;
        }
    }
}

