/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rasmus.editor.ControlsViewer;
import rasmus.editor.EditorView;
import rasmus.editor.RasmusEditor;
import rasmus.editor.ScriptEditor;
import rasmus.editor.TableEditor;
import rasmus.editor.WaveEditor;

public class ObjectEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    RasmusEditor editor;
    JTabbedPane tabs;
    ArrayList<EditorView> editors = new ArrayList();
    String objectname;

    public ObjectEditor(RasmusEditor editor) {
        this.editor = editor;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setOpaque(false);
        this.editors.add(new ScriptEditor(editor));
        this.editors.add(new TableEditor(editor));
        this.editors.add(new WaveEditor(editor));
        this.editors.add(new ControlsViewer(editor));
        this.tabs = new JTabbedPane();
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                ObjectEditor.this.commit();
                ObjectEditor.this.updateView();
            }
        });
        this.tabs.setTabPlacement(3);
        for (EditorView editorview : this.editors) {
            this.tabs.addTab(editorview.getEditorName(), editorview.getJComponent());
        }
        this.add(this.tabs);
    }

    public void init() {
        this.editors.get(0).init();
    }

    public void commit() {
        this.commit(false);
    }

    public void commit(boolean lazy) {
        boolean ok = !lazy;
        Iterator<EditorView> iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            ok |= iterator.next().commit();
        }
        if (ok) {
            this.editor.commit();
        }
    }

    public void setObjectScope(String objectname) {
        this.objectname = objectname;
        this.updateView();
    }

    public void updateView() {
        EditorView editorview = this.editors.get(this.tabs.getSelectedIndex());
        editorview.setObjectScope(this.objectname);
        editorview.init();
    }

    public void closing() {
        Iterator<EditorView> iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            iterator.next().closing();
        }
        this.editor.commit();
    }
}

