/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import rasmus.editor.MixedNumberComparator;
import rasmus.editor.ObjectEditor;
import rasmus.editor.RasmusSession;
import rasmus.editor.ScriptDocument;
import rasmus.editor.ScriptEditor;
import rasmus.editor.TimePositionListener;
import rasmus.editor.spi.FileConverter;
import rasmus.editor.spi.FileExporter;
import rasmus.editor.spi.ScriptImporter;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.BeatToTimeMapper;
import rasmus.interpreter.ui.AboutDialog;
import rasmus.util.RasmusUtil;

public class RasmusEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    ScriptDocument doc;
    NameSpace namespace;
    JFileChooser fileopenchooser = null;
    JFileChooser filesavechooser = null;
    FileFilter[] openfilters = null;
    FileFilter[] savefilters = null;
    FileFilter allformats_filefilter = new FileFilter(){

        public boolean accept(File file) {
            FileFilter[] filters = RasmusEditor.this.getOpenFilters();
            int i = 0;
            while (i < filters.length) {
                if (filters[i].accept(file)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String getDescription() {
            return "All formats";
        }
    };
    FileFilter rasmusdsp_filefilter = new FileFilter(){

        public boolean accept(File arg0) {
            if (!arg0.isFile()) {
                return true;
            }
            return arg0.getName().toLowerCase().endsWith(".rasmusdsp");
        }

        public String getDescription() {
            return "RasmusDSP Scripts (*.rasmusdsp)";
        }
    };
    File selectedfile = null;
    File currentdir = null;
    FileConverter[] converters = null;
    FileConverter currentconverter = null;
    ObjectEditor editorpanel;
    RasmusListModel model = new RasmusListModel();
    JComboBox combobox;
    String currentobject = null;
    String programtitle = "RasmusDSP";
    String synthtitle = null;
    File filename = null;
    Map<String, VariableRenderedInstance> renderedvariables = new HashMap<String, VariableRenderedInstance>();
    volatile boolean s1_active = false;
    volatile boolean s2_active = false;
    volatile long s1_count = -1L;
    volatile long s2_count = -1L;
    Receiver sync1 = new Receiver(){

        public void send(MidiMessage arg0, long arg1) {
            byte[] msg = arg0.getMessage();
            if (msg.length == 1) {
                byte status = msg[0];
                if (status == -7) {
                    ++RasmusEditor.this.s1_count;
                } else if (status == -4) {
                    RasmusEditor.this.s1_active = false;
                } else if (status == -6) {
                    RasmusEditor.this.s1_active = true;
                }
            }
        }

        public void close() {
        }
    };
    Receiver sync2 = new Receiver(){

        public void send(MidiMessage arg0, long arg1) {
            byte[] msg = arg0.getMessage();
            if (msg.length == 1) {
                byte status = msg[0];
                if (status == -7) {
                    ++RasmusEditor.this.s2_count;
                } else if (status == -4) {
                    RasmusEditor.this.s2_active = false;
                } else if (status == -6) {
                    RasmusEditor.this.s2_active = true;
                }
            }
        }

        public void close() {
        }
    };
    Interpreter playernamespace = new Interpreter();
    BeatToTimeMapper b2t;
    ClockWatcher cw;
    ArrayList<TimePositionListener> timeposlisteners;
    TimePositionListener[] timeposlistenersA;
    double lasttime;
    boolean play_hasaudio;
    Interpreter realtimeinterpreter;
    Interpreter playinterpreter;
    Receiver controlinput;
    Variable realtimeinput;
    JLabel statuslabel;
    boolean playing;
    RasmusSession session;
    boolean close_session;
    static /* synthetic */ Class class$0;

    public FileFilter[] getOpenFilters() {
        if (this.openfilters != null) {
            return this.openfilters;
        }
        ArrayList<FileFilter> list = new ArrayList<FileFilter>();
        list.add(this.rasmusdsp_filefilter);
        FileConverter[] converts = this.getConverters();
        int i = 0;
        while (i < converts.length) {
            FileConverter convert = converts[i];
            if (convert instanceof ScriptImporter) {
                list.add(new FileConverterAdapter(convert));
            }
            ++i;
        }
        this.openfilters = new FileFilter[list.size()];
        list.toArray(this.openfilters);
        return this.openfilters;
    }

    public FileFilter[] getSaveFilters() {
        if (this.savefilters != null) {
            return this.savefilters;
        }
        ArrayList<FileFilter> list = new ArrayList<FileFilter>();
        list.add(this.rasmusdsp_filefilter);
        FileConverter[] converts = this.getConverters();
        int i = 0;
        while (i < converts.length) {
            FileConverter convert = converts[i];
            if (convert instanceof FileExporter) {
                list.add(new FileConverterAdapter(convert));
            }
            ++i;
        }
        this.savefilters = new FileFilter[list.size()];
        list.toArray(this.savefilters);
        return this.savefilters;
    }

    public JFileChooser getFileOpenChooser() {
        if (this.fileopenchooser == null) {
            this.fileopenchooser = new JFileChooser();
            this.fileopenchooser.addChoosableFileFilter(this.allformats_filefilter);
            FileFilter[] filters = this.getOpenFilters();
            int i = 0;
            while (i < filters.length) {
                this.fileopenchooser.addChoosableFileFilter(filters[i]);
                ++i;
            }
            this.fileopenchooser.setAcceptAllFileFilterUsed(true);
            this.fileopenchooser.setFileFilter(this.allformats_filefilter);
        }
        return this.fileopenchooser;
    }

    public JFileChooser getFileSaveChooser() {
        if (this.filesavechooser == null) {
            this.filesavechooser = new JFileChooser();
            FileFilter[] filters = this.getSaveFilters();
            int i = 0;
            while (i < filters.length) {
                this.filesavechooser.addChoosableFileFilter(filters[i]);
                ++i;
            }
            this.filesavechooser.setAcceptAllFileFilterUsed(false);
            this.filesavechooser.setFileFilter(this.rasmusdsp_filefilter);
        }
        return this.filesavechooser;
    }

    public FileConverter[] getConverters() {
        if (this.converters != null) {
            return this.converters;
        }
        List list = RasmusUtil.getProviders(FileConverter.class);
        this.converters = new FileConverter[list.size()];
        list.toArray(this.converters);
        return this.converters;
    }

    public FileConverter getSelectedFileOpenConveter() {
        JFileChooser fc = this.getFileOpenChooser();
        File file = fc.getSelectedFile();
        FileFilter[] filters = this.getOpenFilters();
        int i = 0;
        while (i < filters.length) {
            FileFilter filter = filters[i];
            if (filter.accept(file) && filter instanceof FileConverterAdapter) {
                return ((FileConverterAdapter)filter).getConverter();
            }
            ++i;
        }
        return null;
    }

    public File selectFileForOpen() {
        JFileChooser fc = this.getFileOpenChooser();
        if (this.selectedfile != null) {
            fc.setSelectedFile(this.selectedfile);
            fc.setCurrentDirectory(this.currentdir);
        }
        int ret = fc.showOpenDialog(this);
        this.selectedfile = fc.getSelectedFile();
        this.currentdir = fc.getCurrentDirectory();
        if (ret == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public File selectFileForSave() {
        JFileChooser fc = this.getFileSaveChooser();
        if (this.selectedfile != null) {
            fc.setSelectedFile(this.selectedfile);
            fc.setCurrentDirectory(this.currentdir);
        }
        int ret = fc.showSaveDialog(this);
        this.selectedfile = fc.getSelectedFile();
        this.currentdir = fc.getCurrentDirectory();
        if (ret == 0) {
            File file = fc.getSelectedFile();
            if (fc.getFileFilter() != null) {
                if (fc.getFileFilter() == this.rasmusdsp_filefilter && !file.getPath().toLowerCase().endsWith(".rasmusdsp")) {
                    file = new File(String.valueOf(file.getPath()) + ".rasmusdsp");
                    fc.setSelectedFile(file);
                }
                if (fc.getFileFilter() instanceof FileConverterAdapter) {
                    file = ((FileExporter)((FileConverterAdapter)fc.getFileFilter()).getConverter()).setFileExtension(file);
                    fc.setSelectedFile(file);
                }
            }
            return fc.getSelectedFile();
        }
        return null;
    }

    public void fileNew() {
        this.doc.stopAll();
        this.editorpanel.commit();
        this.session.setWorkDirectory(null);
        this.filename = null;
        this.updateTitle();
        this.resetPlayRenderCache();
        this.doc.setString("");
        this.currentobject = null;
        this.showObject("");
        this.combobox.setSelectedItem("");
        this.model.commit();
    }

    public void fileOpen() {
        File file = this.selectFileForOpen();
        if (file == null) {
            return;
        }
        this.doc.stopAll();
        this.editorpanel.commit();
        this.filename = null;
        this.currentconverter = this.getSelectedFileOpenConveter();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.currentconverter != null) {
            String script = ((ScriptImporter)this.currentconverter).importToScript(this, file);
            if (script == null) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.load(script);
        } else {
            this.load(file);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.session.setWorkDirectory(file.getParentFile());
        this.currentobject = null;
        this.showObject("");
        this.combobox.setSelectedItem("");
        this.model.commit();
        this.filename = file;
        this.updateTitle();
    }

    public void update() {
        this.showObject("instruments");
        this.showObject("");
    }

    public void fileSave() {
        if (this.filename == null) {
            this.fileSaveAs();
            return;
        }
        FileFilter filefilter = null;
        boolean ok = false;
        FileFilter[] filters = this.getSaveFilters();
        int i = 0;
        while (i < filters.length) {
            filefilter = filters[i];
            if (filefilter.accept(this.filename)) {
                ok = true;
                break;
            }
            ++i;
        }
        if (!ok) {
            this.fileSaveAs();
            return;
        }
        this.save(this.filename);
    }

    public void fileSaveAs() {
        File file;
        this.getFileSaveChooser().setFileFilter(this.rasmusdsp_filefilter);
        if (this.filename != null) {
            FileFilter[] filters = this.getSaveFilters();
            int i = 0;
            while (i < filters.length) {
                FileFilter filefilter = filters[i];
                if (filefilter.accept(this.filename)) {
                    this.getFileSaveChooser().setFileFilter(filefilter);
                    break;
                }
                ++i;
            }
        }
        if ((file = this.selectFileForSave()) == null) {
            return;
        }
        this.save(file);
    }

    public void save(File file) {
        this.editorpanel.commit();
        this.filename = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.doc.toString().getBytes("LATIN1"));
            fos.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.session.setWorkDirectory(file.getParentFile());
        this.filename = file;
        this.updateTitle();
    }

    public JMenuBar processMenuBar(JMenuBar p_menubar) {
        JMenuBar menubar = new JMenuBar();
        JMenu file_menu = menubar.add(new JMenu("File"));
        JMenuItem file_new = file_menu.add(new JMenuItem("New"));
        file_new.setMnemonic('N');
        file_new.setAccelerator(KeyStroke.getKeyStroke("control N"));
        file_new.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.fileNew();
            }
        });
        JMenuItem file_open = file_menu.add(new JMenuItem("Open"));
        file_open.setMnemonic('O');
        file_open.setAccelerator(KeyStroke.getKeyStroke("control O"));
        file_open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.fileOpen();
            }
        });
        JMenuItem file_save = file_menu.add(new JMenuItem("Save"));
        file_save.setMnemonic('S');
        file_save.setAccelerator(KeyStroke.getKeyStroke("control S"));
        file_save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.fileSave();
            }
        });
        JMenuItem file_saveas = file_menu.add(new JMenuItem("Save As"));
        file_saveas.setMnemonic('A');
        file_saveas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.fileSaveAs();
            }
        });
        file_menu.addSeparator();
        JMenuItem file_commit = file_menu.add(new JMenuItem("Commit"));
        file_commit.setMnemonic('C');
        file_commit.setAccelerator(KeyStroke.getKeyStroke("F12"));
        file_commit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.editorpanel.commit();
            }
        });
        JMenuItem file_restart = file_menu.add(new JMenuItem("Restart"));
        file_restart.setMnemonic('R');
        file_restart.setAccelerator(KeyStroke.getKeyStroke("control F12"));
        file_restart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.doc.stopAll();
                RasmusEditor.this.resetPlayRenderCache();
                RasmusEditor.this.editorpanel.commit();
            }
        });
        JMenuItem file_suspend = file_menu.add(new JMenuItem("Suspend"));
        file_suspend.setMnemonic('R');
        file_suspend.setAccelerator(KeyStroke.getKeyStroke("shift F12"));
        file_suspend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.doc.stopAll();
                RasmusEditor.this.resetPlayRenderCache();
                RasmusEditor.this.namespace.commit();
            }
        });
        file_menu.addSeparator();
        JMenuItem exit_menuitem = file_menu.add(new JMenuItem("Exit"));
        exit_menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.closing();
                if (RasmusEditor.this.close_session) {
                    System.exit(0);
                } else {
                    RasmusEditor.this.setVisible(false);
                }
            }
        });
        JMenu[] menus = new JMenu[p_menubar.getMenuCount()];
        int i = 0;
        while (i < p_menubar.getMenuCount()) {
            menus[i] = p_menubar.getMenu(i);
            ++i;
        }
        p_menubar.removeAll();
        i = 0;
        while (i < menus.length) {
            menubar.add(menus[i]);
            ++i;
        }
        JMenu play_menu = menubar.add(new JMenu("Play"));
        JMenuItem play_realtime = new JMenuItem("RealTime");
        play_realtime.setAccelerator(KeyStroke.getKeyStroke("F9"));
        play_realtime.setMnemonic('R');
        JMenuItem play_play = new JMenuItem("Play");
        play_play.setAccelerator(KeyStroke.getKeyStroke("F5"));
        play_play.setMnemonic('P');
        JMenuItem play_stop = new JMenuItem("Stop");
        play_stop.setAccelerator(KeyStroke.getKeyStroke("F7"));
        play_stop.setMnemonic('S');
        play_realtime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.playRealTime();
            }
        });
        play_play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.playPlay();
            }
        });
        play_stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.playStop();
            }
        });
        play_menu.add(play_realtime);
        play_menu.add(play_play);
        play_menu.add(play_stop);
        JMenu help_menu = menubar.add(new JMenu("Help"));
        help_menu.add(new JMenuItem("About RasmusDSP...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                new AboutDialog(RasmusEditor.this).setVisible(true);
            }
        });
        return menubar;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this.editorpanel != null && this.editorpanel.editors != null) {
            if (cursor == Cursor.getDefaultCursor()) {
                cursor = Cursor.getPredefinedCursor(2);
            }
            ((ScriptEditor)this.editorpanel.editors.get((int)0)).textarea.setCursor(cursor);
        }
    }

    public void commit() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.model.commit();
        this.doc.startAll();
        this.namespace.commit();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static String readScript(File file) throws UnsupportedEncodingException {
        FileInputStream is;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return null;
        }
        try {
            try {
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String(baos.toByteArray(), "LATIN1");
    }

    public void load(File file) {
        FileInputStream is;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return;
        }
        try {
            try {
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resetPlayRenderCache();
        try {
            this.doc.setString(new String(baos.toByteArray(), "LATIN1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void load(String script) {
        this.resetPlayRenderCache();
        this.doc.setString(script);
    }

    public void showObject(String objectname) {
        this.editorpanel.commit();
        if (objectname == null) {
            objectname = "";
        }
        if (this.currentobject != null && this.currentobject.equals(objectname)) {
            return;
        }
        this.currentobject = objectname;
        if (objectname.length() == 0) {
            objectname = null;
        }
        this.editorpanel.setObjectScope(objectname);
    }

    public void updateTitle() {
        if (this.synthtitle != null) {
            this.setTitle(this.synthtitle);
            return;
        }
        if (this.filename == null) {
            this.setTitle("untitled.rasmusdsp - " + this.programtitle);
        } else {
            this.setTitle(String.valueOf(this.filename.getName()) + " - " + this.programtitle);
        }
    }

    public void resetPlayRenderCache() {
        Iterator<VariableRenderedInstance> iter = this.renderedvariables.values().iterator();
        while (iter.hasNext()) {
            iter.next().close();
        }
        this.renderedvariables.clear();
    }

    public Variable getRenderedInstance(String name) {
        VariableRenderedInstance vari = this.renderedvariables.get(name = name.toLowerCase());
        if (vari == null) {
            vari = new VariableRenderedInstance(name);
            this.renderedvariables.put(name, vari);
        }
        return vari.getRenderedInstance();
    }

    public void addTimePositionListener(TimePositionListener listener) {
        this.timeposlisteners.add(listener);
        this.timeposlistenersA = new TimePositionListener[this.timeposlisteners.size()];
        this.timeposlisteners.toArray(this.timeposlistenersA);
    }

    public void removeTimePosListener(TimePositionListener listener) {
        this.timeposlisteners.add(listener);
        this.timeposlistenersA = new TimePositionListener[this.timeposlisteners.size()];
        this.timeposlisteners.toArray(this.timeposlistenersA);
    }

    public void createPlayInterpreter(String name) {
        this.s1_active = false;
        this.s2_active = false;
        this.s1_count = -1L;
        this.s2_count = -1L;
        if (this.playinterpreter != null) {
            this.playinterpreter.close();
        }
        this.playinterpreter = new Interpreter(this.playernamespace);
        this.playinterpreter.setAutoCommit(false);
        Variable ri = this.getRenderedInstance(name);
        this.b2t = AudioEvents.getBeatToTimeMap(ri);
        this.play_hasaudio = AudioEvents.getInstance(ri).getObjects().size() != 0;
        this.playinterpreter.add("renderinput", ri);
        this.playinterpreter.registerAsPrivate("defaultoutputs");
        this.playinterpreter.add("defaultoutputs", this.namespace.get("defaultoutputs"));
        try {
            this.playinterpreter.eval("defaultoutputs() <- renderoutput;");
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
        try {
            this.playinterpreter.eval("renderoutput <- AudioPlayer(controlinput, syncout=syncout1) <- renderinput;");
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
        try {
            this.playinterpreter.eval("renderoutput <- MidiPlayer(controlinput, syncout=syncout2) <- renderinput;");
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
        this.controlinput = MidiSequence.getInstance(this.playinterpreter.get("controlinput"));
        this.cw = new ClockWatcher();
        this.cw.setPriority(1);
        this.cw.start();
    }

    public void createRealTimeInterpreter() {
        if (this.realtimeinterpreter != null) {
            this.realtimeinterpreter.close();
        }
        this.realtimeinterpreter = new Interpreter();
        this.realtimeinterpreter.setAutoCommit(false);
        this.realtimeinterpreter.add("input", this.realtimeinput);
        this.realtimeinterpreter.registerAsPrivate("defaultrender");
        this.realtimeinterpreter.registerAsPrivate("defaultoutputs");
        this.realtimeinterpreter.add("defaultrender", this.namespace.get("defaultrender"));
        this.realtimeinterpreter.add("defaultoutputs", this.namespace.get("defaultoutputs"));
        try {
            this.realtimeinterpreter.eval("defaultoutputs() <- renderinput;");
        }
        catch (ScriptParserException e1) {
            e1.printStackTrace();
        }
        try {
            this.realtimeinterpreter.eval("renderinput <- DefaultRender() <- input;");
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
    }

    public Variable getRealTimeInput() {
        return this.realtimeinput;
    }

    public void playRealTime() {
        this.playStop();
        this.editorpanel.commit();
        this.createRealTimeInterpreter();
        this.namespace.commit();
        this.statuslabel.setText("RealTime");
    }

    public void playPlay() {
        this.playStop();
        int i = 0;
        while (i < this.timeposlistenersA.length) {
            this.timeposlistenersA[i].start();
            ++i;
        }
        this.playing = true;
        String sel = (String)this.combobox.getSelectedItem();
        if (sel == null || sel.trim().length() == 0) {
            sel = "output";
        }
        this.editorpanel.commit();
        this.createPlayInterpreter(sel);
        this.namespace.commit();
        try {
            ShortMessage msg = new ShortMessage();
            msg.setMessage(250);
            this.controlinput.send(msg, -1L);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void playStop() {
        this.playing = false;
        if (this.cw != null) {
            this.cw.close();
            this.cw = null;
        }
        if (this.controlinput != null) {
            try {
                ShortMessage msg = new ShortMessage();
                msg.setMessage(252);
                this.controlinput.send(msg, -1L);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
        if (this.playinterpreter != null) {
            this.playinterpreter.close();
            this.controlinput = null;
            this.playinterpreter = null;
        }
        if (this.realtimeinterpreter != null) {
            this.realtimeinterpreter.close();
            this.realtimeinterpreter = null;
        }
        this.namespace.commit();
        this.statuslabel.setText("Stop");
        int i = 0;
        while (i < this.timeposlistenersA.length) {
            this.timeposlistenersA[i].positionChange(0.0, 0.0);
            this.timeposlistenersA[i].stop();
            ++i;
        }
    }

    public void closing() {
        if (this.close_session) {
            this.playStop();
        }
        if (this.close_session) {
            this.editorpanel.closing();
        }
        if (this.close_session) {
            this.session.close();
        }
    }

    public RasmusEditor() {
        MidiSequence.getInstance(this.playernamespace.get("syncout1")).addReceiver(this.sync1);
        MidiSequence.getInstance(this.playernamespace.get("syncout2")).addReceiver(this.sync2);
        this.b2t = null;
        this.cw = null;
        this.timeposlisteners = new ArrayList();
        this.timeposlistenersA = null;
        this.lasttime = 0.0;
        this.play_hasaudio = false;
        this.realtimeinterpreter = null;
        this.playinterpreter = null;
        this.realtimeinput = new Variable();
        this.playing = false;
        this.close_session = true;
        this.session = new RasmusSession();
        this.init();
    }

    public RasmusEditor(RasmusSession session) {
        MidiSequence.getInstance(this.playernamespace.get("syncout1")).addReceiver(this.sync1);
        MidiSequence.getInstance(this.playernamespace.get("syncout2")).addReceiver(this.sync2);
        this.b2t = null;
        this.cw = null;
        this.timeposlisteners = new ArrayList();
        this.timeposlistenersA = null;
        this.lasttime = 0.0;
        this.play_hasaudio = false;
        this.realtimeinterpreter = null;
        this.playinterpreter = null;
        this.realtimeinput = new Variable();
        this.playing = false;
        this.close_session = true;
        this.session = session;
        this.close_session = false;
        this.init();
        this.setDefaultCloseOperation(2);
    }

    public void init() {
        this.doc = this.session.getScriptDocument();
        this.namespace = this.session.getNameSpace();
        this.resetPlayRenderCache();
        this.setSize(800, 600);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(3);
        this.setTitle("untitled.rasmusdsp - " + this.programtitle);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/rasmus/rasmusdsp.PNG")).getImage());
        this.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent arg0) {
            }

            public void windowClosing(WindowEvent arg0) {
                RasmusEditor.this.closing();
            }

            public void windowClosed(WindowEvent arg0) {
            }

            public void windowIconified(WindowEvent arg0) {
            }

            public void windowDeiconified(WindowEvent arg0) {
            }

            public void windowActivated(WindowEvent arg0) {
            }

            public void windowDeactivated(WindowEvent arg0) {
            }
        });
        this.setLayout(new BorderLayout());
        this.editorpanel = new ObjectEditor(this);
        this.combobox = new JComboBox(this.model);
        this.combobox.setEditable(true);
        this.combobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String sel = (String)RasmusEditor.this.combobox.getSelectedItem();
                RasmusEditor.this.showObject(sel);
            }
        });
        Dimension size = this.combobox.getPreferredSize();
        size.width = 200;
        this.combobox.setPreferredSize(size);
        JToolBar toppanel = new JToolBar();
        toppanel.setRollover(true);
        toppanel.setFloatable(false);
        toppanel.setLayout(new FlowLayout(0));
        toppanel.add(new JLabel("Object: "));
        toppanel.add(this.combobox);
        toppanel.addSeparator();
        JButton realtime_button = new JButton("Realtime");
        realtime_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.playRealTime();
            }
        });
        JButton play_button = new JButton("Play");
        play_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.playPlay();
            }
        });
        JButton stop_button = new JButton("Stop");
        stop_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RasmusEditor.this.playStop();
            }
        });
        toppanel.add(realtime_button);
        toppanel.add(play_button);
        toppanel.add(stop_button);
        this.statuslabel = new JLabel("Stop");
        Dimension prefdim = this.statuslabel.getPreferredSize();
        prefdim.width = 150;
        this.statuslabel.setPreferredSize(prefdim);
        JPanel timepanel = new JPanel();
        timepanel.setBackground(new JEditorPane().getBackground());
        timepanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        timepanel.add(this.statuslabel);
        toppanel.add(timepanel);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)toppanel, "South");
        panel.add((Component)this.editorpanel, "Center");
        this.setContentPane(panel);
        this.showObject("");
        this.editorpanel.init();
    }

    public static void main(String[] args) {
        new RasmusEditor().setVisible(true);
    }

    public void setSynthName(String name) {
        this.synthtitle = name;
        this.updateTitle();
    }

    class RasmusListModel
    implements ComboBoxModel {
        ArrayList<ListDataListener> listeners = new ArrayList();
        String[] objects;
        String selitem;
        String[] items;

        RasmusListModel() {
        }

        public void commit() {
            this.processItems();
            Iterator<ListDataListener> iter = this.listeners.iterator();
            ListDataEvent event = new ListDataEvent(this, 0, 0, 0);
            while (iter.hasNext()) {
                iter.next().contentsChanged(event);
            }
        }

        public void processItems() {
            RasmusEditor.this.doc.getObject("");
            List<ScriptDocument.ScriptObject> objects = RasmusEditor.this.doc.getObjects();
            this.items = new String[objects.size()];
            int i = 0;
            while (i < this.items.length) {
                String name = objects.get(i).getName();
                if (name == null) {
                    name = "";
                }
                this.items[i] = name;
                ++i;
            }
            Arrays.sort(this.items, new MixedNumberComparator());
        }

        public void setSelectedItem(Object arg0) {
            this.selitem = ((String)arg0).toLowerCase();
        }

        public Object getSelectedItem() {
            return this.selitem;
        }

        public int getSize() {
            RasmusEditor.this.editorpanel.commit(true);
            if (this.items == null) {
                this.processItems();
            }
            return this.items.length;
        }

        public Object getElementAt(int arg0) {
            if (this.items == null) {
                this.processItems();
            }
            return this.items[arg0];
        }

        public void addListDataListener(ListDataListener arg0) {
            this.listeners.add(arg0);
        }

        public void removeListDataListener(ListDataListener arg0) {
            this.listeners.remove(arg0);
        }
    }

    class FileConverterAdapter
    extends FileFilter {
        FileConverter fc;

        public FileConverterAdapter(FileConverter fc) {
            this.fc = fc;
        }

        public FileConverter getConverter() {
            return this.fc;
        }

        public boolean accept(File file) {
            return this.fc.accept(file);
        }

        public String getDescription() {
            return this.fc.getDescription();
        }
    }

    class VariableRenderedInstance {
        Interpreter vinterpreter;
        Variable var;

        public VariableRenderedInstance(String name) {
            this.vinterpreter = new Interpreter(RasmusEditor.this.namespace);
            this.vinterpreter.setAutoCommit(false);
            try {
                this.var = this.vinterpreter.eval("defaultrender(" + name + ")");
            }
            catch (ScriptParserException e) {
                e.printStackTrace();
            }
        }

        public void close() {
            this.vinterpreter.close();
        }

        public Variable getRenderedInstance() {
            return this.var;
        }
    }

    class StatusUpdater
    implements Runnable {
        String statustext;
        double time;
        double beat;

        public StatusUpdater(String statustext, double time, double beat) {
            this.statustext = statustext;
            this.time = time;
            this.beat = beat;
        }

        public void run() {
            if (RasmusEditor.this.playing) {
                RasmusEditor.this.statuslabel.setText(this.statustext);
                if (this.time != RasmusEditor.this.lasttime) {
                    int i = 0;
                    while (i < RasmusEditor.this.timeposlistenersA.length) {
                        RasmusEditor.this.timeposlistenersA[i].positionChange(this.time, this.beat);
                        ++i;
                    }
                    RasmusEditor.this.lasttime = this.time;
                }
            }
        }
    }

    class ClockWatcher
    extends Thread {
        transient boolean active = true;

        ClockWatcher() {
        }

        public void run() {
            while (this.active) {
                String statustext;
                long s1_count = RasmusEditor.this.s1_count;
                long s2_count = RasmusEditor.this.s2_count;
                boolean s1_active = RasmusEditor.this.s1_active;
                boolean s2_active = RasmusEditor.this.s2_active;
                if (!s1_active) {
                    s1_count = -1L;
                }
                if (!s2_active) {
                    s2_count = -1L;
                }
                String mode = "Stop";
                if (s1_count != -1L && s2_count == -1L) {
                    mode = "Audio";
                } else if (s1_count != -1L && s2_count != -1L) {
                    mode = "Audio";
                } else if (s1_count == -1L && s2_count != -1L) {
                    mode = "MIDI";
                }
                long mcount = s1_count;
                if (!RasmusEditor.this.play_hasaudio) {
                    mcount = s2_count;
                }
                double time = -1.0;
                double beat = -1.0;
                if (mcount == -1L) {
                    statustext = "";
                } else {
                    time = (double)mcount / 100.0;
                    beat = RasmusEditor.this.b2t.getBeat(time);
                    int csec = (int)(mcount / 10L % 10L);
                    long sec = (mcount /= 100L) % 60L;
                    long min = mcount / 60L;
                    StringBuffer sb = new StringBuffer();
                    sb.append(mode);
                    sb.append("  ");
                    sb.append(Long.toString(min));
                    sb.append(":");
                    if (sec < 10L) {
                        sb.append("0");
                    }
                    sb.append(Long.toString(sec));
                    sb.append(".");
                    sb.append(Integer.toString(csec));
                    sb.append(" - ");
                    sb.append((int)(beat + 1.0));
                    statustext = sb.toString();
                }
                try {
                    SwingUtilities.invokeLater(new StatusUpdater(statustext, time, beat));
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }

        public void close() {
            this.active = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

