/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import rasmus.editor.ScriptDocument;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.io.ResourceManager;
import rasmus.interpreter.namespace.GlobalNameSpace;
import rasmus.interpreter.namespace.InheritNameSpace;
import rasmus.interpreter.parser.ScriptParserException;

public class RasmusSession {
    private Interpreter startupinterpreter;
    private Interpreter defaultinterpreter;
    private InheritNameSpace namespace;
    private ScriptDocument doc = new ScriptDocument();
    private Interpreter wrkdirinterpreter = null;
    private File wrkdir = null;
    InheritNameSpace overridenamespace;
    Interpreter overrideinterpreter = null;

    public NameSpace getNameSpace() {
        return this.namespace;
    }

    public ScriptDocument getScriptDocument() {
        return this.doc;
    }

    public File getWorkDirectory() {
        return this.wrkdir;
    }

    public void setWorkDirectory(File file) {
        String path;
        if (file != null && file.equals(this.wrkdir)) {
            return;
        }
        if (this.wrkdirinterpreter != null) {
            this.wrkdirinterpreter.close();
            this.wrkdirinterpreter = null;
            this.wrkdir = null;
        }
        if (file == null) {
            return;
        }
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            path = file.getPath();
            e.printStackTrace();
        }
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        this.wrkdirinterpreter = new Interpreter(this.namespace);
        this.wrkdirinterpreter.setAutoCommit(false);
        this.wrkdirinterpreter.add("wrkdir", (Object)path);
        this.wrkdir = file;
        this.wrkdirinterpreter.commit();
    }

    public RasmusSession() {
        String user_home = System.getProperty("user.home");
        File file = new File(user_home, "startup.rasmusdsp");
        if (!file.exists() && !(file = new File("startup.rasmusdsp")).exists()) {
            file = null;
        }
        NameSpace globalnamespace = GlobalNameSpace.getNameSpace();
        InheritNameSpace defaultnamespace = new InheritNameSpace(globalnamespace);
        defaultnamespace.registerAsPrivate("_resource_manager");
        ResourceManager.getInstance(defaultnamespace);
        this.defaultinterpreter = new Interpreter(defaultnamespace);
        this.defaultinterpreter.setAutoCommit(false);
        InheritNameSpace startupnamespace = new InheritNameSpace(defaultnamespace);
        this.overridenamespace = new InheritNameSpace(startupnamespace);
        InheritNameSpace namespace = new InheritNameSpace(this.overridenamespace);
        Variable editorns_struct = namespace.get("this");
        startupnamespace.put("editor", editorns_struct);
        defaultnamespace.put("editor", editorns_struct);
        try {
            InputStream inputstream = this.getClass().getResourceAsStream("/rasmus/editor/default.rasmusdsp");
            try {
                this.defaultinterpreter.source(inputstream);
            }
            finally {
                inputstream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
        this.startupinterpreter = new Interpreter(startupnamespace);
        if (file != null) {
            try {
                this.startupinterpreter.source(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ScriptParserException e) {
                e.printStackTrace();
            }
        }
        this.namespace = namespace;
        this.doc.setNameSpace(namespace);
    }

    public void close() {
        this.doc.stopAll();
        if (this.wrkdirinterpreter != null) {
            this.wrkdirinterpreter.close();
        }
        this.namespace.close();
        this.defaultinterpreter.close();
        this.startupinterpreter.close();
    }

    public void routeAudioOutput(Variable realtimeout) {
        if (this.overrideinterpreter != null) {
            this.overrideinterpreter.close();
        }
        if (realtimeout == null) {
            return;
        }
        this.overrideinterpreter = new Interpreter(this.overridenamespace);
        this.overrideinterpreter.setAutoCommit(false);
        try {
            this.overrideinterpreter.eval("defaultoutputs <- function(input) {  parent.realtimeoutput <- input; } ");
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
        realtimeout.add(this.overrideinterpreter.get("realtimeoutput"));
    }
}

