/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rasmus.interpreter.Closeable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.parser.ScriptCompiler;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.parser.ScriptTokenParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptDocument {
    private NameSpace namespace;
    private ArrayList<ScriptObject> objectlist = new ArrayList();
    private Map<String, ScriptObject> objects = new HashMap<String, ScriptObject>();
    private Statement root;
    private Statement last = this.root = new Statement();
    private Map<String, Object> code_garbage = new HashMap<String, Object>();

    public Statement getRoot() {
        return this.root;
    }

    public Statement getFirst() {
        return this.root.getNext();
    }

    public Statement getLast() {
        return this.last;
    }

    public void sanityCheck() {
        ScriptDocument doc = this;
        Iterator<ScriptObject> oiter = doc.getObjects().iterator();
        while (oiter.hasNext()) {
            Iterator<Statement> siter = oiter.next().statements.iterator();
            while (siter.hasNext()) {
                Statement pre;
                Statement p_test = pre = siter.next();
                Statement p_root = doc.getRoot();
                while (p_test != null) {
                    if (p_test == p_root) break;
                    if ((p_test = p_test.getPrevious()) != null) continue;
                    System.out.println("PRE IS INVALID, MAJOR ERROR INDEED!!!!");
                    return;
                }
                if (pre == null) continue;
                p_test = p_root;
                while (p_test != null) {
                    if (p_test == pre) break;
                    p_test = p_test.getNext();
                }
                if (p_test == pre) continue;
                System.out.println("PRE CHAIN IS INVALID, MAJOR ERROR INDEED!!!!");
                return;
            }
        }
    }

    public void setNameSpace(NameSpace namespace) {
        this.namespace = namespace;
    }

    public NameSpace getNameSpace() {
        return this.namespace;
    }

    public void clear() {
        this.stopAll();
        this.objectlist.clear();
        this.objects.clear();
        this.root.next = null;
    }

    private void clearAndKeepGarbage() {
        this.stopAllAndKeepGarbage();
        this.objectlist.clear();
        this.objects.clear();
        this.root.next = null;
    }

    private void addToGarbage(String code, Closeable instance) {
        ArrayList item = this.code_garbage.get(code);
        if (item == null) {
            this.code_garbage.put(code, instance);
        } else {
            if (item instanceof Closeable) {
                ArrayList list = new ArrayList();
                list.add(item);
                item = list;
            }
            ((List)item).add(instance);
        }
    }

    private Closeable getGarbage(String code) {
        Object item = this.code_garbage.get(code);
        if (item == null) {
            return null;
        }
        if (item instanceof Closeable) {
            this.code_garbage.remove(code);
            return (Closeable)item;
        }
        List list = (List)item;
        Closeable ret = (Closeable)list.remove(list.size() - 1);
        if (list.size() == 0) {
            this.code_garbage.remove(code);
        }
        return ret;
    }

    private void clearGarbage() {
        for (Object garbage_instance : this.code_garbage.values()) {
            if (garbage_instance instanceof Closeable) {
                ((Closeable)garbage_instance).close();
                continue;
            }
            if (!(garbage_instance instanceof List)) continue;
            Iterator iter2 = ((List)garbage_instance).iterator();
            while (iter2.hasNext()) {
                ((Closeable)iter2.next()).close();
            }
        }
        this.code_garbage.clear();
    }

    public void startAll() {
        Statement current = this.root;
        while ((current = current.next) != null) {
            if (current.exec_code == null || current.instance != null) continue;
            try {
                try {
                    Closeable garbage_instance = this.getGarbage(current.exec_code);
                    if (garbage_instance != null) {
                        current.instance = garbage_instance;
                        continue;
                    }
                    current.instance = ScriptCompiler.compile(current.code).execute(this.namespace);
                }
                catch (ScriptParserException e) {
                    System.err.println(e.getMessage());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.clearGarbage();
    }

    private void stopAllAndKeepGarbage() {
        Statement current = this.root;
        while ((current = current.next) != null) {
            if (current.instance == null) continue;
            this.addToGarbage(current.exec_code, current.instance);
            current.instance = null;
        }
    }

    public void stopAll() {
        Statement current = this.root;
        while ((current = current.next) != null) {
            if (current.instance == null) continue;
            current.instance.close();
            current.instance = null;
        }
        this.clearGarbage();
    }

    public List<ScriptObject> getObjects() {
        return this.objectlist;
    }

    public ScriptObject findObject(String name) {
        String lname = name;
        if (lname == null) {
            lname = "";
        }
        ScriptObject object = this.objects.get(lname);
        return object;
    }

    public ScriptObject getObject(String name) {
        ScriptObject object;
        String lname = name;
        if (lname == null) {
            lname = "";
        }
        if ((object = this.objects.get(lname)) == null) {
            object = new ScriptObject(name);
            this.objects.put(lname, object);
            this.objectlist.add(object);
        }
        return object;
    }

    public void setString(String code) {
        this.clearAndKeepGarbage();
        Statement current = this.root;
        String[] statements = ScriptTokenParser.seperateStatements(code);
        int i = 0;
        while (i < statements.length) {
            current = current.insertAfter(statements[i]);
            ++i;
        }
        this.last = current;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Statement current = this.root;
        while ((current = current.next) != null) {
            buffer.append(current.code);
        }
        return buffer.toString();
    }

    public class Statement {
        private String code = null;
        private String exec_code = null;
        private ScriptObject object = null;
        private Statement previous = null;
        private Statement next = null;
        private Closeable instance = null;

        public ScriptObject getObject() {
            return this.object;
        }

        public Statement getPrevious() {
            return this.previous;
        }

        public Statement getNext() {
            return this.next;
        }

        public String toString() {
            return this.code;
        }

        public void remove() {
            if (this.instance != null) {
                ScriptDocument.this.addToGarbage(this.exec_code, this.instance);
                this.instance = null;
            }
            if (this.object != null) {
                this.object.statements.remove(this);
                if (this.object.statements.size() == 0) {
                    this.object.remove();
                }
            }
            if (this.next != null) {
                this.next.previous = this.previous;
            }
            if (this.previous != null) {
                this.previous.next = this.next;
            }
            if (this == ScriptDocument.this.last) {
                ScriptDocument.this.last = this.previous;
            }
        }

        public Statement insertAfter(String code) {
            String ecode;
            Statement nextbak = this.next;
            this.next = new Statement();
            this.next.previous = this;
            this.next.next = nextbak;
            this.next.code = code;
            this.next.object = ScriptDocument.this.getObject(ScriptTokenParser.extractStatementResultVariable(code));
            if (this.next.object != null && (ecode = ScriptTokenParser.removeCommentsAndWhiteSpace(this.next.code).trim()).length() != 0) {
                this.next.exec_code = ecode;
            }
            this.next.object.statements.add(this.next);
            if (nextbak != null) {
                nextbak.previous = this.next;
            }
            if (this == ScriptDocument.this.last) {
                ScriptDocument.this.last = this.next;
            }
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ScriptObject {
        private String name;
        protected ArrayList<Statement> statements = new ArrayList();

        public ScriptObject(String name) {
            this.name = name;
        }

        public void add(String code) {
            if (this.statements == null || this.statements.size() == 0) {
                this.setString(code);
                return;
            }
            Statement current = this.statements.get(this.statements.size() - 1);
            String[] insertlines = ScriptTokenParser.seperateStatements(code);
            int i = 0;
            while (i < insertlines.length) {
                current = current.insertAfter(insertlines[i]);
                ++i;
            }
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public String toNormalizedString() {
            String str = this.toString();
            int firsti = 0;
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (!Character.isWhitespace(c)) {
                    firsti = i;
                    break;
                }
                ++i;
            }
            int lasti = str.length();
            int i2 = str.length();
            while (i2 > 0) {
                char c = str.charAt(i2 - 1);
                if (!Character.isWhitespace(c)) {
                    lasti = i2;
                    break;
                }
                --i2;
            }
            return str.substring(firsti, lasti);
        }

        public void setNormalizedString(String value) {
            if (this.statements.size() == 0) {
                this.setString("\n" + value);
                return;
            }
            String str = this.toString();
            int firsti = 0;
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (!Character.isWhitespace(c)) {
                    firsti = i;
                    break;
                }
                ++i;
            }
            int lasti = str.length();
            int i2 = str.length();
            while (i2 > 0) {
                char c = str.charAt(i2 - 1);
                if (!Character.isWhitespace(c)) {
                    lasti = i2;
                    break;
                }
                --i2;
            }
            this.setString(String.valueOf(str.substring(0, firsti)) + value + str.substring(lasti, str.length()));
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            Iterator<Statement> iterator = this.statements.iterator();
            while (iterator.hasNext()) {
                buffer.append(iterator.next().code);
            }
            return buffer.toString();
        }

        public void setString(String code) {
            String[] insertlines = ScriptTokenParser.seperateStatements(code);
            if (this.statements.size() == 0) {
                Statement current = ScriptDocument.this.last;
                int i = 0;
                while (i < insertlines.length) {
                    current = current.insertAfter(insertlines[i]);
                    ++i;
                }
                return;
            }
            Statement current = this.statements.get(0);
            while (current.object == this) {
                current = current.previous;
            }
            Statement[] list = this.statements.toArray(new Statement[this.statements.size()]);
            this.statements.clear();
            int i = 0;
            while (i < list.length) {
                list[i].remove();
                ++i;
            }
            i = 0;
            while (i < insertlines.length) {
                current = current.insertAfter(insertlines[i]);
                ++i;
            }
        }

        public String getName() {
            return this.name;
        }

        public void remove() {
            Statement[] list = this.statements.toArray(new Statement[this.statements.size()]);
            this.statements.clear();
            int i = 0;
            while (i < list.length) {
                list[i].remove();
                ++i;
            }
            String lname = this.name;
            if (lname == null) {
                lname = "";
            }
            ScriptDocument.this.objects.remove(lname);
            ScriptDocument.this.objectlist.remove(this);
        }
    }
}

