/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import rasmus.editor.EditorView;
import rasmus.editor.RasmusEditor;
import rasmus.editor.ScriptDocument;
import rasmus.editor.TextPopupMenu;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.metadata.FunctionCallEditor;
import rasmus.interpreter.ui.GroupMenuListener;
import rasmus.interpreter.ui.GroupMenus;
import rasmus.interpreter.ui.RSyntaxDocument;
import rasmus.interpreter.ui.RegisterFunction;
import rasmus.interpreter.ui.RegisterUnit;

public class ScriptEditor
extends JPanel
implements EditorView {
    JMenuBar menubar;
    private static final long serialVersionUID = 1L;
    BufferedImage offImg;
    JPanel panel;
    JPanel cpanel;
    JTextPane textarea = new JTextPane();
    JScrollPane scrollpane;
    RasmusEditor editor;
    boolean process_running = false;
    GroupMenuListener groupmenulistener = new GroupMenuListener(){

        public void actionPerformed(RegisterUnit.Record record) {
            if (record.unit instanceof RegisterFunction) {
                if (FunctionCallEditor.isEditableFunction(record.name, ScriptEditor.this.globalinterpreter)) {
                    String statement = FunctionCallEditor.editFunctionCall(ScriptEditor.this.editor, String.valueOf(record.name) + "()", ScriptEditor.this.globalinterpreter);
                    if (statement != null) {
                        ScriptEditor.this.textarea.replaceSelection(statement);
                    }
                    return;
                }
                ScriptEditor.this.textarea.replaceSelection(String.valueOf(record.name) + "()");
                return;
            }
            ScriptEditor.this.textarea.replaceSelection(record.name);
        }
    };
    UndoManager undo = new UndoManager();
    NameSpace globalinterpreter;
    String objectscope;
    boolean is_changed = false;

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    public JComponent getJComponent() {
        return this;
    }

    public String getEditorName() {
        return "Source";
    }

    public String simpleifyLineSeperators(String string) {
        StringTokenizer st = new StringTokenizer(string, "\n\r", true);
        StringBuffer sb = new StringBuffer();
        boolean last_was_r = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\r")) {
                sb.append('\n');
                last_was_r = true;
                continue;
            }
            if (token.equals("\n")) {
                if (!last_was_r) {
                    sb.append('\n');
                }
                last_was_r = false;
                continue;
            }
            sb.append(token);
            last_was_r = false;
        }
        return sb.toString();
    }

    public String converToSystemLineSeperator(String string) {
        String line_separator = System.getProperty("line.separator");
        StringTokenizer st = new StringTokenizer(string, "\n\r", true);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\n")) {
                sb.append(line_separator);
                continue;
            }
            if (token.equals("\r")) continue;
            sb.append(token);
        }
        return sb.toString();
    }

    public void setObjectScope(String objectscope) {
        ScriptDocument.ScriptObject object;
        this.commit();
        this.objectscope = objectscope;
        String code = null;
        code = objectscope == null ? this.editor.doc.toString() : ((object = this.editor.doc.findObject(objectscope)) == null ? "" : object.toNormalizedString());
        if (code == null) {
            code = "";
        }
        RSyntaxDocument doc = (RSyntaxDocument)this.textarea.getDocument();
        this.textarea.setDocument(new DefaultStyledDocument());
        doc.setText(this.simpleifyLineSeperators(code));
        this.textarea.setDocument(doc);
        this.undo.discardAllEdits();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScriptEditor.this.scrollpane.getViewport().setViewPosition(new Point(0, 0));
            }
        });
        this.is_changed = false;
    }

    public boolean commit() {
        if (this.isChanged()) {
            String code = this.converToSystemLineSeperator(this.textarea.getText());
            if (this.objectscope == null) {
                this.editor.doc.setString(code);
            } else {
                this.editor.doc.getObject(this.objectscope).setNormalizedString(code);
            }
            this.is_changed = false;
            this.setObjectScope(this.objectscope);
            return true;
        }
        return false;
    }

    public void init() {
        this.editor.setJMenuBar(this.menubar);
    }

    public void changed() {
        this.is_changed = true;
    }

    public boolean isChanged() {
        return this.is_changed;
    }

    public ScriptEditor(RasmusEditor editor) {
        this.globalinterpreter = editor.namespace;
        this.editor = editor;
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setOpaque(false);
        this.textarea.setDocument(new RSyntaxDocument(this.globalinterpreter));
        this.textarea.setFont(new Font("Courier", 0, 12));
        Document doc = this.textarea.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent arg0) {
                ScriptEditor.this.changed();
            }

            public void removeUpdate(DocumentEvent arg0) {
                ScriptEditor.this.changed();
            }

            public void changedUpdate(DocumentEvent arg0) {
                ScriptEditor.this.changed();
            }
        });
        doc.addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                ScriptEditor.this.undo.addEdit(evt.getEdit());
            }
        });
        ActionMap textarea_actionmap = this.textarea.getActionMap();
        InputMap textarea_inputmap = this.textarea.getInputMap();
        textarea_inputmap.put(KeyStroke.getKeyStroke("control Z"), "Undo");
        textarea_inputmap.put(KeyStroke.getKeyStroke("control Y"), "Redo");
        textarea_actionmap.put("Undo", new AbstractAction("Undo"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (ScriptEditor.this.undo.canUndo()) {
                        ScriptEditor.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        textarea_actionmap.put("Redo", new AbstractAction("Redo"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (ScriptEditor.this.undo.canRedo()) {
                        ScriptEditor.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.menubar = new JMenuBar();
        JMenu edit_menu = this.menubar.add(new JMenu("Edit"));
        JMenuItem menu_undo = new JMenuItem("Undo");
        menu_undo.setMnemonic('U');
        menu_undo.setAccelerator(KeyStroke.getKeyStroke("control Z"));
        menu_undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (ScriptEditor.this.undo.canUndo()) {
                        ScriptEditor.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        JMenuItem menu_cut = new JMenuItem("Cut");
        menu_cut.setMnemonic('t');
        menu_cut.setAccelerator(KeyStroke.getKeyStroke("control X"));
        menu_cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ScriptEditor.this.textarea.cut();
            }
        });
        JMenuItem menu_copy = new JMenuItem("Copy");
        menu_copy.setMnemonic('C');
        menu_copy.setAccelerator(KeyStroke.getKeyStroke("control C"));
        menu_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ScriptEditor.this.textarea.copy();
            }
        });
        JMenuItem menu_paste = new JMenuItem("Paste");
        menu_paste.setMnemonic('P');
        menu_paste.setAccelerator(KeyStroke.getKeyStroke("control V"));
        menu_paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ScriptEditor.this.textarea.paste();
            }
        });
        JMenuItem menu_delete = new JMenuItem("Delete");
        menu_delete.setMnemonic('D');
        menu_delete.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        menu_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ScriptEditor.this.textarea.replaceSelection("");
            }
        });
        JMenuItem menu_selectAll = new JMenuItem("Select All");
        menu_selectAll.setMnemonic('A');
        menu_selectAll.setAccelerator(KeyStroke.getKeyStroke("control A"));
        menu_selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ScriptEditor.this.textarea.selectAll();
            }
        });
        JMenuItem menu_arguments = new JMenuItem("Arguments...");
        menu_arguments.setAccelerator(KeyStroke.getKeyStroke("F4"));
        menu_arguments.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    int start = ScriptEditor.this.textarea.getSelectionStart();
                    int[] pair = ((RSyntaxDocument)ScriptEditor.this.textarea.getDocument()).extractFunctionCall(start);
                    if (pair == null) {
                        return;
                    }
                    ScriptEditor.this.textarea.select(pair[0], pair[0] + pair[1]);
                    String token = ScriptEditor.this.textarea.getDocument().getText(pair[0], pair[1]);
                    String expr = FunctionCallEditor.editFunctionCall(ScriptEditor.this.editor, token, ScriptEditor.this.globalinterpreter);
                    if (expr != null) {
                        ScriptEditor.this.textarea.replaceSelection(expr);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        edit_menu.add(menu_undo);
        edit_menu.addSeparator();
        edit_menu.add(menu_cut);
        edit_menu.add(menu_copy);
        edit_menu.add(menu_paste);
        edit_menu.add(menu_delete);
        edit_menu.addSeparator();
        edit_menu.add(menu_selectAll);
        edit_menu.addSeparator();
        edit_menu.add(menu_arguments);
        GroupMenus groupmenu = new GroupMenus(this.globalinterpreter, this.groupmenulistener);
        this.menubar.add(groupmenu);
        this.menubar = editor.processMenuBar(this.menubar);
        TextPopupMenu.addPopupMenu(this.textarea);
        JPanel textpanel = new JPanel();
        textpanel.setLayout(new BorderLayout());
        textpanel.add(this.textarea);
        this.scrollpane = new JScrollPane(textpanel);
        this.setLayout(new BorderLayout());
        this.add(this.scrollpane);
        this.setVisible(true);
    }

    public void closing() {
    }
}

