/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import rasmus.editor.EditorView;
import rasmus.editor.ExpressionEditor;
import rasmus.editor.InstrumentsTree;
import rasmus.editor.RasmusEditor;
import rasmus.editor.ScriptDocument;
import rasmus.editor.TableTransferHandler;
import rasmus.editor.TimePositionListener;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.midi.MidiKeyListener;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.parser.ScriptElement;
import rasmus.interpreter.parser.ScriptOptimizer;
import rasmus.interpreter.parser.ScriptParser;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.parser.ScriptTokenizer;
import rasmus.util.ABCTokenizer;

public class TableEditor
extends JPanel
implements EditorView {
    private static final long serialVersionUID = 1L;
    JScrollPane scrollpane;
    JTable table;
    String objectscope = null;
    RasmusEditor editor;
    static String[] scale_items = new String[]{"1/48", "1/36", "1/32", "1/24", "1/16", "1/12", "1/9", "1/8", "1/4", "1", "4", "8", "12", "16"};
    static double[] scales = new double[]{0.020833333333333332, 0.027777777777777776, 0.03125, 0.041666666666666664, 0.0625, 0.08333333333333333, 0.1111111111111111, 0.125, 0.25, 1.0, 4.0, 8.0, 12.0, 16.0};
    static int[] abcscales = new int[]{192, 144, 128, 96, 64, 48, 36, 32, 16, 4, 1, 1, 1, 1};
    JCheckBoxMenuItem[] zoom_items = new JCheckBoxMenuItem[scale_items.length];
    ParsedTableModel model;
    AbstractTableModel posmodel;
    MidiKeyListener keylistener = new MidiKeyListener();
    Receiver recv_midiin = new Receiver(){

        public void send(MidiMessage msg, long tick) {
            SwingUtilities.invokeLater(new SendMidiRunnable(TableEditor.this.recv_midiin2, msg, tick));
        }

        public void close() {
        }
    };
    Receiver recv_midiin2 = new Receiver(){

        public void send(MidiMessage msg, long tick) {
            if (TableEditor.this.it.isInFileSelectionMode() || TableEditor.this.it.tree.isVisible() && TableEditor.this.it.tree.hasFocus()) {
                TableEditor.this.it.recv_midiin.send(msg, tick);
                return;
            }
            if (!TableEditor.this.table.isVisible()) {
                return;
            }
            if (!TableEditor.this.table.hasFocus()) {
                return;
            }
            TableEditor.this.procSessMidiSetup();
            if (msg instanceof ShortMessage) {
                ShortMessage sms = (ShortMessage)msg;
                if (sms.getCommand() == 144 && sms.getData2() > 0) {
                    TableEditor.this.noteOn(sms.getData1(), sms.getData2());
                }
                if (sms.getCommand() == 128 || sms.getCommand() == 144 && sms.getData2() == 0) {
                    TableEditor.this.noteOff(sms.getData1());
                }
            }
            TableEditor.this.sendMessage(msg);
        }

        public void close() {
        }
    };
    Receiver recv = new Receiver(){

        public void send(MidiMessage msg, long tick) {
            TableEditor.this.procSessMidiSetup();
            if (msg instanceof ShortMessage) {
                ShortMessage sms = (ShortMessage)msg;
                if (sms.getCommand() == 144 && sms.getData2() > 0) {
                    TableEditor.this.noteOn(sms.getData1(), 0);
                    try {
                        ShortMessage newmsg = new ShortMessage();
                        newmsg.setMessage(sms.getCommand(), sms.getChannel(), sms.getData1(), TableEditor.this.midi_setup_v);
                        msg = newmsg;
                    }
                    catch (InvalidMidiDataException e) {
                        e.printStackTrace();
                    }
                }
                if (sms.getCommand() == 128 || sms.getCommand() == 144 && sms.getData2() == 0) {
                    TableEditor.this.noteOff(sms.getData1());
                }
            }
            TableEditor.this.sendMessage(msg);
        }

        public void close() {
        }
    };
    int[] downnnotes = new int[127];
    double midi_setup_lastbeat;
    int midi_setup_lastcol;
    int midi_setup_c;
    int midi_setup_v;
    int midi_setup_o;
    StringBuffer notebuffer;
    int stepsize;
    String[] basenotes;
    JComboBox combobox_steplens;
    JComboBox combobox_voct;
    JCheckBox chord_checkbox;
    JComboBox controls_combobox;
    JComboBox o_combobox;
    JComboBox v_combobox;
    JComboBox c_combobox;
    boolean chord_input_mode;
    boolean stop_param_update;
    String[] controls;
    String[] controls_i;
    TableTransferHandler transferhandler;
    JPopupMenu popup_zoom;
    InstrumentsTree it;
    int playrow;
    TimePositionListener timeposlistener;
    RasmusTableCellRenderer cellrenderer;
    Receiver midi_out;
    JMenuBar menubar;
    Interpreter test_midi_interpreter;
    static /* synthetic */ Class class$0;

    public boolean commit() {
        if (this.model != null && this.model.changed) {
            ScriptDocument.Statement pre = null;
            ScriptDocument doc = this.editor.doc;
            ScriptDocument.ScriptObject object = doc.getObject(this.objectscope);
            if (object.getStatements().size() != 0) {
                pre = object.getStatements().get(0);
                while (pre.getObject() == object) {
                    pre = pre.getPrevious();
                }
            }
            for (ScriptDocument.Statement st : this.model.parsedstatements) {
                st.remove();
            }
            if (object.getStatements().size() != 0) {
                ScriptDocument.Statement next = pre = object.getStatements().get(0);
                while ((next = (pre = next).getNext()) != null && next.getObject() == object) {
                }
            }
            if (pre == null) {
                pre = doc.getLast();
            }
            StringBuffer abcbuffer = new StringBuffer();
            String abc_legalSymbols = "zxabcdefgABCDEFG";
            HashMap<Double, Integer> delaytimetable = new HashMap<Double, Integer>();
            int delaycolid = 0;
            int i = this.model.cols.size() - 1;
            while (i >= 0) {
                ParsedTableModel.TableCol col = this.model.cols.get(i);
                if (col.rows.size() != 0) break;
                this.model.cols.remove(i);
                --i;
            }
            for (ParsedTableModel.TableCol col : this.model.cols) {
                if (col.changed || col.delaystatements != null || col.delaystatements == null && col.abcstatement == null) {
                    String code;
                    boolean abc_used = false;
                    boolean delay_used = false;
                    int abc_scale = this.model.abcscale;
                    double pos = 0.0;
                    abcbuffer.setLength(0);
                    abcbuffer.append("[L:1/" + abc_scale + "]");
                    boolean first_item = true;
                    Iterator<Map.Entry<Double, String>> criter = col.rows.entrySet().iterator();
                    StringBuffer cmdpart = new StringBuffer();
                    StringBuffer notepart = new StringBuffer();
                    while (criter.hasNext()) {
                        Map.Entry<Double, String> element = criter.next();
                        String val = element.getValue().trim();
                        double abcpos = element.getKey() * (double)abc_scale / 4.0;
                        if (val.startsWith("<-")) {
                            delay_used = true;
                            continue;
                        }
                        if (val.length() == 0) continue;
                        cmdpart.setLength(0);
                        notepart.setLength(0);
                        int i2 = 0;
                        while (i2 < val.length()) {
                            char c = val.charAt(i2);
                            if (c == '[') {
                                while (i2 < val.length()) {
                                    c = val.charAt(i2);
                                    cmdpart.append(c);
                                    if (c != ']') {
                                        ++i2;
                                        continue;
                                    }
                                    break;
                                }
                            } else if (!Character.isWhitespace(c)) {
                                notepart.append(c);
                            }
                            ++i2;
                        }
                        double delta = abcpos - pos;
                        String delta_str = ABCTokenizer.formatNoteLen(delta);
                        pos = abcpos;
                        if (first_item) {
                            if (delta != 0.0) {
                                abcbuffer.append('z');
                                if (!delta_str.equals("1")) {
                                    abcbuffer.append(delta_str);
                                }
                            }
                            first_item = false;
                        } else if (!delta_str.equals("1")) {
                            abcbuffer.append(delta_str);
                        }
                        String nt = notepart.toString();
                        if (nt.length() == 0) {
                            nt = "z";
                        }
                        if (cmdpart.length() != 0) {
                            abcbuffer.append(cmdpart);
                        }
                        if (!nt.equalsIgnoreCase("z") || criter.hasNext()) {
                            if (nt.length() > 0 && Character.isDigit(nt.charAt(0))) {
                                abcbuffer.append("[d:" + nt + "]z");
                            } else {
                                int ncount = 0;
                                int i3 = 0;
                                while (i3 < nt.length()) {
                                    char l = nt.charAt(i3);
                                    if (abc_legalSymbols.indexOf(l) != -1) {
                                        ++ncount;
                                    }
                                    ++i3;
                                }
                                if (ncount > 1) {
                                    abcbuffer.append("[" + nt + "]");
                                } else {
                                    abcbuffer.append(nt);
                                }
                            }
                        }
                        abc_used = true;
                    }
                    if (abc_used) {
                        code = "\n" + this.objectscope + " <- abc(\"" + abcbuffer.toString() + "\");";
                        pre = pre.insertAfter(code);
                    }
                    for (Map.Entry<Double, String> element : col.rows.entrySet()) {
                        Integer cc;
                        String val = element.getValue().trim();
                        if (!val.startsWith("<-")) continue;
                        Double epos = element.getKey();
                        String pos2 = Double.toString(epos);
                        if (pos2.endsWith(".0")) {
                            pos2 = pos2.substring(0, pos2.length() - 2);
                        }
                        int c = (cc = (Integer)delaytimetable.get(epos)) == null ? 0 : cc;
                        int i4 = c;
                        while (i4 < delaycolid) {
                            String code2 = "\n" + this.objectscope + " <- delay(" + pos2 + ");";
                            pre = pre.insertAfter(code2);
                            ++i4;
                        }
                        delaytimetable.put(epos, delaycolid + 1);
                        code = "\n" + this.objectscope + " <- delay(" + pos2 + ") " + val + ";";
                        pre = pre.insertAfter(code);
                    }
                    if (!delay_used && abc_used) continue;
                    if (!delay_used) {
                        Integer cc = (Integer)delaytimetable.get(0.0);
                        int c = cc == null ? 0 : cc;
                        int i5 = c;
                        while (i5 < delaycolid + 1) {
                            String code3 = "\n" + this.objectscope + " <- delay(0);";
                            pre = pre.insertAfter(code3);
                            ++i5;
                        }
                        delaytimetable.put(0.0, delaycolid + 1);
                    }
                    ++delaycolid;
                    continue;
                }
                if (col.abcstatement != null) {
                    pre = pre.insertAfter(col.abcstatement.toString());
                }
                if (col.delaystatements == null) continue;
                Iterator<ScriptDocument.Statement> diter = col.delaystatements.iterator();
                while (diter.hasNext()) {
                    pre = pre.insertAfter(diter.next().toString());
                }
                ++delaycolid;
            }
            this.parse();
            return true;
        }
        return false;
    }

    public JComponent getJComponent() {
        return this;
    }

    public String getEditorName() {
        return "Pattern";
    }

    public void parse() {
        this.model = new ParsedTableModel();
        ScriptDocument.ScriptObject object = this.editor.doc.findObject(this.objectscope);
        if (object != null) {
            for (ScriptDocument.Statement rst : object.getStatements()) {
                this.model.parseStatement(rst, rst.toString());
            }
        }
        this.model.calcScale();
        this.model.active = true;
        this.table.setModel(this.model);
        this.posmodel.fireTableDataChanged();
    }

    public void setObjectScope(String objectscope) {
        this.commit();
        this.objectscope = objectscope;
        if (this.objectscope == null) {
            this.objectscope = "output";
        }
        this.parse();
        this.midi_setup_lastbeat = 0.0;
        this.midi_setup_lastcol = -1;
    }

    public void sendMessage(MidiMessage msg) {
        if (msg instanceof ShortMessage && msg.getMessage().length != 1) {
            try {
                ShortMessage sms = (ShortMessage)msg;
                ShortMessage newmsg = new ShortMessage();
                int cmd = sms.getCommand();
                int data1 = sms.getData1();
                int data2 = sms.getData2();
                if (cmd == 144 || cmd == 128) {
                    int odata1 = data1;
                    if (cmd == 128 || data2 == 0) {
                        data1 = this.downnnotes[odata1];
                    } else {
                        if ((data1 += (this.midi_setup_o - 4) * 12) < 0) {
                            data1 = 0;
                        }
                        if (data1 > 127) {
                            data1 = 127;
                        }
                        this.downnnotes[odata1] = data1;
                    }
                }
                newmsg.setMessage(cmd, this.midi_setup_c - 1, data1, data2);
                msg = newmsg;
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
        this.midi_out.send(msg, -1L);
    }

    public String updateOnlyIfNotEmpty(String before, String after) {
        if (after.length() == 0) {
            return before;
        }
        return after;
    }

    public void procSessMidiSetup() {
        this.procSessMidiSetup(true);
    }

    public void procSessMidiSetup(boolean doins) {
        String pvalue;
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (col == -1) {
            return;
        }
        if (row == -1) {
            return;
        }
        if (this.model == null) {
            return;
        }
        double beat = (double)row * this.model.scale;
        if (col != this.midi_setup_lastcol || this.midi_setup_lastbeat > beat) {
            this.midi_setup_c = 1;
            this.midi_setup_o = 4;
            this.midi_setup_v = 127;
            this.midi_setup_lastbeat = -2.147483648E9;
        }
        if (this.model.cols.size() <= col) {
            return;
        }
        ParsedTableModel.TableCol tablecol = this.model.cols.get(col);
        TreeMap<Double, String> rows = tablecol.rows;
        String str_c = null;
        String str_o = null;
        String str_v = null;
        String str_i = null;
        for (Map.Entry<Double, String> entry : rows.subMap(this.midi_setup_lastbeat, beat).entrySet()) {
            if (entry.getKey() == this.midi_setup_lastbeat) continue;
            pvalue = entry.getValue();
            str_c = this.updateOnlyIfNotEmpty(str_c, this.extractParamValue("c", pvalue));
            str_o = this.updateOnlyIfNotEmpty(str_o, this.extractParamValue("o", pvalue));
            str_v = this.updateOnlyIfNotEmpty(str_v, this.extractParamValue("v", pvalue));
            str_i = this.updateOnlyIfNotEmpty(str_i, this.extractParamValue("i", pvalue));
        }
        String string = rows.get(beat);
        if (string != null) {
            pvalue = string;
            str_c = this.updateOnlyIfNotEmpty(str_c, this.extractParamValue("c", pvalue));
            str_o = this.updateOnlyIfNotEmpty(str_o, this.extractParamValue("o", pvalue));
            str_v = this.updateOnlyIfNotEmpty(str_v, this.extractParamValue("v", pvalue));
            str_i = this.updateOnlyIfNotEmpty(str_i, this.extractParamValue("i", pvalue));
        }
        if (str_c != null && str_c.length() != 0) {
            try {
                this.midi_setup_c = Integer.parseInt(str_c);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (str_o != null && str_o.length() != 0) {
            try {
                this.midi_setup_o = Integer.parseInt(str_o);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (str_v != null && str_v.length() != 0) {
            try {
                this.midi_setup_v = Integer.parseInt(str_v);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (doins && str_i != null) {
            String program = str_i;
            String bank = null;
            int li = str_i.indexOf(",");
            if (li != -1) {
                bank = program.substring(li + 1);
                program = program.substring(0, li);
            }
            if (bank != null) {
                int i_bank = Integer.parseInt(bank);
                if (i_bank < 0) {
                    i_bank = 0;
                }
                if (i_bank > 16256) {
                    i_bank = 16256;
                }
                int m_bank = i_bank / 128;
                try {
                    ShortMessage smsg = new ShortMessage();
                    smsg.setMessage(176, this.midi_setup_c - 1, 0, m_bank);
                    this.sendMessage(smsg);
                }
                catch (InvalidMidiDataException e) {
                    e.printStackTrace();
                }
                int l_bank = i_bank % 128;
                try {
                    ShortMessage smsg = new ShortMessage();
                    smsg.setMessage(176, this.midi_setup_c - 1, 32, l_bank);
                    this.sendMessage(smsg);
                }
                catch (InvalidMidiDataException e) {
                    e.printStackTrace();
                }
            }
            try {
                int i_program = Integer.parseInt(program);
                ShortMessage smsg = new ShortMessage();
                smsg.setMessage(192, this.midi_setup_c - 1, i_program, 0);
                this.sendMessage(smsg);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
        this.midi_setup_lastcol = col;
        this.midi_setup_lastbeat = beat;
    }

    public void noteOn(int note, int vel) {
        if (this.chord_input_mode) {
            this.notebuffer.append(this.convertNote(note - 48));
            this.setNote(this.notebuffer.toString());
            if (vel != 0) {
                this.setParam("v", Integer.toString(vel));
            }
        } else {
            if (vel != 0) {
                this.setParam("v", Integer.toString(vel));
            }
            this.enterNote(this.convertNote(note - 48));
        }
    }

    public void noteOff(int note) {
        if (!this.chord_input_mode) {
            return;
        }
        if (this.notebuffer.length() != 0) {
            this.enterNote(this.notebuffer.toString());
            this.notebuffer.setLength(0);
        }
    }

    public String convertNote(int in) {
        int note = in % 12;
        if (note < 0) {
            note += 12;
        }
        int octave = (in - note) / 12;
        StringBuffer base = new StringBuffer(this.basenotes[note]);
        if (octave > 0) {
            --octave;
            base = new StringBuffer(base.toString().toLowerCase());
        }
        while (octave > 0) {
            base.append('\'');
            --octave;
        }
        while (octave < 0) {
            base.append(',');
            ++octave;
        }
        return base.toString();
    }

    public String extractParamValue(String paramname, String value) {
        StringBuffer parambuff = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '[') {
                parambuff.setLength(0);
                while (i < value.length()) {
                    c = value.charAt(i);
                    parambuff.append(c);
                    if (c == ']') break;
                    ++i;
                }
                String p = parambuff.toString();
                if (p.startsWith("[" + paramname + ":")) {
                    int li = p.indexOf(":");
                    p = p.substring(li + 1);
                    p = p.substring(0, p.length() - 1).trim();
                    return p;
                }
            }
            ++i;
        }
        return "";
    }

    public String getParam(String paramname) {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row == -1) {
            return "";
        }
        if (col == -1) {
            return "";
        }
        String value = ((String)this.table.getValueAt(row, col)).trim();
        if (value.startsWith("<-")) {
            return "";
        }
        return this.extractParamValue(paramname, value);
    }

    public void setParam(String paramname, String paramvalue) {
        if (this.stop_param_update) {
            return;
        }
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row == -1) {
            return;
        }
        if (col == -1) {
            return;
        }
        paramvalue = paramvalue.trim();
        String value = ((String)this.table.getValueAt(row, col)).trim();
        String code = "[" + paramname + ":" + paramvalue + "]";
        if (value.length() == 0 || value.startsWith("<-")) {
            if (paramvalue.length() == 0) {
                return;
            }
            this.table.setValueAt(code, row, col);
        } else {
            StringBuffer notepart = new StringBuffer();
            StringBuffer cmdpart = new StringBuffer();
            StringBuffer parambuff = new StringBuffer();
            boolean paramset = false;
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == '[') {
                    parambuff.setLength(0);
                    while (i < value.length()) {
                        c = value.charAt(i);
                        parambuff.append(c);
                        if (c == ']') break;
                        ++i;
                    }
                    String p = parambuff.toString();
                    if (p.startsWith("[" + paramname + ":")) {
                        paramset = true;
                        if (paramvalue.length() != 0) {
                            if (cmdpart.length() != 0) {
                                cmdpart.append(' ');
                            }
                            cmdpart.append(code);
                        }
                    } else {
                        if (cmdpart.length() != 0) {
                            cmdpart.append(' ');
                        }
                        cmdpart.append(p);
                    }
                } else if (!Character.isWhitespace(c)) {
                    notepart.append(c);
                }
                ++i;
            }
            if (!paramset) {
                if (paramname.equals("c")) {
                    if (cmdpart.length() != 0) {
                        cmdpart.insert(0, String.valueOf(code) + " ");
                    } else {
                        cmdpart.append(code);
                    }
                } else {
                    if (cmdpart.length() != 0) {
                        cmdpart.append(' ');
                    }
                    cmdpart.append(code);
                }
            }
            code = notepart.length() == 0 ? cmdpart.toString() : String.valueOf(notepart.toString()) + " " + cmdpart.toString();
            this.table.setValueAt(code, row, col);
        }
        this.table.tableChanged(new TableModelEvent(this.table.getModel(), row, row, col));
    }

    public void setNote(String code) {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        String value = ((String)this.table.getValueAt(row, col)).trim();
        if (code.length() == 0 || value.length() == 0 || value.startsWith("<-")) {
            this.table.setValueAt(code, row, col);
        } else {
            StringBuffer cmdpart = new StringBuffer();
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == '[') {
                    if (cmdpart.length() != 0) {
                        cmdpart.append(' ');
                    }
                    while (i < value.length()) {
                        c = value.charAt(i);
                        cmdpart.append(c);
                        if (c == ']') break;
                        ++i;
                    }
                }
                ++i;
            }
            code = String.valueOf(code.trim()) + " " + cmdpart.toString();
            this.table.setValueAt(code, row, col);
        }
        this.table.tableChanged(new TableModelEvent(this.table.getModel(), row, row, col));
    }

    public void enterNote(String code) {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        this.setNote(code);
        this.table.changeSelection(row + this.stepsize, col, false, false);
    }

    public void updateParamFields() {
        this.stop_param_update = true;
        String o_param = this.getParam("o");
        String v_param = this.getParam("v");
        String c_param = this.getParam("c");
        this.o_combobox.setSelectedItem(o_param);
        this.v_combobox.setSelectedItem(v_param);
        this.c_combobox.setSelectedItem(c_param);
        this.o_combobox.getEditor().setItem(o_param);
        this.v_combobox.getEditor().setItem(v_param);
        this.c_combobox.getEditor().setItem(c_param);
        this.it.setSelectedItem(this.getParam("i"));
        String f = this.getParam("f").trim();
        boolean f_set = false;
        int i = 0;
        while (i < this.controls_i.length) {
            if (this.controls_i[i].equals(f)) {
                this.controls_combobox.setSelectedIndex(i);
                f_set = true;
                break;
            }
            ++i;
        }
        if (!f_set) {
            this.controls_combobox.setSelectedItem(f);
        }
        this.stop_param_update = false;
    }

    public void repaintRow(int row) {
        if (row == -1) {
            return;
        }
        Rectangle rect = this.table.getCellRect(row, 0, true);
        rect.x = 0;
        rect.width = this.table.getWidth();
        this.table.repaint(rect);
    }

    public TableEditor(RasmusEditor editor) {
        int i = 0;
        while (i < this.downnnotes.length) {
            this.downnnotes[i] = i;
            ++i;
        }
        this.keylistener.setReceiver(this.recv);
        this.midi_setup_lastbeat = 0.0;
        this.midi_setup_lastcol = -1;
        this.midi_setup_c = 1;
        this.midi_setup_v = 127;
        this.midi_setup_o = 4;
        this.notebuffer = new StringBuffer();
        this.stepsize = 1;
        this.basenotes = new String[]{"C", "^C", "D", "^D", "E", "F", "^F", "G", "^G", "A", "^A", "B"};
        this.chord_input_mode = true;
        this.stop_param_update = false;
        this.controls = new String[]{"1  Mod", "7  Vol", "10 Pan", "11 Exp", "91 Eff.1(Rev)", "92 Eff.2", "93 Eff.3(Cho)", "94 Eff.4", "95 Eff.5", "p Pitch"};
        this.controls_i = new String[]{"1", "7", "10", "11", "91", "93", "p"};
        this.playrow = -1;
        this.timeposlistener = new TimePositionListener(){

            public void start() {
            }

            public void stop() {
                int lastrow = TableEditor.this.playrow;
                TableEditor.this.playrow = -1;
                TableEditor.this.repaintRow(lastrow);
            }

            public void positionChange(double time, double beat) {
                int row;
                if (TableEditor.this.model != null && (row = beat < 0.0 ? -1 : (int)(beat / TableEditor.this.model.scale)) != TableEditor.this.playrow) {
                    int lastrow = TableEditor.this.playrow;
                    TableEditor.this.playrow = row;
                    if (TableEditor.this.isVisible()) {
                        TableEditor.this.repaintRow(lastrow);
                        TableEditor.this.repaintRow(TableEditor.this.playrow);
                    }
                }
            }
        };
        this.cellrenderer = new RasmusTableCellRenderer();
        this.test_midi_interpreter = new Interpreter(editor.namespace);
        this.test_midi_interpreter.setAutoCommit(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setOpaque(false);
        this.editor = editor;
        editor.addTimePositionListener(this.timeposlistener);
        this.setLayout(new BorderLayout());
        JPanel formatpanel = new JPanel();
        formatpanel.setOpaque(false);
        formatpanel.setLayout(new FlowLayout(0));
        String[] steplens = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"};
        this.combobox_steplens = new JComboBox<String>(steplens);
        this.combobox_steplens.setSelectedIndex(1);
        this.combobox_steplens.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TableEditor.this.stepsize = Integer.parseInt((String)TableEditor.this.combobox_steplens.getSelectedItem());
            }
        });
        String[] voct = new String[]{"C,,,,", "C,,,", "C,,", "C,", "C", "c", "c'", "c''", "c'''", "C''''"};
        this.combobox_voct = new JComboBox<String>(voct);
        this.combobox_voct.setSelectedIndex(3);
        this.combobox_voct.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TableEditor.this.keylistener.setOctave(TableEditor.this.combobox_voct.getSelectedIndex());
                TableEditor.this.it.keylistener.setOctave(TableEditor.this.combobox_voct.getSelectedIndex());
            }
        });
        formatpanel.add(new JLabel("Steps:"));
        formatpanel.add(this.combobox_steplens);
        formatpanel.add(new JLabel("Key.Oct.:"));
        formatpanel.add(this.combobox_voct);
        String[] o_str = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        String[] v_str = new String[]{"16", "25", "32", "50", "64", "80", "96", "100", "127"};
        String[] c_str = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"};
        this.o_combobox = new JComboBox<String>(o_str);
        this.v_combobox = new JComboBox<String>(v_str);
        this.c_combobox = new JComboBox<String>(c_str);
        Dimension psize = this.o_combobox.getPreferredSize();
        psize.width = 50;
        this.o_combobox.setPreferredSize(psize);
        this.v_combobox.setPreferredSize(psize);
        this.c_combobox.setPreferredSize(psize);
        this.o_combobox.setEditable(true);
        this.o_combobox.setSelectedItem("");
        this.v_combobox.setEditable(true);
        this.v_combobox.setSelectedItem("");
        this.c_combobox.setEditable(true);
        this.c_combobox.setSelectedItem("");
        this.o_combobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TableEditor.this.setParam("o", (String)TableEditor.this.o_combobox.getSelectedItem());
            }
        });
        this.v_combobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TableEditor.this.setParam("v", (String)TableEditor.this.v_combobox.getSelectedItem());
            }
        });
        this.c_combobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TableEditor.this.setParam("c", (String)TableEditor.this.c_combobox.getSelectedItem());
            }
        });
        this.it = new InstrumentsTree(editor, this);
        this.it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String selitem = TableEditor.this.it.getSelectedItem();
                if (selitem == null) {
                    return;
                }
                TableEditor.this.setParam("i", selitem);
            }
        });
        formatpanel.add(new JLabel("Oct.:"));
        formatpanel.add(this.o_combobox);
        formatpanel.add(new JLabel("Vel.:"));
        formatpanel.add(this.v_combobox);
        formatpanel.add(new JLabel("Channel:"));
        formatpanel.add(this.c_combobox);
        this.controls_combobox = new JComboBox<String>(this.controls);
        this.controls_combobox.setEditable(true);
        this.controls_combobox.setSelectedItem("");
        this.controls_combobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = (String)TableEditor.this.controls_combobox.getSelectedItem();
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < s.length()) {
                    char c = s.charAt(i);
                    if (Character.isWhitespace(c)) break;
                    sb.append(c);
                    ++i;
                }
                TableEditor.this.setParam("f", sb.toString());
            }
        });
        psize = this.controls_combobox.getPreferredSize();
        psize.width = 105;
        this.controls_combobox.setPreferredSize(psize);
        formatpanel.add(new JLabel("Control:"));
        formatpanel.add(this.controls_combobox);
        this.chord_checkbox = new JCheckBox("Chord input");
        this.chord_checkbox.setOpaque(false);
        this.chord_checkbox.setSelected(true);
        this.chord_checkbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TableEditor.this.chord_input_mode = TableEditor.this.chord_checkbox.isSelected();
            }
        });
        formatpanel.add(this.chord_checkbox);
        this.add((Component)formatpanel, "North");
        this.table = new JTable(){
            private static final long serialVersionUID = 1L;

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 116) {
                    return false;
                }
                if (e.getKeyCode() == 117) {
                    return false;
                }
                if (e.getKeyCode() == 118) {
                    return false;
                }
                if (e.getKeyCode() == 119) {
                    return false;
                }
                if (e.getKeyCode() == 120) {
                    return false;
                }
                if (e.getKeyCode() == 121) {
                    return false;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setDefaultRenderer(Object.class, this.cellrenderer);
        this.transferhandler = new TableTransferHandler();
        this.table.setTransferHandler(this.transferhandler);
        this.table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                TableEditor.this.keylistener.allNotesOff();
            }

            public void focusLost(FocusEvent arg0) {
                TableEditor.this.keylistener.allNotesOff();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                TableEditor.this.updateParamFields();
            }
        });
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent arg0) {
            }

            public void columnRemoved(TableColumnModelEvent arg0) {
            }

            public void columnMoved(TableColumnModelEvent arg0) {
            }

            public void columnMarginChanged(ChangeEvent arg0) {
            }

            public void columnSelectionChanged(ListSelectionEvent arg0) {
                TableEditor.this.updateParamFields();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent event) {
                if (event.getKeyCode() == 127) {
                    event.consume();
                    return;
                }
                if (TableEditor.this.table.getSelectedRowCount() > 1 || TableEditor.this.table.getSelectedColumnCount() > 1) {
                    return;
                }
                if (TableEditor.this.table.isEditing()) {
                    return;
                }
                if (event.getModifiers() != 0) {
                    return;
                }
                if (event.getKeyChar() == '<') {
                    return;
                }
                if (event.getKeyCode() == 32) {
                    event.consume();
                    return;
                }
                TableEditor.this.keylistener.keyTyped(event);
            }

            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 127) {
                    if (TableEditor.this.table.isEditing()) {
                        return;
                    }
                    if (TableEditor.this.table.getSelectedRowCount() > 1 || TableEditor.this.table.getSelectedColumnCount() > 1) {
                        TableEditor.this.transferhandler.clear(TableEditor.this.table);
                        event.consume();
                        return;
                    }
                    TableEditor.this.enterNote("");
                    event.consume();
                    return;
                }
                if (TableEditor.this.table.getSelectedRowCount() > 1 || TableEditor.this.table.getSelectedColumnCount() > 1) {
                    return;
                }
                if (TableEditor.this.table.isEditing()) {
                    return;
                }
                if (event.getModifiers() != 0) {
                    return;
                }
                if (event.getKeyChar() == '<') {
                    return;
                }
                if (event.getKeyCode() == 32) {
                    TableEditor.this.enterNote("z");
                    event.consume();
                    return;
                }
                TableEditor.this.keylistener.keyPressed(event);
            }

            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 127) {
                    event.consume();
                    return;
                }
                if (TableEditor.this.table.getSelectedRowCount() > 1 || TableEditor.this.table.getSelectedColumnCount() > 1) {
                    return;
                }
                if (TableEditor.this.table.isEditing()) {
                    return;
                }
                if (event.getModifiers() != 0) {
                    return;
                }
                if (event.getKeyChar() == '<') {
                    return;
                }
                if (event.getKeyCode() == 32) {
                    event.consume();
                    return;
                }
                TableEditor.this.keylistener.keyReleased(event);
            }
        });
        this.posmodel = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            public int getRowCount() {
                return TableEditor.this.table.getRowCount();
            }

            public int getColumnCount() {
                return 1;
            }

            public Object getValueAt(int row, int col) {
                double r;
                double scale = 1.0;
                if (TableEditor.this.model != null) {
                    scale = TableEditor.this.model.scale;
                }
                if (Math.abs(Math.rint(r = (double)row * scale) - r) > 1.0E-8) {
                    return "";
                }
                return Long.toString((long)r);
            }
        };
        this.popup_zoom = new JPopupMenu();
        int i2 = 0;
        while (i2 < scale_items.length) {
            this.zoom_items[i2] = new JCheckBoxMenuItem(scale_items[i2]);
            this.zoom_items[i2].addActionListener(new ZoomActionListener(i2));
            this.popup_zoom.add(this.zoom_items[i2]);
            ++i2;
        }
        JTable rowtable = new JTable(this.posmodel);
        rowtable.setColumnSelectionAllowed(false);
        rowtable.setRowSelectionAllowed(false);
        rowtable.setEnabled(false);
        rowtable.setBackground(new JPanel().getBackground());
        rowtable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (TableEditor.this.model == null) {
                    return;
                }
                int i = 0;
                while (i < TableEditor.this.zoom_items.length) {
                    TableEditor.this.zoom_items[i].setState(TableEditor.this.model.scale_index == i);
                    ++i;
                }
                TableEditor.this.popup_zoom.show((JComponent)e.getSource(), e.getX(), e.getY());
            }
        });
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.setRowHeaderView(rowtable);
        this.scrollpane.getRowHeader().setPreferredSize(new Dimension(45, 45));
        JSplitPane splitpane = new JSplitPane();
        splitpane.setDividerLocation(200);
        splitpane.setBorder(BorderFactory.createEmptyBorder());
        splitpane.setLeftComponent(this.it);
        splitpane.setRightComponent(this.scrollpane);
        BasicSplitPaneUI basicsplitui = new BasicSplitPaneUI(){

            public BasicSplitPaneDivider createDefaultDivider() {
                BasicSplitPaneDivider div = new BasicSplitPaneDivider(this, this){
                    private static final long serialVersionUID = 1L;
                    final /* synthetic */ 20 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0);
                    }

                    public void paint(Graphics g) {
                        Dimension size = this.getSize();
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, size.width, size.height);
                    }
                };
                div.setBackground(UIManager.getColor("TabbedPane.contentAreaColor"));
                return div;
            }
        };
        splitpane.setUI(basicsplitui);
        splitpane.setDividerSize(5);
        this.add(splitpane);
        this.menubar = new JMenuBar();
        JMenu edit_menu = this.menubar.add(new JMenu("Edit"));
        JMenuItem menu_cut = new JMenuItem("Cut");
        menu_cut.setMnemonic('t');
        menu_cut.setAccelerator(KeyStroke.getKeyStroke("control X"));
        menu_cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                arg0.setSource(TableEditor.this.table);
                TransferHandler.getCutAction().actionPerformed(arg0);
            }
        });
        JMenuItem menu_copy = new JMenuItem("Copy");
        menu_copy.setMnemonic('C');
        menu_copy.setAccelerator(KeyStroke.getKeyStroke("control C"));
        menu_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                arg0.setSource(TableEditor.this.table);
                TransferHandler.getCopyAction().actionPerformed(arg0);
            }
        });
        JMenuItem menu_paste = new JMenuItem("Paste");
        menu_paste.setMnemonic('P');
        menu_paste.setAccelerator(KeyStroke.getKeyStroke("control V"));
        menu_paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                arg0.setSource(TableEditor.this.table);
                TransferHandler.getPasteAction().actionPerformed(arg0);
            }
        });
        JMenuItem menu_delete = new JMenuItem("Delete");
        menu_delete.setMnemonic('D');
        menu_delete.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        menu_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TableEditor.this.transferhandler.clear(TableEditor.this.table);
            }
        });
        JMenuItem menu_selectAll = new JMenuItem("Select All");
        menu_selectAll.setMnemonic('A');
        menu_selectAll.setAccelerator(KeyStroke.getKeyStroke("control A"));
        menu_selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TableEditor.this.table.selectAll();
            }
        });
        JMenuItem menu_expression_editor = new JMenuItem("Expression...");
        menu_expression_editor.setAccelerator(KeyStroke.getKeyStroke("F4"));
        menu_expression_editor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (TableEditor.this.table.isEditing()) {
                        TableEditor.this.table.getCellEditor().stopCellEditing();
                    }
                    int row = TableEditor.this.table.getSelectedRow();
                    int col = TableEditor.this.table.getSelectedColumn();
                    if (row == -1 || col == -1) {
                        return;
                    }
                    String script = (String)TableEditor.this.table.getValueAt(row, col);
                    if ((script = ExpressionEditor.editScript(TableEditor.this.editor, script)) == null) {
                        return;
                    }
                    TableEditor.this.table.setValueAt(script, row, col);
                    TableEditor.this.table.tableChanged(new TableModelEvent(TableEditor.this.table.getModel(), row, row, col));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        edit_menu.add(menu_cut);
        edit_menu.add(menu_copy);
        edit_menu.add(menu_paste);
        edit_menu.add(menu_delete);
        edit_menu.addSeparator();
        edit_menu.add(menu_selectAll);
        edit_menu.addSeparator();
        edit_menu.add(menu_expression_editor);
        this.menubar = editor.processMenuBar(this.menubar);
        try {
            this.test_midi_interpreter.eval("midi_in <- defaultinputs();");
        }
        catch (ScriptParserException e1) {
            e1.printStackTrace();
        }
        MidiSequence.getInstance(this.test_midi_interpreter.get("midi_in")).addReceiver(this.recv_midiin);
        this.midi_out = MidiSequence.getInstance(editor.realtimeinput);
    }

    public void init() {
        this.editor.setJMenuBar(this.menubar);
    }

    public void closing() {
        this.test_midi_interpreter.close();
    }

    class ParsedTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<TableCol> cols = new ArrayList<TableCol>();
        List<ScriptDocument.Statement> parsedstatements = new ArrayList<ScriptDocument.Statement>();
        boolean changed = false;
        double scale = 0.25;
        int abcscale = 16;
        int scale_index = scales.length - 1;
        double optimalscale = scales[this.scale_index];
        boolean scale_set = false;
        boolean use_scale = false;
        boolean active = false;
        List<TableCol> delaycols = new ArrayList<TableCol>();
        Map<Double, Integer> delaytimetable = new HashMap<Double, Integer>();

        ParsedTableModel() {
        }

        public void calcRowScale(double row) {
            if (row > 1.0E-9) {
                this.use_scale = true;
            }
            while (Math.abs(Math.rint(row / this.optimalscale) - row / this.optimalscale) > 1.0E-9) {
                if (this.scale_index == 0) {
                    return;
                }
                --this.scale_index;
                this.optimalscale = scales[this.scale_index];
            }
        }

        public void calcScale() {
            if (!this.use_scale) {
                this.scale_index = 8;
            }
            this.scale = scales[this.scale_index];
            this.abcscale = abcscales[this.scale_index];
            this.scale_set = true;
        }

        public TableCol getDelayCol(int row) {
            while (this.delaycols.size() <= row) {
                this.delaycols.add(new TableCol());
            }
            return this.delaycols.get(row);
        }

        public void parseDelayStatement(ScriptDocument.Statement statement, String delay, String value) {
            try {
                ScriptElement sp = ScriptParser.parse(delay.toString());
                sp = ScriptOptimizer.optimize(sp);
                if (sp.getElements() != null) {
                    sp = sp.getElements().get(0);
                }
                if (sp.getType() == 5) {
                    Double time = (Double)sp.getValue();
                    Integer d = this.delaytimetable.get(time);
                    d = d == null ? Integer.valueOf(0) : Integer.valueOf(d + 1);
                    this.delaytimetable.put(time, d);
                    int col_index = d;
                    TableCol col = this.getDelayCol(col_index);
                    if (value != null) {
                        if ((value = value.trim()).endsWith(";")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        col.setValue(time, "<- " + value);
                        if (col.delaystatements == null) {
                            col.delaystatements = new ArrayList<ScriptDocument.Statement>();
                        }
                        col.delaystatements.add(statement);
                    }
                    this.parsedstatements.add(statement);
                }
            }
            catch (ScriptParserException e) {
                e.printStackTrace();
            }
        }

        public void parseABCStatement(ScriptDocument.Statement statement, String value) {
            try {
                ScriptElement sp = ScriptParser.parse(value);
                sp = ScriptOptimizer.optimize(sp);
                if (sp.getElements() != null) {
                    sp = sp.getElements().get(0);
                }
                if (sp.getType() == 4) {
                    TableCol col = new TableCol();
                    col.abcstatement = statement;
                    ABCTokenizer abct = new ABCTokenizer();
                    List tokens = abct.parse((String)sp.getValue());
                    double abc_notelen = 0.125;
                    double lastpos = 0.0;
                    int i = 0;
                    while (i < tokens.size()) {
                        int li;
                        String val;
                        Object ntoken;
                        Object token = tokens.get(i);
                        if (token instanceof ABCTokenizer.ABCToken) {
                            ntoken = (ABCTokenizer.ABCToken)token;
                            if (((ABCTokenizer.ABCToken)ntoken).pos != 0.0 || !((ABCTokenizer.ABCToken)ntoken).toString().equalsIgnoreCase("z")) {
                                double endpos;
                                val = col.getValue(((ABCTokenizer.ABCToken)ntoken).pos);
                                li = val.indexOf("[");
                                if (val.length() <= 0 || !Character.isDigit(val.charAt(0))) {
                                    if (li != -1) {
                                        if (((ABCTokenizer.ABCToken)ntoken).symbol != 'z' && ((ABCTokenizer.ABCToken)ntoken).symbol != 'Z') {
                                            if (li == 0) {
                                                val = " " + val;
                                            } else if (val.charAt(li - 1) == ' ') {
                                                --li;
                                            }
                                            val = String.valueOf(val.substring(0, li)) + ((ABCTokenizer.ABCToken)ntoken).toString() + val.substring(li);
                                        }
                                    } else {
                                        val = String.valueOf(val) + ((ABCTokenizer.ABCToken)ntoken).toString();
                                    }
                                    col.setValue(((ABCTokenizer.ABCToken)ntoken).pos, val);
                                    endpos = ((ABCTokenizer.ABCToken)ntoken).pos + ((ABCTokenizer.ABCToken)ntoken).len;
                                    if (endpos > lastpos) {
                                        lastpos = endpos;
                                    }
                                } else {
                                    endpos = ((ABCTokenizer.ABCToken)ntoken).pos;
                                    if (endpos > lastpos) {
                                        lastpos = endpos;
                                    }
                                }
                            }
                        }
                        if (token instanceof ABCTokenizer.CommandToken) {
                            ntoken = (ABCTokenizer.CommandToken)token;
                            if (!((ABCTokenizer.CommandToken)ntoken).fieldname.equals("L") && !((ABCTokenizer.CommandToken)ntoken).fieldname.equals("M")) {
                                if (((ABCTokenizer.CommandToken)ntoken).fieldname.equals("d")) {
                                    val = col.getValue(((ABCTokenizer.CommandToken)ntoken).pos);
                                    li = val.indexOf("[");
                                    if (li != -1) {
                                        if (li == 0) {
                                            val = " " + val;
                                        } else if (val.charAt(li - 1) == ' ') {
                                            --li;
                                        }
                                        val = String.valueOf(val.substring(0, li)) + ((ABCTokenizer.CommandToken)ntoken).fieldvalue + val.substring(li);
                                    } else {
                                        val = String.valueOf(val) + ((ABCTokenizer.CommandToken)ntoken).fieldvalue;
                                    }
                                    col.setValue(((ABCTokenizer.CommandToken)ntoken).pos, val);
                                } else {
                                    val = col.getValue(((ABCTokenizer.CommandToken)ntoken).pos);
                                    String code = ((ABCTokenizer.CommandToken)ntoken).toString();
                                    val = val.length() == 0 ? "[" + code + "]" : String.valueOf(val) + " [" + code + "]";
                                    col.setValue(((ABCTokenizer.CommandToken)ntoken).pos, val);
                                }
                            } else if (((ABCTokenizer.CommandToken)ntoken).fieldname.equals("L")) {
                                abc_notelen = ABCTokenizer.parseNoteLen(((ABCTokenizer.CommandToken)ntoken).fieldvalue.trim());
                            }
                        }
                        ++i;
                    }
                    this.calcRowScale(abc_notelen * 4.0);
                    if (col.getValue(lastpos).length() == 0) {
                        col.setValue(lastpos, "z");
                    }
                    this.parsedstatements.add(statement);
                }
            }
            catch (ScriptParserException e) {
                e.printStackTrace();
            }
        }

        public void parseStatement(ScriptDocument.Statement statement, String st) {
            ScriptTokenizer tokens = new ScriptTokenizer(st);
            if (tokens.hasMoreTokens()) {
                String outputvar = "";
                String token = tokens.nextToken();
                if (token.equals("<-")) {
                    outputvar = "output";
                } else if (tokens.hasMoreTokens()) {
                    outputvar = token;
                    token = tokens.nextToken();
                }
                if (token.equals("<-") && TableEditor.this.objectscope.equalsIgnoreCase(outputvar) && tokens.hasMoreTokens()) {
                    String funcname = tokens.nextToken();
                    if (tokens.hasMoreTokens() && tokens.nextToken().equals("(")) {
                        if (funcname.equalsIgnoreCase("abc")) {
                            boolean ok = true;
                            StringBuffer parametercontent = new StringBuffer();
                            while (tokens.hasMoreTokens()) {
                                token = tokens.nextToken();
                                if (token.equals(")")) break;
                                if (token.equals(",")) {
                                    ok = false;
                                    break;
                                }
                                parametercontent.append(token);
                            }
                            if (ok && tokens.hasMoreTokens() && tokens.nextToken().equals(";")) {
                                this.parseABCStatement(statement, parametercontent.toString());
                            }
                        } else if (funcname.equalsIgnoreCase("delay")) {
                            boolean ok = true;
                            StringBuffer parametercontent = new StringBuffer();
                            int pi = 1;
                            while (tokens.hasMoreTokens()) {
                                token = tokens.nextToken();
                                if (token.equals("(")) {
                                    ++pi;
                                }
                                if (token.equals(")")) {
                                    --pi;
                                }
                                if (pi == 0) break;
                                parametercontent.append(token);
                            }
                            String content = null;
                            if (tokens.hasMoreTokens()) {
                                String ntoken = tokens.nextToken();
                                if (ntoken.equals("<-")) {
                                    int index = tokens.nextIndex();
                                    content = st.substring(index);
                                } else if (!ntoken.equals(";")) {
                                    ok = false;
                                }
                            }
                            if (ok) {
                                this.parseDelayStatement(statement, parametercontent.toString(), content);
                            }
                        }
                    }
                }
            }
        }

        public int getRowCount() {
            return 300;
        }

        public int getColumnCount() {
            return 100;
        }

        public Object getValueAt(int row, int col) {
            if (this.cols.size() <= col) {
                return "";
            }
            if (col < 0) {
                return "";
            }
            TableCol tablecol = this.cols.get(col);
            return tablecol.getValue((double)row * this.scale);
        }

        /*
         * Unable to fully structure code
         */
        public void setValueAt(Object value, int row, int col) {
            if (!(value instanceof String)) {
                return;
            }
            if (col >= 0) ** GOTO lbl6
            return;
lbl-1000:
            // 1 sources

            {
                new TableCol();
lbl6:
                // 2 sources

                ** while (this.cols.size() <= col)
            }
lbl7:
            // 1 sources

            r = (double)row * this.scale;
            if (value != null && ((String)value).indexOf("[") != -1) {
                TableEditor.this.midi_setup_lastbeat = 0.0;
                TableEditor.this.midi_setup_lastcol = -1;
            }
            this.cols.get(col).setValue(r, (String)value);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        class TableCol {
            boolean changed = false;
            int colid = 0;
            ScriptDocument.Statement abcstatement = null;
            List<ScriptDocument.Statement> delaystatements = null;
            TreeMap<Double, String> rows = new TreeMap();

            public TableCol() {
                this.colid = ParsedTableModel.this.cols.size();
                ParsedTableModel.this.cols.add(this);
            }

            public void setValue(double row, String value) {
                String lvalue;
                if (!ParsedTableModel.this.scale_set) {
                    ParsedTableModel.this.calcRowScale(row);
                }
                if (value != null && value.trim().length() == 0) {
                    value = null;
                }
                if ((lvalue = this.rows.get(row)) == null ? value == null : value != null && lvalue.equals(value)) {
                    return;
                }
                if (value == null) {
                    this.rows.remove(row);
                } else {
                    this.rows.put(row, value);
                }
                if (ParsedTableModel.this.active) {
                    this.changed = true;
                    ParsedTableModel.this.changed = true;
                }
            }

            public String getValue(double row) {
                String value = this.rows.get(row);
                if (value == null) {
                    return "";
                }
                return value;
            }
        }
    }

    class SendMidiRunnable
    implements Runnable {
        MidiMessage msg;
        long tick;
        Receiver recv;

        public SendMidiRunnable(Receiver recv, MidiMessage msg, long tick) {
            this.recv = recv;
            this.msg = msg;
            this.tick = tick;
        }

        public void run() {
            this.recv.send(this.msg, this.tick);
        }
    }

    class ZoomActionListener
    implements ActionListener {
        int index;

        public ZoomActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent arg0) {
            if (TableEditor.this.model == null) {
                return;
            }
            TableEditor.this.model.scale_index = this.index;
            TableEditor.this.model.scale = scales[this.index];
            TableEditor.this.model.abcscale = abcscales[this.index];
            TableEditor.this.model.fireTableStructureChanged();
            TableEditor.this.posmodel.fireTableStructureChanged();
        }
    }

    class RasmusTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        Color orgcolor;
        Color playcolor = UIManager.getColor("Table.selectionBackground");

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(null);
            Component ret = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected && !hasFocus && row == TableEditor.this.playrow) {
                this.setBackground(this.playcolor);
            }
            return ret;
        }
    }
}

