/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.TableModelEvent;

public class TableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;

    public void clear(JComponent comp) {
        if (!(comp instanceof JTable)) {
            return;
        }
        JTable table = (JTable)comp;
        int[] rows = table.getSelectedRows();
        int[] cols = table.getSelectedColumns();
        int ri = table.getSelectedRow();
        int ci = table.getSelectedColumn();
        int r = 0;
        while (r < rows.length) {
            int c = 0;
            while (c < cols.length) {
                table.setValueAt("", rows[r], cols[c]);
                ++c;
            }
            ++r;
        }
        table.tableChanged(new TableModelEvent(table.getModel()));
        if (ri != -1 && ci != -1) {
            table.changeSelection(ri, ci, false, false);
        }
    }

    public int getSourceActions(JComponent c) {
        if (!(c instanceof JTable)) {
            return 0;
        }
        return 3;
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
        if (action == 2) {
            this.clear(source);
        }
    }

    public boolean importData(JComponent comp, Transferable t) {
        String s;
        if (!(comp instanceof JTable)) {
            return false;
        }
        JTable table = (JTable)comp;
        try {
            s = (String)t.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        int r = 0;
        int c = 0;
        int ri = table.getSelectedRow();
        int ci = table.getSelectedColumn();
        if (ri == -1) {
            ri = 0;
        }
        if (ci == -1) {
            ci = 0;
        }
        int maxr = table.getRowCount();
        int maxc = table.getColumnCount();
        boolean lastfilled = false;
        StringTokenizer st = new StringTokenizer(s, "\n\t", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\n")) {
                if (!lastfilled && r + ri < maxr && c + ci < maxc) {
                    table.setValueAt("", r + ri, c + ci);
                }
                c = 0;
                ++r;
                lastfilled = false;
                continue;
            }
            if (token.equals("\t")) {
                ++c;
                lastfilled = false;
                continue;
            }
            if (r + ri < maxr && c + ci < maxc) {
                table.setValueAt(token, r + ri, c + ci);
            }
            lastfilled = true;
        }
        table.tableChanged(new TableModelEvent(table.getModel()));
        table.changeSelection(ri, ci, false, false);
        return true;
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (!(comp instanceof JTable)) {
            return false;
        }
        int i = 0;
        while (i < transferFlavors.length) {
            if (transferFlavors[i].isFlavorTextType()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Transferable createTransferable(JComponent comp) {
        if (!(comp instanceof JTable)) {
            return null;
        }
        JTable table = (JTable)comp;
        StringBuffer sb = new StringBuffer();
        int[] rows = table.getSelectedRows();
        int[] cols = table.getSelectedColumns();
        int lastfr = 0;
        int r = 0;
        while (r < rows.length) {
            int lastfc = sb.length();
            boolean row_hascontent = false;
            int c = 0;
            while (c < cols.length) {
                String v = (String)table.getValueAt(rows[r], cols[c]);
                sb.append(v);
                if (v.length() != 0) {
                    lastfc = sb.length();
                    row_hascontent = true;
                }
                sb.append("\t");
                ++c;
            }
            sb.setLength(lastfc);
            if (row_hascontent) {
                lastfr = sb.length();
            }
            sb.append("\n");
            ++r;
        }
        sb.setLength(lastfr);
        return new StringSelection(sb.toString());
    }
}

