/*
 * Decompiled with CFR 0.152.
 */
package rasmus.ext;

import java.io.IOException;
import java.io.InputStream;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.spi.InterpreterExtension;

public class EXTInterpreterExtension
implements InterpreterExtension {
    Interpreter interpreter;

    public void processExtension(String filename) {
        try {
            InputStream inputstream = this.getClass().getResourceAsStream("/rasmus/ext/" + filename);
            if (inputstream == null) {
                System.out.println("Can't find extension " + filename);
                return;
            }
            try {
                this.interpreter.source(inputstream);
            }
            catch (ScriptParserException e) {
                e.printStackTrace();
            }
            inputstream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void execute(Interpreter interpreter) {
        this.interpreter = interpreter;
        this.processExtension("_global.r");
        this.processExtension("audio_bandlimited_osc.r");
        this.processExtension("audio_biquad_filters.r");
        this.processExtension("audio_fft.r");
        this.processExtension("audio_freeverb.r");
        this.processExtension("audio_noises.r");
        this.processExtension("audio_effects.r");
        this.processExtension("math_conversion.r");
        this.processExtension("music_tuning.r");
    }
}

