/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft;

import rasmus.fft.FFTTransformer;
import rasmus.fft.fftw.FFTWProvider;
import rasmus.fft.providers.ComplexRadix2;
import rasmus.fft.spi.FFTProvider;

public class Benchmark {
    public static void main(String[] args) {
        FFTWProvider provider1 = new FFTWProvider();
        ComplexRadix2 provider2 = new ComplexRadix2();
        Benchmark.benchmark(provider1, provider2);
    }

    public static void benchmark(FFTProvider provider1, FFTProvider provider2, int fftsize) {
        int prelen = 20;
        int testlen = 50;
        if (fftsize < 512) {
            prelen = 200;
        }
        if (fftsize <= 128) {
            prelen = 10000;
        }
        if (fftsize < 4) {
            prelen = 20000;
        }
        if (fftsize < 8192) {
            prelen = 100;
        }
        if (fftsize < 4096) {
            prelen = 200;
        }
        if (fftsize < 2048) {
            prelen = 500;
        }
        if (fftsize < 64) {
            prelen = 2000;
        }
        if (fftsize >= 65536) {
            prelen = 15;
            testlen = 20;
        }
        FFTTransformer fft = provider1.getTransformer(fftsize, -1, true);
        FFTTransformer ffti = provider1.getTransformer(fftsize, -1, true);
        FFTTransformer fft2 = provider2.getTransformer(fftsize, -1, true);
        FFTTransformer ffti2 = provider2.getTransformer(fftsize, -1, true);
        double[] fftBuffer = new double[fftsize * 2];
        int i = 0;
        while (i < fftBuffer.length) {
            fftBuffer[i] = Math.random() * 2.0;
            ++i;
        }
        int k = 0;
        while (k < prelen) {
            fft2.transform(fftBuffer);
            ffti2.transform(fftBuffer);
            ++k;
        }
        long nanotime = System.nanoTime();
        int k2 = 0;
        while (k2 < testlen) {
            fft2.transform(fftBuffer);
            ffti2.transform(fftBuffer);
            ++k2;
        }
        long aa = System.nanoTime() - nanotime;
        int i2 = 0;
        while (i2 < fftBuffer.length) {
            fftBuffer[i2] = Math.random() * 2.0;
            ++i2;
        }
        int k3 = 0;
        while (k3 < prelen) {
            fft.transform(fftBuffer);
            ffti.transform(fftBuffer);
            ++k3;
        }
        nanotime = System.nanoTime();
        k3 = 0;
        while (k3 < testlen) {
            fft.transform(fftBuffer);
            ffti.transform(fftBuffer);
            ++k3;
        }
        long bb = System.nanoTime() - nanotime;
        int mflops1 = (int)(2.0 * ((double)(5 * fftsize) * Math.log(fftsize) / Math.log(2.0)) / ((double)aa / ((double)testlen * 1000.0)));
        int mflops2 = (int)(2.0 * ((double)(5 * fftsize) * Math.log(fftsize) / Math.log(2.0)) / ((double)bb / ((double)testlen * 1000.0)));
        System.out.print(("FFT:" + fftsize + "                   ").substring(0, 10));
        System.out.print(" | ");
        System.out.print((String.valueOf((double)aa / (double)bb) + "     ").substring(0, 5));
        System.out.println(" | " + mflops1 + " mflops v.s. " + mflops2 + " mflops.");
        Thread.yield();
    }

    public static void benchmark(FFTTransformer fft, FFTTransformer fft2, int fftsize) {
        int prelen = 20;
        int testlen = 50;
        if (fftsize < 512) {
            prelen = 200;
        }
        if (fftsize <= 128) {
            prelen = 10000;
        }
        if (fftsize < 4) {
            prelen = 20000;
        }
        if (fftsize < 8192) {
            prelen = 100;
        }
        if (fftsize < 4096) {
            prelen = 200;
        }
        if (fftsize < 2048) {
            prelen = 500;
        }
        if (fftsize < 64) {
            prelen = 2000;
        }
        if (fftsize >= 65536) {
            prelen = 15;
            testlen = 20;
        }
        double[] fftBuffer = new double[fftsize * 2];
        int i = 0;
        while (i < fftBuffer.length) {
            fftBuffer[i] = Math.random() * 2.0;
            ++i;
        }
        int k = 0;
        while (k < prelen) {
            fft2.transform(fftBuffer);
            ++k;
        }
        long nanotime = System.nanoTime();
        int k2 = 0;
        while (k2 < testlen) {
            fft2.transform(fftBuffer);
            ++k2;
        }
        long aa = System.nanoTime() - nanotime;
        int i2 = 0;
        while (i2 < fftBuffer.length) {
            fftBuffer[i2] = Math.random() * 2.0;
            ++i2;
        }
        int k3 = 0;
        while (k3 < prelen) {
            fft.transform(fftBuffer);
            ++k3;
        }
        nanotime = System.nanoTime();
        k3 = 0;
        while (k3 < testlen) {
            fft.transform(fftBuffer);
            ++k3;
        }
        long bb = System.nanoTime() - nanotime;
        int mflops1 = (int)((double)(5 * fftsize) * Math.log(fftsize) / Math.log(2.0) / ((double)aa / ((double)testlen * 1000.0)));
        int mflops2 = (int)((double)(5 * fftsize) * Math.log(fftsize) / Math.log(2.0) / ((double)bb / ((double)testlen * 1000.0)));
        System.out.print(("FFT:" + fftsize + "                   ").substring(0, 10));
        System.out.print(" | ");
        System.out.print((String.valueOf((double)aa / (double)bb) + "     ").substring(0, 5));
        System.out.println(" | " + mflops1 + " mflops v.s. " + mflops2 + " mflops.");
        Thread.yield();
    }

    public static void benchmark(FFTProvider provider1, FFTProvider provider2) {
        int fftsize = 1;
        int j = 2;
        while (j < 20) {
            Benchmark.benchmark(provider1, provider2, fftsize <<= 1);
            ++j;
        }
    }
}

