/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.fftw;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

public class FFTW {
    private long plan = 0L;
    private ByteBuffer invar = null;
    private ByteBuffer outvar = null;
    public static final int FFTW_FORWARD = -1;
    public static final int FFTW_BACKWARD = -1;
    public static final int FFTW_MEASURE = 0;
    public static final int FFTW_DESTROY_INPUT = 1;
    public static final int FFTW_UNALIGNED = 2;
    public static final int FFTW_CONSERVE_MEMORY = 4;
    public static final int FFTW_EXHAUSTIVE = 8;
    public static final int FFTW_PRESERVE_INPUT = 16;
    public static final int FFTW_PATIENT = 32;
    public static final int FFTW_ESTIMATE = 64;
    private static boolean fftw3_available = true;

    static {
        try {
            System.loadLibrary("jfftw3");
        }
        catch (Throwable t) {
            t.printStackTrace();
            fftw3_available = false;
        }
    }

    public FFTW(int n, int sign, int flags) {
        this.plan = this.createPlanDft1D(n, sign, flags);
    }

    public FFTW(int[] n, int sign, int flags) {
        this.plan = this.createPlanDft(n, sign, flags);
    }

    private native long createPlanDft1D(int var1, int var2, int var3);

    private native long createPlanDft(int[] var1, int var2, int var3);

    private native void destroyPlan(long var1);

    public DoubleBuffer getInput() {
        return this.invar.order(ByteOrder.nativeOrder()).asDoubleBuffer();
    }

    public DoubleBuffer getOutput() {
        return this.outvar.order(ByteOrder.nativeOrder()).asDoubleBuffer();
    }

    public void execute() {
        this.execute(this.plan);
    }

    private native void execute(long var1);

    protected void finalize() {
        if (this.plan != 0L) {
            this.destroyPlan(this.plan);
        }
        this.plan = 0L;
    }

    public static boolean isAvailable() {
        return fftw3_available;
    }
}

