/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.kissfft;

import rasmus.fft.kissfft.KissFft;

public class KissFftnd {
    private int ndims;
    private int dimprod;
    private int[] dims;
    private KissFft[] states;
    private double[] tmpbuf;

    public KissFftnd(int[] dims, boolean inverse_fft) {
        this.ndims = dims.length;
        int dimprod = 1;
        int i = 0;
        while (i < this.ndims) {
            dimprod *= dims[i];
            ++i;
        }
        this.dimprod = dimprod;
        this.dims = new int[this.ndims];
        this.states = new KissFft[this.ndims];
        this.tmpbuf = new double[dimprod << 1];
        i = 0;
        while (i < this.ndims) {
            this.dims[i] = dims[i];
            this.states[i] = new KissFft(this.dims[i], inverse_fft);
            ++i;
        }
    }

    public void transform(double[] fin, double[] fout) {
        double[] bufout;
        double[] bufin = fin;
        if (this.ndims % 2 == 1) {
            bufout = fout;
            if (fin == fout) {
                System.arraycopy(fin, 0, this.tmpbuf, 0, this.dimprod);
                bufin = this.tmpbuf;
            }
        } else {
            bufout = this.tmpbuf;
        }
        int k = 0;
        while (k < this.ndims) {
            int curdim = this.dims[k];
            int stride = this.dimprod / curdim;
            int i = 0;
            while (i < stride) {
                this.states[k].work(bufout, i * curdim, bufin, i, 1, stride, 0);
                ++i;
            }
            if (bufout == this.tmpbuf) {
                bufout = fout;
                bufin = this.tmpbuf;
            } else {
                bufout = this.tmpbuf;
                bufin = fout;
            }
            ++k;
        }
    }
}

