/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.providers;

import rasmus.fft.FFT;
import rasmus.fft.FFTTransformer;
import rasmus.fft.providers.ComplexSimple2Radix2Transformer;
import rasmus.fft.spi.FFTProvider;

public class ComplexSimple2Radix2
extends FFTProvider {
    private FFTProvider.Info info = new FFTProvider.Info(this, "ComplexSimple2Radix2", "RasmusDSP", "Simple Radix 2 Cooley-Tukey FFT, using precalculated sin/cos list", "", 0);

    public FFTProvider.Info getInfo() {
        return this.info;
    }

    public FFTTransformer getTransformer(int fftsize, int direction, boolean inplace) {
        if (!FFT.isRadix2(fftsize)) {
            return null;
        }
        if (direction == -1) {
            return new ComplexSimple2Radix2Transformer(fftsize, direction);
        }
        if (direction == 1) {
            return new ComplexSimple2Radix2Transformer(fftsize, direction);
        }
        return null;
    }
}

