/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.providers;

import rasmus.fft.FFTTransformer;

class ComplexSimple2Radix2Transformer
implements FFTTransformer {
    double[] fft_cos;
    double[] fft_sin;
    int[] bitm_array;
    int direction;
    int fftFrameSize;
    int fftFrameSize2;
    int imax;

    public ComplexSimple2Radix2Transformer(int fftFrameSize, int direction) {
        this.imax = (int)(Math.log(fftFrameSize) / Math.log(2.0));
        this.fft_cos = new double[this.imax];
        this.fft_sin = new double[this.imax];
        int k = 0;
        int le = 2;
        while (k < this.imax) {
            int le2 = (le <<= 1) >> 1;
            double arg = Math.PI / (double)(le2 >> 1);
            this.fft_cos[k] = Math.cos(arg);
            this.fft_sin[k] = Math.sin(arg);
            ++k;
        }
        this.fftFrameSize2 = fftFrameSize << 1;
        this.bitm_array = new int[this.fftFrameSize2];
        int i = 2;
        while (i < this.fftFrameSize2) {
            int bitm = 2;
            int j = 0;
            while (bitm < this.fftFrameSize2) {
                if ((i & bitm) != 0) {
                    ++j;
                }
                j <<= 1;
                bitm <<= 1;
            }
            this.bitm_array[i] = j;
            i += 2;
        }
        this.direction = direction;
        this.fftFrameSize = fftFrameSize;
    }

    public void transform(double[] data) {
        int sign = this.direction;
        int[] bitm_array = this.bitm_array;
        int i = 2;
        while (i < this.fftFrameSize2 - 2) {
            int j = bitm_array[i];
            if (i < j) {
                int n = i;
                int m = j;
                double tempr = data[n];
                data[n] = data[m];
                data[m] = tempr;
                double tempi = data[++n];
                data[n] = data[++m];
                data[m] = tempi;
            }
            i += 2;
        }
        int fftFrameSize2 = this.fftFrameSize2;
        double[] fft_cos = this.fft_cos;
        double[] fft_sin = this.fft_sin;
        int imax = this.imax;
        int i2 = 0;
        int nstep = 2;
        while (i2 < imax) {
            int jmax = nstep;
            nstep *= 2;
            double wr = 1.0;
            double wi = 0.0;
            double wfr = fft_cos[i2];
            double wfi = (double)sign * fft_sin[i2];
            int j = 0;
            while (j < jmax) {
                int n = j;
                while (n < fftFrameSize2) {
                    int m = n + jmax;
                    double tempr = data[m] * wr - data[m + 1] * wi;
                    double tempi = data[m] * wi + data[m + 1] * wr;
                    data[m] = data[n] - tempr;
                    data[m + 1] = data[n + 1] - tempi;
                    int n2 = n;
                    data[n2] = data[n2] + tempr;
                    int n3 = n + 1;
                    data[n3] = data[n3] + tempi;
                    n += nstep;
                }
                double tempr = wr;
                wr = tempr * wfr - wi * wfi;
                wi = tempr * wfi + wi * wfr;
                j += 2;
            }
            ++i2;
        }
    }

    public void transform(double[] in, double[] out) {
        System.arraycopy(in, 0, out, 0, in.length);
        this.transform(out);
    }
}

