/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.providers;

import java.util.Arrays;
import rasmus.fft.FFTTransformer;

class ComplexToComplexTransformer
implements FFTTransformer {
    private double[] aa = null;
    private int fftFrameSize;
    private int direction;

    public ComplexToComplexTransformer(int fftFrameSize, int direction) {
        this.fftFrameSize = fftFrameSize;
        this.direction = direction;
    }

    public void transform(double[] data) {
        if (this.aa == null) {
            this.aa = new double[this.fftFrameSize * 2];
        }
        this.transform(data, this.aa);
        int h = 0;
        while (h < this.fftFrameSize) {
            data[h] = this.aa[h];
            ++h;
        }
    }

    public void transform(double[] in, double[] out) {
        Arrays.fill(out, 0.0);
        int partials = this.fftFrameSize / 2;
        int hfs = this.fftFrameSize / 2;
        double pd = Math.PI / (double)hfs;
        int i = 0;
        while (i < this.fftFrameSize) {
            int im = i - hfs;
            double w = in[i * 2];
            int h = 0;
            int k = 0;
            while (h < partials) {
                double th = pd * (double)(h + 1) * (double)im;
                int n = k++;
                out[n] = out[n] + w * Math.cos(th);
                int n2 = k++;
                out[n2] = out[n2] + w * Math.sin(th) * (double)this.direction;
                ++h;
            }
            ++i;
        }
    }
}

