/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.providers;

import rasmus.fft.FFT;
import rasmus.fft.FFTTransformer;

class RealToComplexTransformer
implements FFTTransformer {
    FFTTransformer fft;
    int fftFrameSize;
    int fftFrameSize2;
    double[] realmag_sin = null;
    double[] realmag_cos = null;

    public RealToComplexTransformer(int fftFrameSize, boolean inplace) {
        this.fft = FFT.getTransformer(fftFrameSize >> 1, -1, inplace);
        this.fftFrameSize2 = fftFrameSize;
        this.fftFrameSize = fftFrameSize >> 1;
        this.realmag_sin = new double[this.fftFrameSize2];
        this.realmag_cos = new double[this.fftFrameSize2];
        int i = 2;
        while (i < this.fftFrameSize2) {
            double arg = Math.PI * (double)i / (double)this.fftFrameSize2;
            this.realmag_cos[i] = Math.cos(arg);
            this.realmag_sin[i] = Math.sin(arg);
            i += 2;
        }
    }

    public void transform(double[] data) {
        double[] realmag_sin = this.realmag_sin;
        double[] realmag_cos = this.realmag_cos;
        this.fft.transform(data);
        int i = 2;
        while (i <= this.fftFrameSize) {
            double c = realmag_cos[i];
            double s = realmag_sin[i];
            double xxr = data[i] * 0.5;
            double xxi = data[i + 1] * 0.5;
            double xxr_n = data[this.fftFrameSize2 - i] * 0.5;
            double xxi_n = data[this.fftFrameSize2 - i + 1] * 0.5;
            double tr = xxr - xxr_n;
            double ti = xxi + xxi_n;
            double cr = c * ti - s * tr;
            double ci = s * ti + c * tr;
            tr = xxr + xxr_n;
            ti = xxi - xxi_n;
            data[i] = tr + cr;
            data[i + 1] = ti - ci;
            data[this.fftFrameSize2 - i] = tr - cr;
            data[this.fftFrameSize2 - i + 1] = -ti - ci;
            i += 2;
        }
    }

    public void transform(double[] in, double[] data) {
        double[] realmag_sin = this.realmag_sin;
        double[] realmag_cos = this.realmag_cos;
        this.fft.transform(in, data);
        int i = 2;
        while (i <= this.fftFrameSize) {
            double c = realmag_cos[i];
            double s = realmag_sin[i];
            double xxr = data[i] * 0.5;
            double xxi = data[i + 1] * 0.5;
            double xxr_n = data[this.fftFrameSize2 - i] * 0.5;
            double xxi_n = data[this.fftFrameSize2 - i + 1] * 0.5;
            double tr = xxr - xxr_n;
            double ti = xxi + xxi_n;
            double cr = c * ti - s * tr;
            double ci = s * ti + c * tr;
            tr = xxr + xxr_n;
            ti = xxi - xxi_n;
            data[i] = tr + cr;
            data[i + 1] = ti - ci;
            data[this.fftFrameSize2 - i] = tr - cr;
            data[this.fftFrameSize2 - i + 1] = -ti - ci;
            i += 2;
        }
    }
}

