/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.radix2;

import rasmus.fft.radix2.OpFFT16;
import rasmus.fft.radix2.OpFFT2;
import rasmus.fft.radix2.OpFFT32;
import rasmus.fft.radix2.OpFFT32f4;
import rasmus.fft.radix2.OpFFT4;
import rasmus.fft.radix2.OpFFT8;
import rasmus.fft.radix2.OpFFTI16;
import rasmus.fft.radix2.OpFFTI2;
import rasmus.fft.radix2.OpFFTI32;
import rasmus.fft.radix2.OpFFTI32f4;
import rasmus.fft.radix2.OpFFTI4;
import rasmus.fft.radix2.OpFFTI8;

public final class OpFFT {
    public static final double[] computeTwiddleFactors(int fftFrameSize, int sign) {
        int imax = (int)(Math.log(fftFrameSize) / Math.log(2.0));
        double[] warray = new double[(fftFrameSize - 1) * 4];
        int w_index = 0;
        int i = 0;
        int nstep = 2;
        while (i < imax) {
            int jmax = nstep;
            nstep <<= 1;
            double wr = 1.0;
            double wi = 0.0;
            double arg = Math.PI / (double)(jmax >> 1);
            double wfr = Math.cos(arg);
            double wfi = (double)sign * Math.sin(arg);
            int j = 0;
            while (j < jmax) {
                warray[w_index++] = wr;
                warray[w_index++] = wi;
                double tempr = wr;
                wr = tempr * wfr - wi * wfi;
                wi = tempr * wfi + wi * wfr;
                j += 2;
            }
            ++i;
        }
        w_index = 0;
        int w_index2 = warray.length >> 1;
        int i2 = 0;
        int nstep2 = 2;
        while (i2 < imax - 1) {
            int jmax = nstep2;
            nstep2 *= 2;
            int ii = w_index + jmax;
            int j = 0;
            while (j < jmax) {
                double wr = warray[w_index++];
                double wi = warray[w_index++];
                double wr1 = warray[ii++];
                double wi1 = warray[ii++];
                warray[w_index2++] = wr * wr1 - wi * wi1;
                warray[w_index2++] = wr * wi1 + wi * wr1;
                j += 2;
            }
            ++i2;
        }
        return warray;
    }

    public static final void calc(int fftFrameSize, double[] data, int sign, double[] w) {
        int j;
        int fftFrameSize2 = fftFrameSize << 1;
        if (fftFrameSize < 64) {
            if (sign == -1) {
                switch (fftFrameSize) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        OpFFT2.calc(data, 0);
                        return;
                    }
                    case 4: {
                        OpFFT4.calc(data, 0);
                        return;
                    }
                    case 8: {
                        OpFFT8.calc(data, 0);
                        return;
                    }
                    case 16: {
                        OpFFT16.calc(data, 0);
                        return;
                    }
                    case 32: {
                        OpFFT32.calc(data, 0);
                        return;
                    }
                }
            }
            switch (fftFrameSize) {
                case 1: {
                    return;
                }
                case 2: {
                    OpFFTI2.calc(data, 0);
                    return;
                }
                case 4: {
                    OpFFTI4.calc(data, 0);
                    return;
                }
                case 8: {
                    OpFFTI8.calc(data, 0);
                    return;
                }
                case 16: {
                    OpFFTI16.calc(data, 0);
                    return;
                }
                case 32: {
                    OpFFTI32.calc(data, 0);
                    return;
                }
            }
        }
        if (sign == -1) {
            j = 0;
            while (j < fftFrameSize2) {
                OpFFT32f4.calc(data, j);
                j += 64;
            }
        } else {
            j = 0;
            while (j < fftFrameSize2) {
                OpFFTI32f4.calc(data, j);
                j += 64;
            }
        }
        int nstep = 64;
        if (nstep >= fftFrameSize2) {
            return;
        }
        int i = nstep - 2;
        if (sign == -1) {
            OpFFT.calcF4F(fftFrameSize, data, i, nstep, w);
        } else {
            OpFFT.calcF4I(fftFrameSize, data, i, nstep, w);
        }
    }

    public static final void calcF2(int fftFrameSize, double[] data, int i, int nstep, double[] w) {
        int fftFrameSize2 = fftFrameSize << 1;
        while (nstep < fftFrameSize2) {
            if (nstep << 1 == fftFrameSize2) {
                OpFFT.calcF2E(fftFrameSize, data, i, nstep, w);
                return;
            }
            int jmax = nstep;
            nstep <<= 1;
            int j = 0;
            while (j < jmax) {
                double wr = w[i++];
                double wi = w[i++];
                int n = j;
                while (n < fftFrameSize2) {
                    int m = n + jmax;
                    double datam_r = data[m];
                    double datam_i = data[m + 1];
                    double datan_r = data[n];
                    double datan_i = data[n + 1];
                    double tempr = datam_r * wr - datam_i * wi;
                    double tempi = datam_r * wi + datam_i * wr;
                    data[m] = datan_r - tempr;
                    data[m + 1] = datan_i - tempi;
                    data[n] = datan_r + tempr;
                    data[n + 1] = datan_i + tempi;
                    n += nstep;
                }
                j += 2;
            }
        }
    }

    public static final void calcF2E(int fftFrameSize, double[] data, int i, int nstep, double[] w) {
        int jmax = nstep;
        nstep <<= 1;
        int n = 0;
        while (n < jmax) {
            double wr = w[i++];
            double wi = w[i++];
            int m = n + jmax;
            double datam_r = data[m];
            double datam_i = data[m + 1];
            double datan_r = data[n];
            double datan_i = data[n + 1];
            double tempr = datam_r * wr - datam_i * wi;
            double tempi = datam_r * wi + datam_i * wr;
            data[m] = datan_r - tempr;
            data[m + 1] = datan_i - tempi;
            data[n] = datan_r + tempr;
            data[n + 1] = datan_i + tempi;
            n += 2;
        }
    }

    public static final void calcF4F(int fftFrameSize, double[] data, int i, int nstep, double[] w) {
        int fftFrameSize2 = fftFrameSize << 1;
        int w_len = w.length >> 1;
        while (nstep < fftFrameSize2) {
            if (nstep << 2 == fftFrameSize2) {
                OpFFT.calcF4FE(fftFrameSize, data, i, nstep, w);
                return;
            }
            int jmax = nstep;
            int nnstep = nstep << 1;
            if (nnstep == fftFrameSize2) {
                OpFFT.calcF2E(fftFrameSize, data, i, nstep, w);
                return;
            }
            nstep <<= 2;
            int ii = i + jmax;
            int iii = i + w_len;
            i += 2;
            ii += 2;
            iii += 2;
            int n = 0;
            while (n < fftFrameSize2) {
                int m = n + jmax;
                double datam1_r = data[m];
                double datam1_i = data[m + 1];
                double datan1_r = data[n];
                double datan1_i = data[n + 1];
                double datam2_r = data[m += nnstep];
                double datam2_i = data[m + 1];
                double datan2_r = data[n += nnstep];
                double datan2_i = data[n + 1];
                double tempr = datam1_r;
                double tempi = datam1_i;
                datam1_r = datan1_r - tempr;
                datam1_i = datan1_i - tempi;
                datan1_r += tempr;
                datan1_i += tempi;
                double n2w1r = datan2_r;
                double n2w1i = datan2_i;
                double m2ww1r = datam2_r;
                double m2ww1i = datam2_i;
                tempr = m2ww1r - n2w1r;
                tempi = m2ww1i - n2w1i;
                datam2_r = datam1_r + tempi;
                datam2_i = datam1_i - tempr;
                datam1_r -= tempi;
                datam1_i += tempr;
                tempr = n2w1r + m2ww1r;
                tempi = n2w1i + m2ww1i;
                datan2_r = datan1_r - tempr;
                datan2_i = datan1_i - tempi;
                datan1_r += tempr;
                datan1_i += tempi;
                data[m] = datam2_r;
                data[m + 1] = datam2_i;
                data[n] = datan2_r;
                data[n + 1] = datan2_i;
                data[m -= nnstep] = datam1_r;
                data[m + 1] = datam1_i;
                data[n -= nnstep] = datan1_r;
                data[n + 1] = datan1_i;
                n += nstep;
            }
            int j = 2;
            while (j < jmax) {
                double wr = w[i++];
                double wi = w[i++];
                double wr1 = w[ii++];
                double wi1 = w[ii++];
                double wwr1 = w[iii++];
                double wwi1 = w[iii++];
                int n2 = j;
                while (n2 < fftFrameSize2) {
                    int m = n2 + jmax;
                    double datam1_r = data[m];
                    double datam1_i = data[m + 1];
                    double datan1_r = data[n2];
                    double datan1_i = data[n2 + 1];
                    double datam2_r = data[m += nnstep];
                    double datam2_i = data[m + 1];
                    double datan2_r = data[n2 += nnstep];
                    double datan2_i = data[n2 + 1];
                    double tempr = datam1_r * wr - datam1_i * wi;
                    double tempi = datam1_r * wi + datam1_i * wr;
                    datam1_r = datan1_r - tempr;
                    datam1_i = datan1_i - tempi;
                    datan1_r += tempr;
                    datan1_i += tempi;
                    double n2w1r = datan2_r * wr1 - datan2_i * wi1;
                    double n2w1i = datan2_r * wi1 + datan2_i * wr1;
                    double m2ww1r = datam2_r * wwr1 - datam2_i * wwi1;
                    double m2ww1i = datam2_r * wwi1 + datam2_i * wwr1;
                    tempr = m2ww1r - n2w1r;
                    tempi = m2ww1i - n2w1i;
                    datam2_r = datam1_r + tempi;
                    datam2_i = datam1_i - tempr;
                    datam1_r -= tempi;
                    datam1_i += tempr;
                    tempr = n2w1r + m2ww1r;
                    tempi = n2w1i + m2ww1i;
                    datan2_r = datan1_r - tempr;
                    datan2_i = datan1_i - tempi;
                    datan1_r += tempr;
                    datan1_i += tempi;
                    data[m] = datam2_r;
                    data[m + 1] = datam2_i;
                    data[n2] = datan2_r;
                    data[n2 + 1] = datan2_i;
                    data[m -= nnstep] = datam1_r;
                    data[m + 1] = datam1_i;
                    data[n2 -= nnstep] = datan1_r;
                    data[n2 + 1] = datan1_i;
                    n2 += nstep;
                }
                j += 2;
            }
            i += jmax << 1;
        }
        OpFFT.calcF2E(fftFrameSize, data, i, nstep, w);
    }

    public static final void calcF4I(int fftFrameSize, double[] data, int i, int nstep, double[] w) {
        int fftFrameSize2 = fftFrameSize << 1;
        int w_len = w.length >> 1;
        while (nstep < fftFrameSize2) {
            if (nstep << 2 == fftFrameSize2) {
                OpFFT.calcF4IE(fftFrameSize, data, i, nstep, w);
                return;
            }
            int jmax = nstep;
            int nnstep = nstep << 1;
            if (nnstep == fftFrameSize2) {
                OpFFT.calcF2E(fftFrameSize, data, i, nstep, w);
                return;
            }
            nstep <<= 2;
            int ii = i + jmax;
            int iii = i + w_len;
            i += 2;
            ii += 2;
            iii += 2;
            int n = 0;
            while (n < fftFrameSize2) {
                int m = n + jmax;
                double datam1_r = data[m];
                double datam1_i = data[m + 1];
                double datan1_r = data[n];
                double datan1_i = data[n + 1];
                double datam2_r = data[m += nnstep];
                double datam2_i = data[m + 1];
                double datan2_r = data[n += nnstep];
                double datan2_i = data[n + 1];
                double tempr = datam1_r;
                double tempi = datam1_i;
                datam1_r = datan1_r - tempr;
                datam1_i = datan1_i - tempi;
                datan1_r += tempr;
                datan1_i += tempi;
                double n2w1r = datan2_r;
                double n2w1i = datan2_i;
                double m2ww1r = datam2_r;
                double m2ww1i = datam2_i;
                tempr = n2w1r - m2ww1r;
                tempi = n2w1i - m2ww1i;
                datam2_r = datam1_r + tempi;
                datam2_i = datam1_i - tempr;
                datam1_r -= tempi;
                datam1_i += tempr;
                tempr = n2w1r + m2ww1r;
                tempi = n2w1i + m2ww1i;
                datan2_r = datan1_r - tempr;
                datan2_i = datan1_i - tempi;
                datan1_r += tempr;
                datan1_i += tempi;
                data[m] = datam2_r;
                data[m + 1] = datam2_i;
                data[n] = datan2_r;
                data[n + 1] = datan2_i;
                data[m -= nnstep] = datam1_r;
                data[m + 1] = datam1_i;
                data[n -= nnstep] = datan1_r;
                data[n + 1] = datan1_i;
                n += nstep;
            }
            int j = 2;
            while (j < jmax) {
                double wr = w[i++];
                double wi = w[i++];
                double wr1 = w[ii++];
                double wi1 = w[ii++];
                double wwr1 = w[iii++];
                double wwi1 = w[iii++];
                int n2 = j;
                while (n2 < fftFrameSize2) {
                    int m = n2 + jmax;
                    double datam1_r = data[m];
                    double datam1_i = data[m + 1];
                    double datan1_r = data[n2];
                    double datan1_i = data[n2 + 1];
                    double datam2_r = data[m += nnstep];
                    double datam2_i = data[m + 1];
                    double datan2_r = data[n2 += nnstep];
                    double datan2_i = data[n2 + 1];
                    double tempr = datam1_r * wr - datam1_i * wi;
                    double tempi = datam1_r * wi + datam1_i * wr;
                    datam1_r = datan1_r - tempr;
                    datam1_i = datan1_i - tempi;
                    datan1_r += tempr;
                    datan1_i += tempi;
                    double n2w1r = datan2_r * wr1 - datan2_i * wi1;
                    double n2w1i = datan2_r * wi1 + datan2_i * wr1;
                    double m2ww1r = datam2_r * wwr1 - datam2_i * wwi1;
                    double m2ww1i = datam2_r * wwi1 + datam2_i * wwr1;
                    tempr = n2w1r - m2ww1r;
                    tempi = n2w1i - m2ww1i;
                    datam2_r = datam1_r + tempi;
                    datam2_i = datam1_i - tempr;
                    datam1_r -= tempi;
                    datam1_i += tempr;
                    tempr = n2w1r + m2ww1r;
                    tempi = n2w1i + m2ww1i;
                    datan2_r = datan1_r - tempr;
                    datan2_i = datan1_i - tempi;
                    datan1_r += tempr;
                    datan1_i += tempi;
                    data[m] = datam2_r;
                    data[m + 1] = datam2_i;
                    data[n2] = datan2_r;
                    data[n2 + 1] = datan2_i;
                    data[m -= nnstep] = datam1_r;
                    data[m + 1] = datam1_i;
                    data[n2 -= nnstep] = datan1_r;
                    data[n2 + 1] = datan1_i;
                    n2 += nstep;
                }
                j += 2;
            }
            i += jmax << 1;
        }
        OpFFT.calcF2E(fftFrameSize, data, i, nstep, w);
    }

    public static final void calcF4FE(int fftFrameSize, double[] data, int i, int nstep, double[] w) {
        int fftFrameSize2 = fftFrameSize << 1;
        int w_len = w.length >> 1;
        while (nstep < fftFrameSize2) {
            int jmax = nstep;
            int nnstep = nstep << 1;
            if (nnstep == fftFrameSize2) {
                OpFFT.calcF2E(fftFrameSize, data, i, nstep, w);
                return;
            }
            nstep <<= 2;
            int ii = i + jmax;
            int iii = i + w_len;
            int n = 0;
            while (n < jmax) {
                double wr = w[i++];
                double wi = w[i++];
                double wr1 = w[ii++];
                double wi1 = w[ii++];
                double wwr1 = w[iii++];
                double wwi1 = w[iii++];
                int m = n + jmax;
                double datam1_r = data[m];
                double datam1_i = data[m + 1];
                double datan1_r = data[n];
                double datan1_i = data[n + 1];
                double datam2_r = data[m += nnstep];
                double datam2_i = data[m + 1];
                double datan2_r = data[n += nnstep];
                double datan2_i = data[n + 1];
                double tempr = datam1_r * wr - datam1_i * wi;
                double tempi = datam1_r * wi + datam1_i * wr;
                datam1_r = datan1_r - tempr;
                datam1_i = datan1_i - tempi;
                datan1_r += tempr;
                datan1_i += tempi;
                double n2w1r = datan2_r * wr1 - datan2_i * wi1;
                double n2w1i = datan2_r * wi1 + datan2_i * wr1;
                double m2ww1r = datam2_r * wwr1 - datam2_i * wwi1;
                double m2ww1i = datam2_r * wwi1 + datam2_i * wwr1;
                tempr = m2ww1r - n2w1r;
                tempi = m2ww1i - n2w1i;
                datam2_r = datam1_r + tempi;
                datam2_i = datam1_i - tempr;
                datam1_r -= tempi;
                datam1_i += tempr;
                tempr = n2w1r + m2ww1r;
                tempi = n2w1i + m2ww1i;
                datan2_r = datan1_r - tempr;
                datan2_i = datan1_i - tempi;
                datan1_r += tempr;
                datan1_i += tempi;
                data[m] = datam2_r;
                data[m + 1] = datam2_i;
                data[n] = datan2_r;
                data[n + 1] = datan2_i;
                data[m -= nnstep] = datam1_r;
                data[m + 1] = datam1_i;
                data[n -= nnstep] = datan1_r;
                data[n + 1] = datan1_i;
                n += 2;
            }
            i += jmax << 1;
        }
    }

    public static final void calcF4IE(int fftFrameSize, double[] data, int i, int nstep, double[] w) {
        int fftFrameSize2 = fftFrameSize << 1;
        int w_len = w.length >> 1;
        while (nstep < fftFrameSize2) {
            int jmax = nstep;
            int nnstep = nstep << 1;
            if (nnstep == fftFrameSize2) {
                OpFFT.calcF2E(fftFrameSize, data, i, nstep, w);
                return;
            }
            nstep <<= 2;
            int ii = i + jmax;
            int iii = i + w_len;
            int n = 0;
            while (n < jmax) {
                double wr = w[i++];
                double wi = w[i++];
                double wr1 = w[ii++];
                double wi1 = w[ii++];
                double wwr1 = w[iii++];
                double wwi1 = w[iii++];
                int m = n + jmax;
                double datam1_r = data[m];
                double datam1_i = data[m + 1];
                double datan1_r = data[n];
                double datan1_i = data[n + 1];
                double datam2_r = data[m += nnstep];
                double datam2_i = data[m + 1];
                double datan2_r = data[n += nnstep];
                double datan2_i = data[n + 1];
                double tempr = datam1_r * wr - datam1_i * wi;
                double tempi = datam1_r * wi + datam1_i * wr;
                datam1_r = datan1_r - tempr;
                datam1_i = datan1_i - tempi;
                datan1_r += tempr;
                datan1_i += tempi;
                double n2w1r = datan2_r * wr1 - datan2_i * wi1;
                double n2w1i = datan2_r * wi1 + datan2_i * wr1;
                double m2ww1r = datam2_r * wwr1 - datam2_i * wwi1;
                double m2ww1i = datam2_r * wwi1 + datam2_i * wwr1;
                tempr = n2w1r - m2ww1r;
                tempi = n2w1i - m2ww1i;
                datam2_r = datam1_r + tempi;
                datam2_i = datam1_i - tempr;
                datam1_r -= tempi;
                datam1_i += tempr;
                tempr = n2w1r + m2ww1r;
                tempi = n2w1i + m2ww1i;
                datan2_r = datan1_r - tempr;
                datan2_i = datan1_i - tempi;
                datan1_r += tempr;
                datan1_i += tempi;
                data[m] = datam2_r;
                data[m + 1] = datam2_i;
                data[n] = datan2_r;
                data[n + 1] = datan2_i;
                data[m -= nnstep] = datam1_r;
                data[m + 1] = datam1_i;
                data[n -= nnstep] = datan1_r;
                data[n + 1] = datan1_i;
                n += 2;
            }
            i += jmax << 1;
        }
    }

    public static final void calcF4(int fftFrameSize, double[] data, int i, int nstep, int sign, double[] w) {
        int fftFrameSize2 = fftFrameSize << 1;
        while (nstep < fftFrameSize2) {
            if (nstep << 2 == fftFrameSize2) {
                OpFFT.calcF4E(fftFrameSize, data, i, nstep, sign, w);
                return;
            }
            int jmax = nstep;
            int nnstep = nstep << 1;
            if (nnstep == fftFrameSize2) break;
            nstep <<= 2;
            int ii = i + jmax;
            int j = 0;
            while (j < jmax) {
                double wr = w[i++];
                double wi = w[i++];
                double wr1 = w[ii++];
                double wi1 = w[ii++];
                double wr2 = -wi1 * (double)sign;
                double wi2 = wr1 * (double)sign;
                int n = j;
                while (n < fftFrameSize2) {
                    int m = n + jmax;
                    double datam1_r = data[m];
                    double datam1_i = data[m + 1];
                    double datan1_r = data[n];
                    double datan1_i = data[n + 1];
                    double datam2_r = data[m += nnstep];
                    double datam2_i = data[m + 1];
                    double datan2_r = data[n += nnstep];
                    double datan2_i = data[n + 1];
                    double tempr = datam1_r * wr - datam1_i * wi;
                    double tempi = datam1_r * wi + datam1_i * wr;
                    datam1_r = datan1_r - tempr;
                    datam1_i = datan1_i - tempi;
                    datan1_r += tempr;
                    datan1_i += tempi;
                    tempr = datam2_r * wr - datam2_i * wi;
                    tempi = datam2_r * wi + datam2_i * wr;
                    datam2_r = datan2_r - tempr;
                    datam2_i = datan2_i - tempi;
                    datan2_r += tempr;
                    tempr = datan2_r * wr1 - (datan2_i += tempi) * wi1;
                    tempi = datan2_r * wi1 + datan2_i * wr1;
                    datan2_r = datan1_r - tempr;
                    datan2_i = datan1_i - tempi;
                    datan1_r += tempr;
                    datan1_i += tempi;
                    tempr = datam2_r * wr2 - datam2_i * wi2;
                    tempi = datam2_r * wi2 + datam2_i * wr2;
                    datam2_r = datam1_r - tempr;
                    datam2_i = datam1_i - tempi;
                    datam1_r += tempr;
                    datam1_i += tempi;
                    data[m] = datam2_r;
                    data[m + 1] = datam2_i;
                    data[n] = datan2_r;
                    data[n + 1] = datan2_i;
                    data[m -= nnstep] = datam1_r;
                    data[m + 1] = datam1_i;
                    data[n -= nnstep] = datan1_r;
                    data[n + 1] = datan1_i;
                    n += nstep;
                }
                j += 2;
            }
            i += jmax << 1;
        }
        OpFFT.calcF2E(fftFrameSize, data, i, nstep, w);
    }

    public static final void calcF4E(int fftFrameSize, double[] data, int i, int nstep, int sign, double[] w) {
        int jmax = nstep;
        int nnstep = nstep << 1;
        nstep <<= 2;
        int ii = i + jmax;
        int n = 0;
        while (n < jmax) {
            double wr = w[i++];
            double wi = w[i++];
            double wr1 = w[ii++];
            double wi1 = w[ii++];
            double wr2 = -wi1 * (double)sign;
            double wi2 = wr1 * (double)sign;
            int m = n + jmax;
            double datam1_r = data[m];
            double datam1_i = data[m + 1];
            double datan1_r = data[n];
            double datan1_i = data[n + 1];
            double datam2_r = data[m += nnstep];
            double datam2_i = data[m + 1];
            double datan2_r = data[n += nnstep];
            double datan2_i = data[n + 1];
            double tempr = datam1_r * wr - datam1_i * wi;
            double tempi = datam1_r * wi + datam1_i * wr;
            datam1_r = datan1_r - tempr;
            datam1_i = datan1_i - tempi;
            datan1_r += tempr;
            datan1_i += tempi;
            tempr = datam2_r * wr - datam2_i * wi;
            tempi = datam2_r * wi + datam2_i * wr;
            datam2_r = datan2_r - tempr;
            datam2_i = datan2_i - tempi;
            datan2_r += tempr;
            tempr = datan2_r * wr1 - (datan2_i += tempi) * wi1;
            tempi = datan2_r * wi1 + datan2_i * wr1;
            datan2_r = datan1_r - tempr;
            datan2_i = datan1_i - tempi;
            datan1_r += tempr;
            datan1_i += tempi;
            tempr = datam2_r * wr2 - datam2_i * wi2;
            tempi = datam2_r * wi2 + datam2_i * wr2;
            datam2_r = datam1_r - tempr;
            datam2_i = datam1_i - tempi;
            datam1_r += tempr;
            datam1_i += tempi;
            data[m] = datam2_r;
            data[m + 1] = datam2_i;
            data[n] = datan2_r;
            data[n + 1] = datan2_i;
            data[m -= nnstep] = datam1_r;
            data[m + 1] = datam1_i;
            data[n -= nnstep] = datan1_r;
            data[n + 1] = datan1_i;
            n += 2;
        }
        i += jmax << 1;
    }
}

