/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.radix2;

import rasmus.fft.radix2.OpFFT;

public class OpGenerator {
    public static final String generateFactor2(int fftFrameSize, int sign) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("package rasmus.fft.radix2; \r\n");
        if (sign == 1) {
            sbuffer.append("class OpFFTI" + fftFrameSize + " { \r\n");
        } else {
            sbuffer.append("class OpFFT" + fftFrameSize + " { \r\n");
        }
        sbuffer.append("public static void calc(double[] d, int offset) { \r\n");
        int i = 0;
        while (i < 2 * fftFrameSize) {
            sbuffer.append("double d" + i + "=d[" + i + "+offset];\r\n");
            ++i;
        }
        sbuffer.append("double tr;\r\n");
        sbuffer.append("double ti;\r\n");
        int fftFrameSize2 = 2 * fftFrameSize;
        int imax = (int)(Math.log(fftFrameSize) / Math.log(2.0));
        double[] fft_cos = new double[imax];
        double[] fft_sin = new double[imax];
        int k = 0;
        int le = 2;
        while (k < imax) {
            int le2 = (le <<= 1) >> 1;
            double arg = Math.PI / (double)(le2 >> 1);
            fft_cos[k] = Math.cos(arg);
            fft_sin[k] = Math.sin(arg);
            ++k;
        }
        int i2 = 0;
        int nstep = 2;
        while (i2 < imax) {
            int jmax = nstep;
            nstep *= 2;
            double wr = 1.0;
            double wi = 0.0;
            double wfr = fft_cos[i2];
            double wfi = (double)sign * fft_sin[i2];
            int j = 0;
            while (j < jmax) {
                sbuffer.append("/* i = " + i2 + ", j = " + j + " ----------------------------------------- */ \r\n");
                int n = j;
                while (n < fftFrameSize2) {
                    int m = n + jmax;
                    if (Math.abs(wr - 1.0) < 1.0E-6 && Math.abs(wi) < 1.0E-6) {
                        sbuffer.append("tr=d" + m + ";\r\n");
                        sbuffer.append("ti=d" + (m + 1) + ";\r\n");
                    } else if (Math.abs(wr) < 1.0E-6 && Math.abs(wi - 1.0) < 1.0E-6) {
                        sbuffer.append("tr=-d" + (m + 1) + ";\r\n");
                        sbuffer.append("ti=d" + m + ";\r\n");
                    } else if (Math.abs(wr) < 1.0E-6 && Math.abs(wi + 1.0) < 1.0E-6) {
                        sbuffer.append("tr=d" + (m + 1) + ";\r\n");
                        sbuffer.append("ti=-d" + m + ";\r\n");
                    } else if (Math.abs(wi - 1.0) < 1.0E-6) {
                        sbuffer.append("tr=d" + m + "*(" + wr + ")-d" + (m + 1) + ";\r\n");
                        sbuffer.append("ti=d" + m + "+d" + (m + 1) + "*(" + wr + ");\r\n");
                    } else if (Math.abs(wi + 1.0) < 1.0E-6) {
                        sbuffer.append("tr=d" + m + "*(" + wr + ")+d" + (m + 1) + ";\r\n");
                        sbuffer.append("ti=d" + (m + 1) + "*(" + wr + ")-d" + m + ";\r\n");
                    } else if (Math.abs(wi - wr) < 1.0E-6) {
                        sbuffer.append("tr=(d" + m + "-d" + (m + 1) + ")*(" + wr + ");\r\n");
                        sbuffer.append("ti=(d" + m + "+d" + (m + 1) + ")*(" + wr + ");\r\n");
                    } else if (Math.abs(wi + wr) < 1.0E-6) {
                        sbuffer.append("tr=(d" + m + "+d" + (m + 1) + ")*(" + wr + ");\r\n");
                        sbuffer.append("ti=(d" + (m + 1) + "-d" + m + ")*(" + wr + ");\r\n");
                    } else {
                        sbuffer.append("tr=d" + m + "*(" + wr + ")-d" + (m + 1) + "*(" + wi + ");\r\n");
                        sbuffer.append("ti=d" + m + "*(" + wi + ")+d" + (m + 1) + "*(" + wr + ");\r\n");
                    }
                    sbuffer.append("d" + m + "=d" + n + "-tr;\r\n");
                    sbuffer.append("d" + (m + 1) + "=d" + (n + 1) + "-ti;\r\n");
                    sbuffer.append("d" + n + "+=tr;\r\n");
                    sbuffer.append("d" + (n + 1) + "+=ti;\r\n");
                    n += nstep;
                }
                double tempr = wr;
                wr = tempr * wfr - wi * wfi;
                wi = tempr * wfi + wi * wfr;
                j += 2;
            }
            ++i2;
        }
        int n = 0;
        while (n < fftFrameSize2) {
            sbuffer.append("d[" + n + "+offset]=d" + n + ";\r\n");
            ++n;
        }
        sbuffer.append("}\r\n");
        sbuffer.append("}\r\n");
        return sbuffer.toString();
    }

    public static final String generateFactor4(int fftFrameSize, int sign) {
        int jmax;
        double[] w = OpFFT.computeTwiddleFactors(fftFrameSize, sign);
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("package rasmus.fft.radix2; \r\n");
        if (sign == 1) {
            sbuffer.append("class OpFFTI" + fftFrameSize + "f4 { \r\n");
        } else {
            sbuffer.append("class OpFFT" + fftFrameSize + "f4 { \r\n");
        }
        sbuffer.append("public static void calc(double[] d, int offset) { \r\n");
        int i = 0;
        while (i < 2 * fftFrameSize) {
            sbuffer.append("double d" + i + "=d[" + i + "+offset];\r\n");
            ++i;
        }
        sbuffer.append("double tr;\r\n");
        sbuffer.append("double ti;\r\n");
        sbuffer.append("double n2w1r;\r\n");
        sbuffer.append("double n2w1i;\r\n");
        sbuffer.append("double m2ww1r;\r\n");
        sbuffer.append("double m2ww1i;\r\n");
        int fftFrameSize2 = 2 * fftFrameSize;
        int nstep = 2;
        int i2 = 0;
        int ss = 0;
        while (nstep < fftFrameSize2) {
            jmax = nstep;
            int nnstep = nstep << 1;
            if (nnstep == fftFrameSize2) break;
            nstep <<= 2;
            int ii = i2 + jmax;
            int j = 0;
            while (j < jmax) {
                sbuffer.append("/* i = " + ss + ", j = " + j + " ----------------------------------------- */ \r\n");
                double wr = w[i2++];
                double wi = w[i2++];
                double wr1 = w[ii++];
                double wi1 = w[ii++];
                double wwr1 = wr * wr1 - wi * wi1;
                double wwi1 = wr * wi1 + wi * wr1;
                int n = j;
                while (n < fftFrameSize2) {
                    int m = n + jmax;
                    String datam1_r = "d" + m;
                    String datam1_i = "d" + (m + 1);
                    String datan1_r = "d" + n;
                    String datan1_i = "d" + (n + 1);
                    String datam2_r = "d" + (m += nnstep);
                    String datam2_i = "d" + (m + 1);
                    String datan2_r = "d" + (n += nnstep);
                    String datan2_i = "d" + (n + 1);
                    if (Math.abs(wr - 1.0) < 1.0E-7 && Math.abs(wi - 0.0) < 1.0E-7) {
                        sbuffer.append("tr=" + datam1_r + ";\r\n");
                        sbuffer.append("ti=" + datam1_i + ";\r\n");
                    } else if (Math.abs(wr - 0.0) < 1.0E-7 && Math.abs(wi + 1.0) < 1.0E-7) {
                        sbuffer.append("tr=" + datam1_i + ";\r\n");
                        sbuffer.append("ti=-" + datam1_r + ";\r\n");
                    } else if (Math.abs(wr - wi) < 1.0E-7) {
                        sbuffer.append("tr=(" + datam1_r + "-" + datam1_i + ")*(" + wi + ");\r\n");
                        sbuffer.append("ti=(" + datam1_r + "+" + datam1_i + ")*(" + wr + ");\r\n");
                    } else if (Math.abs(wr + wi) < 1.0E-7) {
                        sbuffer.append("tr=(" + datam1_r + "+" + datam1_i + ")*(" + wr + ");\r\n");
                        sbuffer.append("ti=(" + datam1_r + "-" + datam1_i + ")*(" + wi + ");\r\n");
                    } else {
                        sbuffer.append("tr=" + datam1_r + "*(" + wr + ")-" + datam1_i + "*(" + wi + ");\r\n");
                        sbuffer.append("ti=" + datam1_r + "*(" + wi + ")+" + datam1_i + "*(" + wr + ");\r\n");
                    }
                    sbuffer.append(String.valueOf(datam1_r) + "=" + datan1_r + "-tr;\r\n");
                    sbuffer.append(String.valueOf(datam1_i) + "=" + datan1_i + "-ti;\r\n");
                    sbuffer.append(String.valueOf(datan1_r) + "=" + datan1_r + "+tr;\r\n");
                    sbuffer.append(String.valueOf(datan1_i) + "=" + datan1_i + "+ti;\r\n");
                    if (Math.abs(wr1 - 1.0) < 1.0E-7 && Math.abs(wi1 - 0.0) < 1.0E-7) {
                        sbuffer.append("n2w1r=" + datan2_r + ";\r\n");
                        sbuffer.append("n2w1i=" + datan2_i + ";\r\n");
                    } else if (Math.abs(wr1 - wi1) < 1.0E-7) {
                        sbuffer.append("n2w1r=(" + datan2_r + "-" + datan2_i + ")*(" + wi1 + ");\r\n");
                        sbuffer.append("n2w1i=(" + datan2_r + "+" + datan2_i + ")*(" + wr1 + ");\r\n");
                    } else if (Math.abs(wr1 + wi1) < 1.0E-7) {
                        sbuffer.append("n2w1r=(" + datan2_r + "+" + datan2_i + ")*(" + wr1 + ");\r\n");
                        sbuffer.append("n2w1i=(" + datan2_r + "-" + datan2_i + ")*(" + wi1 + ");\r\n");
                    } else {
                        sbuffer.append("n2w1r=" + datan2_r + "*(" + wr1 + ")-" + datan2_i + "*(" + wi1 + ");\r\n");
                        sbuffer.append("n2w1i=" + datan2_r + "*(" + wi1 + ")+" + datan2_i + "*(" + wr1 + ");\r\n");
                    }
                    if (Math.abs(wwr1 - 1.0) < 1.0E-7 && Math.abs(wwi1 - 0.0) < 1.0E-7) {
                        sbuffer.append("m2ww1r=" + datam2_r + ";\r\n");
                        sbuffer.append("m2ww1i=" + datam2_i + ";\r\n");
                    } else if (Math.abs(wwr1 - wwi1) < 1.0E-7) {
                        sbuffer.append("m2ww1r=(" + datam2_r + "-" + datam2_i + ")*(" + wwi1 + ");\r\n");
                        sbuffer.append("m2ww1i=(" + datam2_r + "+" + datam2_i + ")*(" + wwr1 + ");\r\n");
                    } else if (Math.abs(wwr1 + wwi1) < 1.0E-7) {
                        sbuffer.append("m2ww1r=(" + datam2_r + "+" + datam2_i + ")*(" + wwr1 + ");\r\n");
                        sbuffer.append("m2ww1i=(" + datam2_r + "-" + datam2_i + ")*(" + wwi1 + ");\r\n");
                    } else {
                        sbuffer.append("m2ww1r=" + datam2_r + "*(" + wwr1 + ")-" + datam2_i + "*(" + wwi1 + ");\r\n");
                        sbuffer.append("m2ww1i=" + datam2_r + "*(" + wwi1 + ")+" + datam2_i + "*(" + wwr1 + ");\r\n");
                    }
                    if (sign == -1) {
                        sbuffer.append("tr=m2ww1r-n2w1r;\r\n");
                        sbuffer.append("ti=m2ww1i-n2w1i;\r\n");
                    } else {
                        sbuffer.append("tr=n2w1r-m2ww1r;\r\n");
                        sbuffer.append("ti=n2w1i-m2ww1i;\r\n");
                    }
                    sbuffer.append(String.valueOf(datam2_r) + "=" + datam1_r + "+ti;\r\n");
                    sbuffer.append(String.valueOf(datam2_i) + "=" + datam1_i + "-tr;\r\n");
                    sbuffer.append(String.valueOf(datam1_r) + "=" + datam1_r + "-ti;\r\n");
                    sbuffer.append(String.valueOf(datam1_i) + "=" + datam1_i + "+tr;\r\n");
                    sbuffer.append("tr=n2w1r+m2ww1r;\r\n");
                    sbuffer.append("ti=n2w1i+m2ww1i;\r\n");
                    sbuffer.append(String.valueOf(datan2_r) + "=" + datan1_r + "-tr;\r\n");
                    sbuffer.append(String.valueOf(datan2_i) + "=" + datan1_i + "-ti;\r\n");
                    sbuffer.append(String.valueOf(datan1_r) + "=" + datan1_r + "+tr;\r\n");
                    sbuffer.append(String.valueOf(datan1_i) + "=" + datan1_i + "+ti;\r\n");
                    n -= nnstep;
                    m -= nnstep;
                    n += nstep;
                }
                j += 2;
            }
            i2 += jmax << 1;
            ++ss;
        }
        if (nstep << 1 == fftFrameSize2) {
            jmax = nstep;
            nstep <<= 1;
            int n = 0;
            while (n < jmax) {
                double wr = w[i2++];
                double wi = w[i2++];
                int m = n + jmax;
                String datam_r = "d" + m;
                String datam_i = "d" + (m + 1);
                String datan_r = "d" + n;
                String datan_i = "d" + (n + 1);
                if (Math.abs(wr - 1.0) < 1.0E-7 && Math.abs(wi - 0.0) < 1.0E-7) {
                    sbuffer.append("tr=" + datam_r + ";\r\n");
                    sbuffer.append("ti=" + datam_i + ";\r\n");
                } else if (Math.abs(wr - 0.0) < 1.0E-7 && Math.abs(wi + 1.0) < 1.0E-7) {
                    sbuffer.append("tr=" + datam_i + ";\r\n");
                    sbuffer.append("ti=-" + datam_r + ";\r\n");
                } else if (Math.abs(wr - wi) < 1.0E-7) {
                    sbuffer.append("tr=(" + datam_r + "-" + datam_i + ")*(" + wi + ");\r\n");
                    sbuffer.append("ti=(" + datam_r + "+" + datam_i + ")*(" + wr + ");\r\n");
                } else if (Math.abs(wr + wi) < 1.0E-7) {
                    sbuffer.append("tr=(" + datam_r + "+" + datam_i + ")*(" + wr + ");\r\n");
                    sbuffer.append("ti=(" + datam_r + "-" + datam_i + ")*(" + wi + ");\r\n");
                } else {
                    sbuffer.append("tr=" + datam_r + "*(" + wr + ")-" + datam_i + "*(" + wi + ");\r\n");
                    sbuffer.append("ti=" + datam_r + "*(" + wi + ")+" + datam_i + "*(" + wr + ");\r\n");
                }
                sbuffer.append(String.valueOf(datam_r) + "=" + datan_r + "-tr;\r\n");
                sbuffer.append(String.valueOf(datam_i) + "=" + datan_i + "-ti;\r\n");
                sbuffer.append(String.valueOf(datan_r) + "=" + datan_r + "+tr;\r\n");
                sbuffer.append(String.valueOf(datan_i) + "=" + datan_i + "+ti;\r\n");
                n += 2;
            }
        }
        int n = 0;
        while (n < fftFrameSize2) {
            sbuffer.append("d[" + n + "+offset]=d" + n + ";\r\n");
            ++n;
        }
        sbuffer.append("}\r\n");
        sbuffer.append("}\r\n");
        return sbuffer.toString();
    }
}

