/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import rasmus.interpreter.controls.ControlAdapter;

public abstract class ControlPaintAdapter
extends ControlAdapter {
    JComponent panel = null;
    BufferedImage offImg;
    BufferedImage onImg;
    Graphics2D offGraphic;
    Graphics2D onGraphic;
    Dimension currentsize = null;
    boolean paintIntStatus = false;
    long paintIntStatus_time = 0L;
    boolean doublebuffering = true;
    int x_offset = 0;

    public void setXOffset(int value) {
        this.x_offset = value;
    }

    public void setDoubleBuffering(boolean value) {
        this.doublebuffering = value;
    }

    public boolean isDoubleBuffering() {
        return this.doublebuffering;
    }

    public Dimension getSize() {
        return this.currentsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        try {
            if (!this.doublebuffering) {
                this.panel.repaint();
                return;
            }
            Object object = this.panel;
            synchronized (object) {
                if (this.paintIntStatus) {
                    if (System.currentTimeMillis() - this.paintIntStatus_time < 250L) {
                        return;
                    }
                    this.paintIntStatus = false;
                }
            }
            object = this;
            synchronized (object) {
                BufferedImage bak = this.onImg;
                this.onImg = this.offImg;
                this.offImg = bak;
                Graphics2D bakGraphic = this.onGraphic;
                this.onGraphic = this.offGraphic;
                this.offGraphic = bakGraphic;
                this.paintIntStatus = true;
                this.paintIntStatus_time = System.currentTimeMillis();
            }
            this.panel.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphics2D getGraphics() {
        Dimension size = this.getJComponent().getSize();
        if (size.width == 0 && size.height == 0) {
            size = this.getJComponent().getPreferredSize();
        }
        if (this.currentsize != null && (this.currentsize.width != size.width || this.currentsize.height != size.height)) {
            ControlPaintAdapter controlPaintAdapter = this;
            synchronized (controlPaintAdapter) {
                this.offImg = null;
                this.onImg = null;
            }
        }
        if (this.offImg == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
            ControlPaintAdapter controlPaintAdapter = this;
            synchronized (controlPaintAdapter) {
                this.onImg = graphicsConfiguration.createCompatibleImage(size.width, size.height, 2);
                this.onGraphic = this.onImg.createGraphics();
                if (this.doublebuffering) {
                    this.offImg = graphicsConfiguration.createCompatibleImage(size.width, size.height, 2);
                    this.offGraphic = this.offImg.createGraphics();
                } else {
                    this.offImg = this.onImg;
                    this.offGraphic = this.onGraphic;
                }
            }
            this.currentsize = size;
        }
        return this.offGraphic;
    }

    public BufferedImage getBufferedImage() {
        this.getGraphics();
        return this.offImg;
    }

    public JComponent getJComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JComponent(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintComponent(Graphics graphics) {
                if (!ControlPaintAdapter.this.doublebuffering) {
                    int x_offset = ControlPaintAdapter.this.x_offset;
                    if (x_offset == 0) {
                        graphics.drawImage(ControlPaintAdapter.this.onImg, 0, 0, this);
                    } else {
                        Dimension size = this.getSize();
                        int w = size.width;
                        int h = size.height;
                        graphics.drawImage(ControlPaintAdapter.this.onImg, 0, 0, w - x_offset, h, x_offset, 0, w, h, this);
                        graphics.drawImage(ControlPaintAdapter.this.onImg, w - x_offset, 0, w, h, 0, 0, x_offset, h, this);
                    }
                    return;
                }
                Object object = ControlPaintAdapter.this;
                synchronized (object) {
                    if (ControlPaintAdapter.this.onImg == null) {
                        return;
                    }
                    graphics.drawImage(ControlPaintAdapter.this.onImg, 0, 0, this);
                }
                object = ControlPaintAdapter.this.panel;
                synchronized (object) {
                    ControlPaintAdapter.this.paintIntStatus = false;
                }
            }
        };
        return this.panel;
    }
}

