/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.Control;
import rasmus.interpreter.controls.ControlInstance;
import rasmus.interpreter.controls.Controls;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.math.DoublePart;

public class ControlViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Controls controls;
    NameSpace namespace;
    private ListPartListener listlistener = new ListPartListener(){

        public void objectAdded(ListPart source, Object object) {
            ControlViewer.this.namespace.addToCommitStack(ControlViewer.this.init_runnable);
        }

        public void objectRemoved(ListPart source, Object object) {
            ControlViewer.this.namespace.addToCommitStack(ControlViewer.this.init_runnable);
        }

        public void objectsAdded(ListPart source, List objects) {
            ControlViewer.this.namespace.addToCommitStack(ControlViewer.this.init_runnable);
        }

        public void objectsRemoved(ListPart source, List objects) {
            ControlViewer.this.namespace.addToCommitStack(ControlViewer.this.init_runnable);
        }
    };
    private HashMap controls_map = new HashMap();
    private Commitable init_runnable = new Commitable(){

        public int getRunLevel() {
            return 100;
        }

        public void commit() {
            Runnable runnable = new Runnable(this){
                final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    if (ControlViewer.access$1(2.access$0(this.this$1)) != null) {
                        List list = ControlViewer.access$1(2.access$0(this.this$1)).getObjects();
                        for (Control control : list) {
                            if (ControlViewer.access$2(2.access$0(this.this$1)).containsKey(control)) continue;
                            ControlViewer.access$3(2.access$0(this.this$1), control);
                        }
                        Object[] controls = ControlViewer.access$2(2.access$0(this.this$1)).keySet().toArray();
                        int i = 0;
                        while (i < controls.length) {
                            Control control = (Control)controls[i];
                            if (!list.contains(control)) {
                                ControlViewer.access$4(2.access$0(this.this$1), control);
                            }
                            ++i;
                        }
                        2.access$0(this.this$1).repaint();
                        2.access$0(this.this$1).invalidate();
                        2.access$0(this.this$1).validate();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        static /* synthetic */ ControlViewer access$0(2 var0) {
            return var0.ControlViewer.this;
        }
    };

    public ControlViewer(NameSpace namespace, Variable variable) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.controls = Controls.getInstance(variable);
        this.controls.addListener(this.listlistener);
        this.namespace = namespace;
        namespace.addToCommitStack(this.init_runnable);
    }

    public void close() {
        Runnable runnable = new Runnable(){

            public void run() {
                Object[] controls = ControlViewer.this.controls_map.keySet().toArray();
                int i = 0;
                while (i < controls.length) {
                    ControlViewer.this.removeControl((Control)controls[i]);
                    ++i;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
        this.controls.removeListener(this.listlistener);
        this.controls = null;
    }

    private void addControl(Control control) {
        Dimension d;
        Variable fill;
        Variable margin;
        Variable weight;
        Variable colweight;
        Variable rowweight;
        Variable colspan;
        Variable rowspan;
        Variable col;
        RControlVector vector = new RControlVector();
        vector.instance = control.newInstance();
        vector.comp = vector.instance.getJComponent();
        this.controls_map.put(control, vector);
        GridBagConstraints c = new GridBagConstraints();
        Variable row = (Variable)control.parameters.get("row");
        if (row != null) {
            c.gridy = (int)DoublePart.asDouble(row);
        }
        if ((col = (Variable)control.parameters.get("col")) != null) {
            c.gridx = (int)DoublePart.asDouble(col);
        }
        if ((rowspan = (Variable)control.parameters.get("rowspan")) != null) {
            c.gridheight = (int)DoublePart.asDouble(rowspan);
        }
        if ((colspan = (Variable)control.parameters.get("colspan")) != null) {
            c.gridwidth = (int)DoublePart.asDouble(colspan);
        }
        if ((rowweight = (Variable)control.parameters.get("rowweight")) != null) {
            c.weighty = DoublePart.asDouble(rowweight);
        }
        if ((colweight = (Variable)control.parameters.get("colweight")) != null) {
            c.weightx = DoublePart.asDouble(colweight);
        }
        if ((weight = (Variable)control.parameters.get("weight")) != null) {
            c.weightx = DoublePart.asDouble(weight);
            c.weighty = DoublePart.asDouble(weight);
        }
        if ((margin = (Variable)control.parameters.get("margin")) != null) {
            int m = (int)DoublePart.asDouble(margin);
            c.insets = new Insets(m, m, m, m);
        }
        if ((fill = (Variable)control.parameters.get("fill")) != null) {
            int f = (int)DoublePart.asDouble(fill);
            if (f == 1) {
                c.fill = 1;
            }
            if (f == 2) {
                c.fill = 2;
            }
            if (f == 3) {
                c.fill = 3;
            }
        }
        Variable width = (Variable)control.parameters.get("width");
        Variable height = (Variable)control.parameters.get("height");
        if (width != null) {
            double w = DoublePart.asDouble(width);
            d = vector.comp.getMaximumSize();
            d.width = (int)w;
            vector.comp.setMaximumSize(d);
            d = vector.comp.getPreferredSize();
            d.width = (int)w;
            vector.comp.setPreferredSize(d);
        }
        if (height != null) {
            double h = DoublePart.asDouble(height);
            d = vector.comp.getMaximumSize();
            d.height = (int)h;
            vector.comp.setMaximumSize(d);
            d = vector.comp.getPreferredSize();
            d.height = (int)h;
            vector.comp.setPreferredSize(d);
        }
        this.add((Component)vector.comp, c);
    }

    private void removeControl(Control control) {
        RControlVector vector = (RControlVector)this.controls_map.get(control);
        if (vector == null) {
            return;
        }
        this.controls_map.remove(control);
        vector.instance.close();
        this.remove(vector.comp);
    }

    static /* synthetic */ Controls access$1(ControlViewer controlViewer) {
        return controlViewer.controls;
    }

    static /* synthetic */ void access$3(ControlViewer controlViewer, Control control) {
        controlViewer.addControl(control);
    }

    private class RControlVector {
        ControlInstance instance;
        JComponent comp;

        RControlVector() {
        }
    }
}

