/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls.midi;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.swing.JButton;
import javax.swing.JComponent;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.ControlAdapter;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.midi.MidiSequence;

class ControlMidiButtonInstance
extends ControlAdapter
implements ActionListener {
    JButton button = new JButton();
    Variable caption;
    Variable midioutput;
    Variable input;

    public ControlMidiButtonInstance(NameSpace namespace, Map parameters) {
        this.button.addActionListener(this);
        this.caption = (Variable)parameters.get("caption");
        if (this.caption != null) {
            ObjectsPart.getInstance(this.caption).addListener(this);
        }
        this.midioutput = (Variable)parameters.get("midioutput");
        this.input = (Variable)parameters.get("input");
        this.calc();
    }

    public JComponent getJComponent() {
        return this.button;
    }

    public void close() {
        this.button.removeActionListener(this);
        if (this.caption != null) {
            ObjectsPart.getInstance(this.caption).removeListener(this);
        }
        this.caption = null;
    }

    public void calc() {
        if (this.caption != null) {
            this.button.setText(ObjectsPart.toString(this.caption));
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.midioutput == null) {
            return;
        }
        if (this.input == null) {
            return;
        }
        MidiSequence recv = MidiSequence.getInstance(this.midioutput);
        Sequence seq = MidiSequence.asSequence(this.input);
        try {
            Sequencer seqr = this.getSequencer();
            seqr.open();
            seqr.getTransmitter().setReceiver(recv);
            seqr.setSequence(seq);
            seqr.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Sequencer getSequencer() throws Exception {
        String midiseqname = "Real Time Sequencer";
        MidiDevice.Info[] devinfo = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < devinfo.length) {
            if (devinfo[i].getName().equals(midiseqname)) {
                try {
                    MidiDevice mdev = MidiSystem.getMidiDevice(devinfo[i]);
                    if (mdev instanceof Sequencer) {
                        return (Sequencer)mdev;
                    }
                }
                catch (MidiUnavailableException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return MidiSystem.getSequencer(false);
    }
}

