/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls.midi;

import java.util.Map;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.ControlAdapter;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;

class ControlMidiControlSliderInstance
extends ControlAdapter
implements Receiver {
    JSlider slider;
    Variable midioutput;
    Variable midiinput;
    Variable control;
    Variable defaultval;
    Variable min;
    Variable max;
    Variable orientation;
    Receiver recv;
    int i_control = 0;
    int set_value = 0;
    Runnable set_slider_value = new Runnable(){

        public void run() {
            if (ControlMidiControlSliderInstance.this.slider.getMinimum() <= ControlMidiControlSliderInstance.this.set_value && ControlMidiControlSliderInstance.this.slider.getMaximum() >= ControlMidiControlSliderInstance.this.set_value) {
                ControlMidiControlSliderInstance.this.slider.setValue(ControlMidiControlSliderInstance.this.set_value);
            }
        }
    };

    public ControlMidiControlSliderInstance(NameSpace namespace, Map parameters) {
        this.slider = new JSlider();
        this.slider.setMinimum(0);
        this.slider.setMaximum(127);
        this.slider.setValue(0);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(0);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                ShortMessage smessage = new ShortMessage();
                try {
                    smessage.setMessage(176, 0, ControlMidiControlSliderInstance.this.i_control, ControlMidiControlSliderInstance.this.slider.getValue());
                    if (ControlMidiControlSliderInstance.this.recv != null) {
                        ControlMidiControlSliderInstance.this.recv.send(smessage, -1L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.midioutput = (Variable)parameters.get("midioutput");
        this.midiinput = (Variable)parameters.get("midiinput");
        this.control = (Variable)parameters.get("control");
        this.defaultval = (Variable)parameters.get("default");
        this.min = (Variable)parameters.get("min");
        this.max = (Variable)parameters.get("max");
        this.orientation = (Variable)parameters.get("orientation");
        if (this.midiinput != null) {
            MidiSequence.getInstance(this.midiinput).addReceiver(this);
        }
        if (this.control != null) {
            DoublePart.getInstance(this.control).addListener(this);
        }
        if (this.defaultval != null) {
            DoublePart.getInstance(this.defaultval).addListener(this);
        }
        if (this.min != null) {
            DoublePart.getInstance(this.min).addListener(this);
        }
        if (this.max != null) {
            DoublePart.getInstance(this.max).addListener(this);
        }
        if (this.orientation != null) {
            DoublePart.getInstance(this.orientation).addListener(this);
        }
        if (this.midioutput != null) {
            this.recv = MidiSequence.getInstance(this.midioutput);
        }
        this.calc();
    }

    public JComponent getJComponent() {
        return this.slider;
    }

    public void close() {
        if (this.midiinput != null) {
            MidiSequence.getInstance(this.midiinput).removeReceiver(this);
        }
        if (this.control != null) {
            DoublePart.getInstance(this.control).removeListener(this);
        }
        if (this.defaultval != null) {
            DoublePart.getInstance(this.defaultval).removeListener(this);
        }
        if (this.min != null) {
            DoublePart.getInstance(this.min).removeListener(this);
        }
        if (this.max != null) {
            DoublePart.getInstance(this.max).removeListener(this);
        }
        if (this.orientation != null) {
            DoublePart.getInstance(this.orientation).removeListener(this);
        }
    }

    public void calc() {
        if (this.control != null) {
            this.i_control = (int)DoublePart.asDouble(this.control);
        }
        if (this.min != null) {
            this.slider.setMinimum((int)DoublePart.asDouble(this.min));
        }
        if (this.max != null) {
            this.slider.setMaximum((int)DoublePart.asDouble(this.max));
        }
        if (this.defaultval != null) {
            this.slider.setValue((int)DoublePart.asDouble(this.defaultval));
        }
        if (this.orientation != null) {
            int i_orientation = (int)DoublePart.asDouble(this.orientation);
            if (i_orientation == 0) {
                this.slider.setOrientation(0);
            }
            if (i_orientation == 1) {
                this.slider.setOrientation(1);
            }
        }
        if (this.slider.getMaximum() - this.slider.getMinimum() < 16) {
            this.slider.setSnapToTicks(true);
            this.slider.setMajorTickSpacing(1);
        } else if (this.slider.getMaximum() - this.slider.getMinimum() == 127) {
            this.slider.setSnapToTicks(false);
            this.slider.setMajorTickSpacing(16);
        } else {
            this.slider.setSnapToTicks(false);
            this.slider.setMajorTickSpacing(0);
        }
    }

    public void send(MidiMessage arg0, long arg1) {
        ShortMessage sm;
        if (arg0 instanceof ShortMessage && (sm = (ShortMessage)arg0).getStatus() == 176 && sm.getData1() == this.i_control) {
            this.set_value = sm.getData2();
            SwingUtilities.invokeLater(this.set_slider_value);
        }
    }
}

