/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls.midi;

import java.util.Map;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.controls.ControlInstance;
import rasmus.interpreter.controls.ControlUnitFactory;
import rasmus.interpreter.controls.midi.ControlMidiControlSliderInstance;
import rasmus.interpreter.metadata.MetaData;

public class MidiControlSlider
extends ControlUnitFactory {
    public MidiControlSlider() {
        this.registerParameter(1, "midioutput");
        this.registerParameter(2, "control");
        this.registerParameter(3, "default");
        this.registerParameter(4, "min");
        this.registerParameter(5, "max");
        this.registerParameter(6, "orientation");
        this.registerParameter(7, "midiinput");
        this.registerParameter("input", "midiinput");
    }

    public MetaData getMetaData() {
        MetaData metadata = super.getMetaData();
        metadata.setDescription("MIDI Control Slider");
        metadata.add(1, "midioutput", "MIDI output", null, null, 4, 2);
        metadata.add(2, "control", "MIDI control", null, null, 1, 1);
        metadata.add(3, "default", "Default value", null, null, 1, 1);
        metadata.add(4, "min", "Min value", null, null, 1, 1);
        metadata.add(5, "max", "Min value", null, null, 1, 1);
        metadata.add(6, "orientation", "Orientation", null, null, 1, 1);
        metadata.add(7, "midiinput", "MIDI Input", null, null, 4, 1);
        metadata.add(-1, "input", "MIDI Input", null, null, 4, 1);
        return metadata;
    }

    public ControlInstance newControlInstance(NameSpace namespace, Map parameters) {
        return new ControlMidiControlSliderInstance(namespace, parameters);
    }
}

