/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls.sampled;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Map;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.sampled.AudioAbstractAnalyzer;
import rasmus.interpreter.math.DoublePart;

public abstract class AudioAbstractGraphAnalyzer
extends AudioAbstractAnalyzer {
    int mode = 0;
    Variable refreshrate;
    long waittimens = 50L;
    long lastpainttime;
    int s_index = 0;
    int[] rgbarray = null;

    public AudioAbstractGraphAnalyzer(Map parameters) {
        super(parameters);
        Variable mode = (Variable)parameters.get("mode");
        if (mode != null) {
            this.mode = (int)DoublePart.asDouble(mode);
        }
        if (this.mode != 0) {
            this.setDoubleBuffering(false);
        }
        this.refreshrate = (Variable)parameters.get("refreshrate");
    }

    public void run() {
        double refreshrate = 20.0;
        if (this.refreshrate != null) {
            refreshrate = (int)DoublePart.asDouble(this.refreshrate);
        }
        this.waittimens = (int)(1000.0 / refreshrate);
        this.lastpainttime = System.currentTimeMillis();
    }

    public void paint(double[][] buffer) {
        switch (this.mode) {
            case 0: {
                this.paintGraph(buffer);
                break;
            }
            case 1: {
                this.paintGraph2(buffer);
                break;
            }
            case 2: {
                this.paintGraph2(buffer);
                break;
            }
        }
    }

    public void paintGraph2(double[][] buffer) {
        int i;
        BufferedImage buffimg = this.getBufferedImage();
        Dimension size = this.getSize();
        int w = size.width;
        int h = size.height;
        int len = buffer[0].length;
        double y_step = -((double)h) / (double)len;
        double y = h - 1;
        int lasty = h - 1;
        int x = this.s_index;
        if (this.rgbarray == null || this.rgbarray.length < h) {
            this.rgbarray = new int[h];
        }
        if (buffer.length == 1) {
            i = 0;
            while (i < len) {
                int value = (int)(buffer[0][i] * 255.0);
                if (value > 255) {
                    value = 255;
                }
                if (value < 0) {
                    value = 0;
                }
                int color = value + (value << 8) + 0 + -16777216;
                int y_i = (int)y;
                if (y_i < 0) {
                    y_i = 0;
                }
                Arrays.fill(this.rgbarray, y_i, lasty, color);
                lasty = y_i;
                ++i;
                y += y_step;
            }
        } else if (buffer.length == 2) {
            i = 0;
            while (i < len) {
                int c_b;
                int c_r;
                int c_g = (int)(buffer[0][i] * 255.0);
                if (c_g > 255) {
                    c_g = 255;
                }
                if (c_g < 0) {
                    c_g = 0;
                }
                if ((c_r = (int)(buffer[1][i] * 255.0)) > 255) {
                    c_r = 255;
                }
                if (c_r < 0) {
                    c_r = 0;
                }
                if ((c_b = c_g + c_r) > 255) {
                    c_b = 255;
                }
                int color = c_b + (c_g << 8) + (c_r << 16) + -16777216;
                int y_i = (int)y;
                if (y_i < 0) {
                    y_i = 0;
                }
                Arrays.fill(this.rgbarray, y_i, lasty, color);
                lasty = y_i;
                ++i;
                y += y_step;
            }
        } else if (buffer.length > 2) {
            i = 0;
            while (i < len) {
                int c_g = (int)(buffer[0][i] * 255.0);
                int c_r = (int)(buffer[1][i] * 255.0);
                int c_b = (int)(buffer[2][i] * 255.0);
                if (c_r > 255) {
                    c_r = 255;
                }
                if (c_g > 255) {
                    c_g = 255;
                }
                if (c_b > 255) {
                    c_b = 255;
                }
                if (c_r < 0) {
                    c_r = 0;
                }
                if (c_g < 0) {
                    c_g = 0;
                }
                if (c_b < 0) {
                    c_b = 0;
                }
                int color = c_b + (c_g << 8) + (c_r << 16) + -16777216;
                int y_i = (int)y;
                if (y_i < 0) {
                    y_i = 0;
                }
                Arrays.fill(this.rgbarray, y_i, lasty, color);
                lasty = y_i;
                ++i;
                y += y_step;
            }
        }
        buffimg.setRGB(x, 0, 1, h, this.rgbarray, 0, 1);
        ++this.s_index;
        if (this.s_index >= w) {
            this.s_index = 0;
            if (this.mode == 1) {
                Graphics2D g = this.getGraphics();
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, w, h);
            }
        }
        if (this.mode == 2) {
            this.setXOffset(this.s_index);
        }
        if (System.currentTimeMillis() - this.lastpainttime < this.waittimens) {
            return;
        }
        this.lastpainttime = System.currentTimeMillis();
        this.repaint();
    }

    public void paintGraph(double[][] buffer) {
        if (System.currentTimeMillis() - this.lastpainttime < this.waittimens) {
            return;
        }
        this.lastpainttime = System.currentTimeMillis();
        Graphics2D g = this.getGraphics();
        Dimension size = this.getSize();
        int w = size.width;
        int h = size.height;
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, w, h);
        int c = 0;
        while (c < buffer.length) {
            int lastx = 0;
            int lasty = 1;
            double[] fftbuff = buffer[c];
            double x_step = (double)w / (double)fftbuff.length;
            double x = 0.0;
            if (c == 0) {
                g.setColor(Color.CYAN);
            } else if (c == 1) {
                g.setColor(Color.MAGENTA);
            } else {
                g.setColor(Color.YELLOW);
            }
            int i = 0;
            while (i < fftbuff.length) {
                int i_x = (int)x;
                int y = (int)((1.0 - fftbuff[i]) * (double)h);
                g.drawLine(lastx, lasty, i_x, y);
                lasty = y;
                lastx = i_x;
                ++i;
                x += x_step;
            }
            ++c;
        }
        this.repaint();
    }
}

