/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.ext;

import java.util.List;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstance;
import rasmus.interpreter.unit.UnitInstancePart;

class EvalExpressionInstance
implements UnitInstancePart,
ListPartListener,
Commitable {
    UnitInstance unitinstance;
    Variable inputvar;
    Variable outputvar = null;
    Variable answer = null;
    NameSpace namespace;
    Interpreter interpreter = null;

    public int getRunLevel() {
        return 0;
    }

    public EvalExpressionInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.outputvar = parameters.getParameter(0, "output");
        this.inputvar = parameters.getParameterWithDefault(1, "input");
        ObjectsPart.getInstance(this.inputvar).addListener(this);
        this.namespace.addToCommitStack(this);
    }

    public void close() {
        this.clear();
        ObjectsPart.getInstance(this.inputvar).removeListener(this);
    }

    public void clear() {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
        if (this.answer != null) {
            this.outputvar.remove(this.answer);
            this.answer = null;
        }
    }

    public void commit() {
        Variable ret;
        this.clear();
        String code = ObjectsPart.toString(this.inputvar);
        this.interpreter = new Interpreter(this.namespace);
        this.interpreter.setAutoCommit(false);
        try {
            ret = this.interpreter.eval(code);
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
            this.interpreter.close();
            this.interpreter = null;
            return;
        }
        if (this.outputvar != null) {
            this.answer = ret;
            if (this.answer != null) {
                this.outputvar.add(this.answer);
            }
        }
    }

    public void objectAdded(ListPart source, Object object) {
        this.namespace.addToCommitStack(this);
    }

    public void objectRemoved(ListPart source, Object object) {
        this.namespace.addToCommitStack(this);
    }

    public void objectsAdded(ListPart source, List objects) {
        this.namespace.addToCommitStack(this);
    }

    public void objectsRemoved(ListPart source, List objects) {
        this.namespace.addToCommitStack(this);
    }
}

