/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.io.Resource;
import rasmus.interpreter.io.ResourceManager;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.namespace.OverrideNameSpace;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class EvalSourceInstance
extends UnitInstanceAdapter
implements Commitable {
    Variable outputvar;
    Variable filename;
    Variable answer = null;
    NameSpace namespace;
    Variable wrkdir;
    Variable encoding;
    ResourceManager manager;
    Interpreter interpreter = null;
    Resource resource = null;

    public EvalSourceInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.manager = ResourceManager.getInstance(this.namespace);
        this.outputvar = parameters.getParameter("output");
        this.filename = parameters.getParameterWithDefault(1, "filename");
        this.encoding = parameters.getParameter(2, "encoding");
        this.wrkdir = parameters.get("wrkdir");
        ObjectsPart.getInstance(this.filename).addListener(this);
        ObjectsPart.getInstance(this.wrkdir).addListener(this);
        if (this.encoding != null) {
            ObjectsPart.getInstance(this.encoding).addListener(this);
        }
        this.calc();
    }

    public void calc() {
        this.namespace.addToCommitStack(this);
    }

    public void close() {
        this.clear();
        if (this.resource != null) {
            this.resource.close();
            this.resource = null;
        }
        ObjectsPart.getInstance(this.filename).removeListener(this);
        ObjectsPart.getInstance(this.wrkdir).removeListener(this);
        if (this.encoding != null) {
            ObjectsPart.getInstance(this.encoding).removeListener(this);
        }
    }

    public String expandPath(String path) {
        if ((path = path.trim()).length() == 0) {
            return path;
        }
        if (path.startsWith(File.separator)) {
            return path;
        }
        if (path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == File.separatorChar) {
            return path;
        }
        String wrkdir = ObjectsPart.toString(this.wrkdir);
        if (wrkdir.trim().length() == 0) {
            return path;
        }
        if (wrkdir.endsWith(File.separator)) {
            return String.valueOf(wrkdir) + path;
        }
        return String.valueOf(wrkdir) + File.separator + path;
    }

    public void clear() {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
        if (this.answer != null) {
            this.outputvar.remove(this.answer);
            this.answer = null;
        }
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        Variable ret;
        int li;
        FileInputStream fis;
        this.clear();
        String filename = this.expandPath(ObjectsPart.toString(this.filename));
        if (this.resource != null) {
            this.resource.close();
        }
        this.resource = this.manager.getResource(filename);
        if (this.resource == null) {
            return;
        }
        File file = this.resource.getFile();
        String encoding = null;
        if (this.encoding != null) {
            encoding = this.expandPath(ObjectsPart.toString(this.encoding));
        }
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        StringBuffer sb = null;
        try {
            try {
                InputStreamReader reader = encoding != null ? new InputStreamReader((InputStream)fis, encoding) : new InputStreamReader(fis);
                sb = new StringBuffer();
                BufferedReader breader = new BufferedReader(reader);
                String line = breader.readLine();
                while (line != null) {
                    sb.append(String.valueOf(line) + "\n");
                    line = breader.readLine();
                }
                ((Reader)reader).close();
            }
            finally {
                fis.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        String code = sb.toString();
        String path = filename;
        if (ResourceManager.isURL(path) && (li = path.lastIndexOf("?")) != -1) {
            path = path.substring(0, li);
        }
        Variable wrkdir = null;
        int li2 = path.lastIndexOf("/");
        if (li2 == -1) {
            li2 = path.lastIndexOf("\\");
        }
        if (li2 != -1) {
            path = path.substring(0, li2 + 1);
            wrkdir = ObjectsPart.asVariable(path);
        }
        OverrideNameSpace inamespace = new OverrideNameSpace(this.namespace);
        if (wrkdir != null) {
            inamespace.put("wrkdir", wrkdir);
        }
        this.interpreter = new Interpreter(inamespace);
        this.interpreter.setAutoCommit(false);
        try {
            ret = this.interpreter.eval(code);
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
            this.interpreter.close();
            this.interpreter = null;
            return;
        }
        if (this.outputvar != null) {
            this.answer = ret;
            if (this.answer != null) {
                this.outputvar.add(this.answer);
            }
        }
    }
}

