/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.io;

import java.io.File;
import java.util.Hashtable;
import rasmus.interpreter.io.ResourceManager;

public class Resource {
    private File file;
    private String path;
    private ResourceManager manager;
    private boolean stored = false;
    private int usecount = 0;

    public Resource clone(ResourceManager manager) {
        return new Resource(manager, this.path, this.file, this.stored);
    }

    public Resource(ResourceManager manager, String path, File file) {
        this.path = path;
        this.file = file;
        this.manager = manager;
    }

    public Resource(ResourceManager manager, String path, File file, boolean stored) {
        this.path = path;
        this.file = file;
        this.manager = manager;
        this.stored = stored;
    }

    public ResourceManager getManager() {
        return this.manager;
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkout() {
        Resource resource = this;
        synchronized (resource) {
            ++this.usecount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Resource resource = this;
        synchronized (resource) {
            --this.usecount;
            if (!this.stored && this.usecount == 0) {
                Hashtable<String, Resource> hashtable = this.manager.resources;
                synchronized (hashtable) {
                    this.manager.resources.remove(this.path);
                }
            }
        }
    }
}

