/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.io.Resource;
import rasmus.interpreter.list.ObjectsPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    protected Hashtable<String, Resource> resources = new Hashtable();
    private Map<String, Resource> downloaded_resources = new HashMap<String, Resource>();
    private static Properties mimetypes = new Properties();
    private static boolean mimetypes_loaded = false;
    static /* synthetic */ Class class$0;

    public static ResourceManager getInstance(NameSpace namespace) {
        Variable managervar = namespace.get("_resource_manager");
        Object[] objects = ObjectsPart.getInstance(managervar).getObjects().toArray();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ResourceManager) {
                return (ResourceManager)objects[i];
            }
            ++i;
        }
        ResourceManager manager = new ResourceManager();
        managervar.add(ObjectsPart.asVariable(manager));
        return manager;
    }

    public Collection<Resource> getResources() {
        return this.resources.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String path) {
        if (path.length() == 0) {
            return null;
        }
        Hashtable<String, Resource> hashtable = this.resources;
        synchronized (hashtable) {
            Resource resource = this.resources.get(path);
            if (resource == null) {
                if (ResourceManager.isURL(path)) {
                    resource = this.getResourceFromURL(path);
                    if (resource == null) {
                        return null;
                    }
                    this.resources.put(path, resource);
                } else {
                    File file = new File(path);
                    if (!file.exists()) {
                        System.err.println(String.valueOf(file.getPath()) + " not found.");
                        return null;
                    }
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                    if (!file.isFile()) {
                        return null;
                    }
                    resource = new Resource(this, path, file);
                    this.resources.put(path, resource);
                }
            }
            resource.checkout();
            return resource;
        }
    }

    public static boolean isURL(String url) {
        int i = 0;
        char[] chars = url.toCharArray();
        if (i == chars.length) {
            return false;
        }
        if (!Character.isLetter(chars[i])) {
            return false;
        }
        ++i;
        while (i < chars.length) {
            if (!Character.isLetter(chars[i])) break;
            ++i;
        }
        if (i == chars.length) {
            return false;
        }
        if (chars[i] != ':') {
            return false;
        }
        if (++i == chars.length) {
            return false;
        }
        if (chars[i] != '/') {
            return false;
        }
        if (++i == chars.length) {
            return false;
        }
        if (chars[i] != '/') {
            return false;
        }
        ++i;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResourceFromURL(String path) {
        File file;
        URL url;
        Map<String, Resource> map = this.downloaded_resources;
        synchronized (map) {
            Resource resource = this.downloaded_resources.get(path);
            if (resource != null) {
                return resource;
            }
        }
        try {
            url = new URL(path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        try {
            file = this.downloadFromURL(url);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (file == null) {
            return null;
        }
        file.deleteOnExit();
        Resource resource = new Resource(this, path, file, true);
        Map<String, Resource> map2 = this.downloaded_resources;
        synchronized (map2) {
            this.downloaded_resources.put(path, resource);
        }
        return resource;
    }

    private File downloadFromURL(URL url) throws IOException {
        InputStream is;
        File tempfile;
        if (url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https")) {
            URLConnection conn = url.openConnection();
            String mimetype = conn.getContentType();
            String ext = null;
            if (mimetype != null) {
                ext = ResourceManager.getMimeTypeExtension(mimetype);
            }
            if (ext == null) {
                String path = url.getPath();
                String suffix = path;
                int li = suffix.lastIndexOf("/");
                if (li == -1) {
                    li = suffix.lastIndexOf("\\");
                }
                if (li != -1) {
                    suffix = suffix.substring(li + 1);
                }
                suffix = (li = path.lastIndexOf(".")) != -1 ? path.substring(li) : "";
                ext = suffix;
            }
            tempfile = File.createTempFile("rasmusdsp_url", "." + ext);
            is = conn.getInputStream();
        } else {
            String path = url.getPath();
            String suffix = path;
            int li = suffix.lastIndexOf("/");
            if (li == -1) {
                li = suffix.lastIndexOf("\\");
            }
            if (li != -1) {
                suffix = suffix.substring(li + 1);
            }
            suffix = (li = path.lastIndexOf(".")) != -1 ? path.substring(li) : "";
            String ext = suffix;
            tempfile = File.createTempFile("rasmusdsp_url", ext);
            is = url.openStream();
        }
        System.out.println("Downloading " + url.toExternalForm());
        FileOutputStream fos = new FileOutputStream(tempfile);
        try {
            int ret;
            byte[] buffer = new byte[1024];
            while ((ret = is.read(buffer, 0, 1024)) != -1) {
                fos.write(buffer, 0, ret);
            }
        }
        finally {
            fos.close();
        }
        tempfile.deleteOnExit();
        is.close();
        return tempfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeTypeExtension(String mimetype) throws IOException {
        Properties properties = mimetypes;
        synchronized (properties) {
            if (!mimetypes_loaded) {
                InputStream is = ResourceManager.class.getClass().getResourceAsStream("/rasmus/interpreter/io/mimetypes.properties");
                mimetypes.load(is);
                is.close();
                mimetypes_loaded = true;
            }
        }
        return mimetypes.getProperty(mimetype);
    }

    public void importResource(String path, File file) {
        this.resources.put(path, new Resource(this, path, file, true));
    }

    public void importResources(ResourceManager manager) {
        for (Map.Entry<String, Resource> entry : manager.resources.entrySet()) {
            String path = entry.getKey();
            Resource resource = this.resources.get(path);
            if (resource != null) continue;
            Resource import_resource = entry.getValue();
            this.resources.put(path, import_resource.clone(this));
        }
    }
}

