/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import rasmus.interpreter.Variable;
import rasmus.interpreter.VariablePartAdapter;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.list.SynchronizedList;

public abstract class ListPart
extends VariablePartAdapter {
    public static boolean resetMode = false;
    private List objects = new LinkedList();
    private boolean immutable = false;
    RListList listlist = new RListList();
    boolean hasobjects = false;
    boolean hassingleeobjects = false;
    static long adding = 0L;
    ArrayList childlists = new ArrayList();
    public List dependvar = new ArrayList();
    ListPartListener listener = new ListPartListener(){

        public void objectAdded(ListPart source, Object object) {
            if (ListPart.this.childlists.contains(source)) {
                ListPart.this.sendObjectAdded(object);
                return;
            }
            ListPart.this.addObject(object);
        }

        public void objectRemoved(ListPart source, Object object) {
            if (ListPart.this.childlists.contains(source)) {
                ListPart.this.sendObjectRemoved(object);
                return;
            }
            ListPart.this.removeObject(object);
        }

        public void objectsAdded(ListPart source, List objects) {
            if (ListPart.this.childlists.contains(source)) {
                ListPart.this.sendObjectsAdded(objects);
                return;
            }
            ListPart.this.addObjects(objects);
        }

        public void objectsRemoved(ListPart source, List objects) {
            if (ListPart.this.childlists.contains(source)) {
                ListPart.this.sendObjectsRemoved(objects);
                return;
            }
            ListPart.this.removeObjects(objects);
        }
    };
    public List listeners = new ArrayList();
    public ListPartListener[] listenerslist = null;

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean value) {
        this.immutable = value;
    }

    public List getObjects() {
        return this.listlist;
    }

    public SynchronizedList synchronizedList() {
        return new SynchronizedList(this);
    }

    public void addObject(Object object) {
        if (resetMode) {
            return;
        }
        this.objects.add(object);
        this.sendObjectAdded(object);
    }

    public void removeObject(Object object) {
        if (resetMode) {
            return;
        }
        this.objects.remove(object);
        this.sendObjectRemoved(object);
    }

    public void addObjects(List list) {
        if (resetMode) {
            return;
        }
        this.objects.addAll(list);
        this.sendObjectsAdded(list);
    }

    public void removeObjects(List list) {
        if (resetMode) {
            return;
        }
        this.objects.removeAll(list);
        this.sendObjectsRemoved(list);
    }

    public void add(Variable variable) {
        ListPart source = (ListPart)variable.get(this.getClass());
        this.childlists.add(source);
        this.sendObjectsAdded(source.getObjects());
        if (!source.isImmutable()) {
            source.addListener(this.listener);
        }
        this.dependvar.add(source);
    }

    public void remove(Variable variable) {
        ListPart source = (ListPart)variable.get(this.getClass());
        this.childlists.remove(source);
        this.sendObjectsRemoved(source.getObjects());
        if (!source.isImmutable()) {
            source.removeListener(this.listener);
        }
        this.dependvar.remove(source);
    }

    public void clear() {
        Iterator di = this.dependvar.iterator();
        while (di.hasNext()) {
            ((ListPart)di.next()).removeListener(this.listener);
        }
        ArrayList oder = new ArrayList();
        Iterator iterator = this.getObjects().iterator();
        while (iterator.hasNext()) {
            oder.add(iterator.next());
        }
        ArrayList bef_objects = oder;
        this.objects = new ArrayList();
        this.sendObjectsRemoved(bef_objects);
        this.childlists.clear();
        this.dependvar.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListPartListener[] getListeners() {
        ListPartListener[] listenerslist = null;
        List list = this.listeners;
        synchronized (list) {
            if (this.listenerslist == null) {
                this.listenerslist = new ListPartListener[this.listeners.size()];
                this.listeners.toArray(this.listenerslist);
            }
            listenerslist = this.listenerslist;
        }
        return listenerslist;
    }

    public void sendObjectAdded(Object object) {
        ListPartListener[] listenerslist = this.getListeners();
        int i = 0;
        while (i < listenerslist.length) {
            listenerslist[i].objectAdded(this, object);
            ++i;
        }
    }

    public void sendObjectRemoved(Object object) {
        ListPartListener[] listenerslist = this.getListeners();
        int i = 0;
        while (i < listenerslist.length) {
            listenerslist[i].objectRemoved(this, object);
            ++i;
        }
    }

    public void sendObjectsAdded(List list) {
        ListPartListener[] listenerslist = this.getListeners();
        int i = 0;
        while (i < listenerslist.length) {
            listenerslist[i].objectsAdded(this, list);
            ++i;
        }
    }

    public void sendObjectsRemoved(List list) {
        ListPartListener[] listenerslist = this.getListeners();
        int i = 0;
        while (i < listenerslist.length) {
            listenerslist[i].objectsRemoved(this, list);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ListPartListener listener) {
        if (!this.isImmutable()) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
                this.listenerslist = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ListPartListener listener) {
        if (!this.isImmutable()) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
                this.listenerslist = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceAddListener(ListPartListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
            this.listenerslist = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRemoveListener(ListPartListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
            this.listenerslist = null;
        }
    }

    class RListList
    implements List {
        RListList() {
        }

        public ListPart getSource() {
            return ListPart.this;
        }

        public int size() {
            int sizecount = ListPart.this.objects.size();
            for (ListPart element : ListPart.this.childlists) {
                sizecount += element.getObjects().size();
            }
            return sizecount;
        }

        public boolean isEmpty() {
            if (!ListPart.this.objects.isEmpty()) {
                return false;
            }
            for (ListPart element : ListPart.this.childlists) {
                if (element.getObjects().isEmpty()) continue;
                return false;
            }
            return true;
        }

        public Iterator iterator() {
            return new Iterator(this){
                Iterator iterator;
                Iterator citerator;
                final /* synthetic */ RListList this$1;
                {
                    this.this$1 = rListList;
                    this.iterator = ListPart.access$0(RListList.access$0(rListList)).iterator();
                    this.citerator = RListList.access$0((RListList)rListList).childlists.iterator();
                }

                /*
                 * Unable to fully structure code
                 */
                public boolean hasNext() {
                    if (!this.iterator.hasNext()) ** GOTO lbl6
                    return true;
lbl-1000:
                    // 1 sources

                    {
                        this.iterator = ((ListPart)this.citerator.next()).getObjects().iterator();
                        if (!this.iterator.hasNext()) continue;
                        return true;
lbl6:
                        // 2 sources

                        ** while (this.citerator.hasNext())
                    }
lbl7:
                    // 1 sources

                    return false;
                }

                public Object next() {
                    return this.iterator.next();
                }

                public void remove() {
                }
            };
        }

        public boolean contains(Object arg0) {
            if (ListPart.this.objects.contains(arg0)) {
                return true;
            }
            for (ListPart element : ListPart.this.childlists) {
                if (!element.getObjects().contains(arg0)) continue;
                return true;
            }
            return false;
        }

        public Object[] toArray() {
            int size = this.size();
            Object[] array = new Object[size];
            Iterator iter = this.iterator();
            int i = 0;
            while (iter.hasNext()) {
                array[i] = iter.next();
                ++i;
            }
            return array;
        }

        public Object[] toArray(Object[] array) {
            Iterator iter = this.iterator();
            int i = 0;
            while (iter.hasNext()) {
                array[i] = iter.next();
                ++i;
            }
            return array;
        }

        public boolean add(Object arg0) {
            return false;
        }

        public boolean remove(Object arg0) {
            return false;
        }

        public boolean containsAll(Collection arg0) {
            return false;
        }

        public boolean addAll(Collection arg0) {
            return false;
        }

        public boolean addAll(int arg0, Collection arg1) {
            return false;
        }

        public boolean removeAll(Collection arg0) {
            return false;
        }

        public boolean retainAll(Collection arg0) {
            return false;
        }

        public void clear() {
        }

        public Object get(int arg0) {
            return null;
        }

        public Object set(int arg0, Object arg1) {
            return null;
        }

        public void add(int arg0, Object arg1) {
        }

        public Object remove(int arg0) {
            return null;
        }

        public int indexOf(Object arg0) {
            return 0;
        }

        public int lastIndexOf(Object arg0) {
            return 0;
        }

        public ListIterator listIterator() {
            return null;
        }

        public ListIterator listIterator(int arg0) {
            return null;
        }

        public List subList(int arg0, int arg1) {
            return null;
        }

        static /* synthetic */ ListPart access$0(RListList rListList) {
            return rListList.ListPart.this;
        }
    }
}

