/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.math.DoublePartListener;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class FloatMulitplierInstance
implements UnitInstancePart,
DoublePartListener,
Commitable {
    int operator;
    Variable answer = null;
    ArrayList elements = new ArrayList();
    ArrayList variables = new ArrayList();
    Variable returnvar;
    boolean calcok = false;
    boolean containsaudioevents = false;
    LinkedList audiosources = new LinkedList();
    ListPartListener listener = new ListPartListener(){

        public void objectAdded(ListPart source, Object object) {
            FloatMulitplierInstance.this.listCalc(source);
        }

        public void objectRemoved(ListPart source, Object object) {
            FloatMulitplierInstance.this.listCalc(source);
        }

        public void objectsAdded(ListPart source, List objects) {
            FloatMulitplierInstance.this.listCalc(source);
        }

        public void objectsRemoved(ListPart source, List objects) {
            FloatMulitplierInstance.this.listCalc(source);
        }
    };
    NameSpace namespace;

    public final double toDouble(boolean val) {
        if (val) {
            return 1.0;
        }
        return 0.0;
    }

    public int getRunLevel() {
        return 0;
    }

    public void calc() {
        if (!this.calcok) {
            return;
        }
        this.namespace.addToCommitStack(this);
    }

    public void commit() {
        double calc;
        if (this.returnvar == null) {
            return;
        }
        if (this.answer != null) {
            this.returnvar.remove(this.answer);
        }
        Iterator itr = this.elements.iterator();
        if (this.operator == 50) {
            calc = Math.random();
        } else if (itr.hasNext()) {
            calc = ((DoublePart)itr.next()).getDouble();
            if (this.operator < 50) {
                if (itr.hasNext()) {
                    if (this.operator == 0) {
                        while (itr.hasNext()) {
                            calc *= ((DoublePart)itr.next()).getDouble();
                        }
                    } else if (this.operator == 1) {
                        while (itr.hasNext()) {
                            double dval = ((DoublePart)itr.next()).getDouble();
                            if (dval == 0.0) continue;
                            calc /= dval;
                        }
                    } else if (this.operator == 2) {
                        while (itr.hasNext()) {
                            calc -= ((DoublePart)itr.next()).getDouble();
                        }
                    } else if (this.operator == 3) {
                        while (itr.hasNext()) {
                            calc += ((DoublePart)itr.next()).getDouble();
                        }
                    } else if (this.operator == 4) {
                        while (itr.hasNext()) {
                            calc %= ((DoublePart)itr.next()).getDouble();
                        }
                    } else if (this.operator == 5) {
                        while (itr.hasNext()) {
                            calc = this.toDouble(calc > ((DoublePart)itr.next()).getDouble());
                        }
                    } else if (this.operator == 6) {
                        while (itr.hasNext()) {
                            calc = this.toDouble(calc < ((DoublePart)itr.next()).getDouble());
                        }
                    } else if (this.operator == 7) {
                        while (itr.hasNext()) {
                            calc = this.toDouble(calc >= ((DoublePart)itr.next()).getDouble());
                        }
                    } else if (this.operator == 8) {
                        while (itr.hasNext()) {
                            calc = this.toDouble(calc <= ((DoublePart)itr.next()).getDouble());
                        }
                    } else if (this.operator == 9) {
                        while (itr.hasNext()) {
                            calc = this.toDouble(calc != ((DoublePart)itr.next()).getDouble());
                        }
                    } else if (this.operator == 10) {
                        while (itr.hasNext()) {
                            double diff = calc - ((DoublePart)itr.next()).getDouble();
                            if (diff < 0.0) {
                                diff = -diff;
                            }
                            calc = this.toDouble(diff < 1.0E-4);
                        }
                    }
                } else if (this.operator == 2) {
                    calc = -calc;
                }
            } else if (this.operator < 200) {
                if (this.operator == 100) {
                    calc = Math.abs(calc);
                } else if (this.operator == 101) {
                    calc = Math.acos(calc);
                } else if (this.operator == 102) {
                    calc = Math.asin(calc);
                } else if (this.operator == 103) {
                    calc = Math.atan(calc);
                } else if (this.operator == 104) {
                    calc = Math.ceil(calc);
                } else if (this.operator == 105) {
                    calc = Math.cos(calc);
                } else if (this.operator == 106) {
                    calc = Math.exp(calc);
                } else if (this.operator == 107) {
                    calc = Math.floor(calc);
                } else if (this.operator == 108) {
                    calc = Math.log(calc);
                } else if (this.operator == 109) {
                    calc = Math.rint(calc);
                } else if (this.operator == 110) {
                    calc = Math.round(calc);
                } else if (this.operator == 111) {
                    calc = Math.sin(calc);
                } else if (this.operator == 112) {
                    calc = Math.sqrt(calc);
                } else if (this.operator == 113) {
                    calc = Math.tan(calc);
                } else if (this.operator == 114) {
                    calc = Math.toDegrees(calc);
                } else if (this.operator == 115) {
                    calc = Math.toRadians(calc);
                } else if (this.operator == 116) {
                    calc = calc > 0.0 ? 1.0 : (calc < 0.0 ? -1.0 : 0.0);
                }
            } else if (itr.hasNext()) {
                double calc2 = ((DoublePart)itr.next()).getDouble();
                if (this.operator == 200) {
                    calc = Math.IEEEremainder(calc, calc2);
                }
                if (this.operator == 201) {
                    calc = Math.atan2(calc, calc2);
                }
                if (this.operator == 202) {
                    calc = Math.max(calc, calc2);
                }
                if (this.operator == 203) {
                    calc = Math.min(calc, calc2);
                }
                if (this.operator == 204) {
                    calc = Math.pow(calc, calc2);
                }
            }
        } else {
            calc = 0.0;
        }
        if (!this.containsaudioevents) {
            this.answer = DoublePart.asVariable(calc);
            this.returnvar.add(this.answer);
        } else {
            this.answer = null;
        }
    }

    public void listCalc(ListPart source) {
        if (source.getObjects().size() == 0) {
            if (this.audiosources.contains(source)) {
                this.audiosources.remove(source);
                if (this.containsaudioevents && this.audiosources.size() == 0) {
                    this.containsaudioevents = false;
                    this.calc();
                }
            }
        } else if (!this.audiosources.contains(source)) {
            this.audiosources.add(source);
            if (!this.containsaudioevents) {
                this.containsaudioevents = true;
                this.calc();
            }
        }
    }

    public FloatMulitplierInstance(Parameters parameters, int operator) {
        this.namespace = parameters.getNameSpace();
        this.operator = operator;
        this.returnvar = parameters.getParameter("output");
        int ii = 0;
        Variable var = parameters.getParameter("input");
        if (var == null) {
            ii = 1;
            var = parameters.getParameter(ii);
        }
        while (var != null) {
            AudioEvents events = AudioEvents.getInstance(var);
            events.addListener(this.listener);
            this.listCalc(events);
            DoublePart dvar = DoublePart.getInstance(var);
            this.variables.add(var);
            this.elements.add(dvar);
            dvar.addListener(this);
            var = parameters.getParameter(++ii);
        }
        this.calcok = true;
        this.calc();
    }

    public void close() {
        for (Variable var : this.variables) {
            AudioEvents events = AudioEvents.getInstance(var);
            events.removeListener(this.listener);
        }
        Iterator itr = this.elements.iterator();
        while (itr.hasNext()) {
            ((DoublePart)itr.next()).removeListener(this);
        }
        this.elements.clear();
        this.variables.clear();
        if (this.returnvar == null) {
            return;
        }
        if (this.answer != null) {
            this.returnvar.remove(this.answer);
        }
        this.answer = null;
    }

    public void valueChanged(DoublePart source, double before, double after) {
        this.calc();
    }
}

