/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.math;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.math.DoublePartListener;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class ScaleInstance
implements UnitInstancePart {
    ArrayList elements = new ArrayList();
    double[] scale_elements = null;
    Variable returnvar;
    Variable inputvar;
    Variable answer = null;
    DoublePartListener scale_listener = new DoublePartListener(){

        public void valueChanged(DoublePart source, double before, double after) {
            ScaleInstance.this.calcScale();
        }
    };
    DoublePartListener input_listener = new DoublePartListener(){

        public void valueChanged(DoublePart source, double before, double after) {
            ScaleInstance.this.calcInput();
        }
    };

    public void calcInput() {
        int octavlen;
        int oct;
        if (this.answer != null) {
            this.returnvar.remove(this.answer);
            this.answer = null;
        }
        if (this.scale_elements == null) {
            return;
        }
        if (this.scale_elements.length == 0) {
            return;
        }
        int note = (int)DoublePart.asDouble(this.inputvar);
        int base = note - (oct = note / (octavlen = this.scale_elements.length)) * octavlen;
        if (base < 0) {
            --oct;
            base += octavlen;
        }
        double ratio = Math.pow(this.scale_elements[this.scale_elements.length - 1], oct);
        if (base > 0) {
            ratio *= this.scale_elements[base - 1];
        }
        this.answer = DoublePart.asVariable(ratio);
        this.returnvar.add(this.answer);
    }

    public void calcScale() {
        this.scale_elements = new double[this.elements.size()];
        int i = 0;
        Iterator itr = this.elements.iterator();
        while (itr.hasNext()) {
            this.scale_elements[i] = DoublePart.asDouble((Variable)itr.next());
            ++i;
        }
        this.calcInput();
    }

    public ScaleInstance(Parameters parameters) {
        this.returnvar = parameters.getParameterWithDefault("output");
        this.inputvar = parameters.getParameter(1, "input");
        if (this.inputvar == null) {
            this.inputvar = DoublePart.asVariable(0.0);
        }
        DoublePart.getInstance(this.inputvar).addListener(this.input_listener);
        TreeMap sortedmap = new TreeMap(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return 0;
                }
                if (arg1 == null) {
                    return 0;
                }
                String s1 = (String)arg0;
                String s2 = (String)arg1;
                try {
                    return Integer.parseInt(s1) - Integer.parseInt(s2);
                }
                catch (Throwable t) {
                    return s1.compareTo(s2);
                }
            }
        });
        sortedmap.putAll(parameters.getParameters());
        for (String keyname : sortedmap.keySet()) {
            if (keyname.equals("0") || keyname.equals("1") || keyname.equals("input") || keyname.equals("output")) continue;
            Variable var = parameters.getParameter(keyname);
            DoublePart.getInstance(var).addListener(this.scale_listener);
            this.elements.add(var);
        }
        this.calcScale();
    }

    public void close() {
        DoublePart.getInstance(this.inputvar).removeListener(this.input_listener);
        Iterator itr = this.elements.iterator();
        while (itr.hasNext()) {
            DoublePart.getInstance((Variable)itr.next()).removeListener(this.scale_listener);
        }
        this.elements.clear();
        if (this.answer != null) {
            this.returnvar.remove(this.answer);
            this.answer = null;
        }
        this.returnvar = null;
        this.inputvar = null;
    }
}

