/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.metadata;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.metadata.MetaData;
import rasmus.interpreter.parser.ScriptTokenParser;
import rasmus.interpreter.unit.Unit;

public class FunctionCallEditor
extends JDialog {
    private GridBagConstraints constrains = new GridBagConstraints();
    private static final long serialVersionUID = 1L;
    private JPanel paramspanel;
    private GridBagLayout paramspanel_layout;
    private ArrayList params_added;
    private ArrayList params_metadata;
    private ArrayList params_editor;
    private boolean isok;

    public static boolean isEditableFunction(String funcName, NameSpace namespace) {
        List<MetaData> metadata;
        if (funcName.contains("(")) {
            String[] tokens = ScriptTokenParser.parseFunctionCall(funcName);
            if (tokens == null) {
                return false;
            }
            funcName = tokens[0];
        }
        return (metadata = Unit.getInstance(namespace.get(funcName)).getMetaData()) != null;
    }

    public static String editFunctionCall(Object owner, String expression, NameSpace namespace) {
        FunctionCallEditor fce;
        String[] tokens = ScriptTokenParser.parseFunctionCall(expression);
        if (!FunctionCallEditor.isEditableFunction(tokens[0], namespace)) {
            return null;
        }
        if (owner instanceof Frame) {
            fce = new FunctionCallEditor((Frame)owner, namespace, tokens[0]);
        } else if (owner instanceof Dialog) {
            fce = new FunctionCallEditor((Dialog)owner, namespace, tokens[0]);
        } else {
            return null;
        }
        ArrayList<String[]> outsideNamedParams = new ArrayList<String[]>();
        ArrayList<String[]> outsideParams = new ArrayList<String[]>();
        if (tokens.length != 2 || tokens[1].trim().length() != 0) {
            int param_no = 1;
            int i = 1;
            while (i < tokens.length) {
                String token = tokens[i];
                String[] pair = ScriptTokenParser.seperateParamNameAndValue(token);
                pair[1] = pair[1].trim();
                if (pair[0] != null) {
                    if (!fce.setParameter(pair[0].trim(), pair[1])) {
                        pair[0] = pair[0].trim();
                        outsideNamedParams.add(pair);
                    }
                } else {
                    if (!fce.setParameter(param_no, pair[1])) {
                        pair[0] = Integer.toString(param_no);
                        outsideParams.add(pair);
                    }
                    ++param_no;
                }
                ++i;
            }
        }
        fce.setVisible(true);
        if (fce.isOK()) {
            ArrayList editors = new ArrayList(fce.params_editor);
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(tokens[0]) + "(");
            int param_no = 1;
            boolean first_param = true;
            while (true) {
                String value = null;
                int i = 0;
                while (i < outsideParams.size()) {
                    String[] pair = (String[])outsideParams.get(i);
                    if (pair[0].equals(Integer.toString(param_no))) {
                        value = pair[1];
                        outsideParams.remove(i);
                        break;
                    }
                    ++i;
                }
                if (value == null) {
                    i = 0;
                    while (i < editors.size()) {
                        if (((ParameterEditor)editors.get((int)i)).number == param_no) {
                            value = ((ParameterEditor)editors.get(i)).getValue();
                            editors.remove(i);
                            if (value != null) break;
                        }
                        ++i;
                    }
                }
                if (value == null) break;
                if (!first_param) {
                    sb.append(",");
                } else {
                    first_param = false;
                }
                sb.append(value);
                ++param_no;
            }
            int i = 0;
            while (i < outsideParams.size()) {
                String[] pair = (String[])outsideParams.get(i);
                if (!first_param) {
                    sb.append(",");
                } else {
                    first_param = false;
                }
                sb.append(String.valueOf(pair[0].trim()) + "=" + pair[1]);
                ++i;
            }
            i = 0;
            while (i < outsideNamedParams.size()) {
                String[] pair = (String[])outsideNamedParams.get(i);
                if (!first_param) {
                    sb.append(",");
                } else {
                    first_param = false;
                }
                sb.append(String.valueOf(pair[0].trim()) + "=" + pair[1]);
                ++i;
            }
            i = 0;
            while (i < editors.size()) {
                String value = ((ParameterEditor)editors.get(i)).getValue();
                if (value != null) {
                    String name = ((ParameterEditor)editors.get((int)i)).name;
                    if (!first_param) {
                        sb.append(",");
                    } else {
                        first_param = false;
                    }
                    sb.append(String.valueOf(name) + "=" + value);
                }
                ++i;
            }
            sb.append(")");
            return sb.toString();
        }
        return null;
    }

    private boolean setParameter(int param, String value) {
        for (ParameterEditor param_editor : this.params_editor) {
            if (param_editor.number != param) continue;
            param_editor.setValue(value.trim());
            return true;
        }
        return false;
    }

    private boolean setParameter(String name, String value) {
        for (ParameterEditor param_editor : this.params_editor) {
            if (!name.equals(param_editor.name)) continue;
            param_editor.setValue(value.trim());
            return true;
        }
        return false;
    }

    private void addParameter(Map param_metadata) {
        Integer number = (Integer)param_metadata.get("number");
        String name = (String)param_metadata.get("name");
        if (name != null) {
            if (this.params_added.contains(name)) {
                return;
            }
            this.params_added.add(name);
        }
        if (number != null) {
            if (this.params_added.contains(number)) {
                return;
            }
            this.params_added.add(number);
        }
        this.params_metadata.add(param_metadata);
    }

    private void addParamSeperator() {
        this.constrains.gridx = 0;
        this.constrains.gridwidth = 0;
        this.constrains.weightx = 1.0;
        this.constrains.fill = 2;
        this.paramspanel.add((Component)new JSeparator(0), this.constrains);
        this.constrains.fill = 0;
        this.constrains.gridwidth = 1;
        this.constrains.weightx = 0.0;
        this.constrains.gridx = 0;
        ++this.constrains.gridy;
    }

    private boolean isOK() {
        return this.isok;
    }

    private void ok() {
        this.isok = true;
    }

    private FunctionCallEditor(Frame owner, NameSpace namespace, String funcName) {
        super(owner);
        this.constrains.gridy = 0;
        this.constrains.anchor = 17;
        this.constrains.insets = new Insets(3, 3, 3, 3);
        this.paramspanel = new JPanel();
        this.paramspanel_layout = new GridBagLayout();
        this.paramspanel.setLayout(this.paramspanel_layout);
        this.params_added = new ArrayList();
        this.params_metadata = new ArrayList();
        this.params_editor = new ArrayList();
        this.isok = false;
        this.init(namespace, funcName);
    }

    private FunctionCallEditor(Dialog owner, NameSpace namespace, String funcName) {
        super(owner);
        this.constrains.gridy = 0;
        this.constrains.anchor = 17;
        this.constrains.insets = new Insets(3, 3, 3, 3);
        this.paramspanel = new JPanel();
        this.paramspanel_layout = new GridBagLayout();
        this.paramspanel.setLayout(this.paramspanel_layout);
        this.params_added = new ArrayList();
        this.params_metadata = new ArrayList();
        this.params_editor = new ArrayList();
        this.isok = false;
        this.init(namespace, funcName);
    }

    private void init(NameSpace namespace, String funcName) {
        ParameterEditor param_editor;
        Map param_metadata2;
        this.setSize(640, 400);
        Dimension size = this.getSize();
        Dimension screenSize = this.getParent().getSize();
        Point parent_loc = this.getParent().getLocation();
        this.setLocation(parent_loc.x + screenSize.width / 2 - size.width / 2, parent_loc.y + screenSize.height / 2 - size.height / 2);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.setLayout(new BorderLayout());
        this.setContentPane(panel);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        panel.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionCallEditor.this.setVisible(false);
            }
        }, stroke, 2);
        JPanel buttonpanel = new JPanel();
        panel.add((Component)buttonpanel, "South");
        buttonpanel.setLayout(new FlowLayout(2));
        JButton ok_button = new JButton("OK");
        JButton cancel_button = new JButton("Cancel");
        ok_button.setDefaultCapable(true);
        ok_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionCallEditor.this.ok();
                FunctionCallEditor.this.setVisible(false);
            }
        });
        cancel_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionCallEditor.this.setVisible(false);
            }
        });
        buttonpanel.add(ok_button);
        buttonpanel.add(cancel_button);
        panel.add((Component)new JScrollPane(this.paramspanel), "Center");
        String title = funcName.toLowerCase();
        Variable variable = namespace.get(funcName);
        List<MetaData> metadata = Unit.getInstance(variable).getMetaData();
        if (metadata != null) {
            boolean firstone = true;
            for (MetaData metadatai : metadata) {
                if (metadatai.getDescription() != null) {
                    if (firstone) {
                        title = String.valueOf(title) + " - " + metadatai.getDescription();
                        firstone = false;
                    } else {
                        title = String.valueOf(title) + " , " + metadatai.getDescription();
                    }
                }
                for (Map param_metadata2 : metadatai.getParameters()) {
                    this.addParameter(param_metadata2);
                }
            }
        }
        Object[] params = this.params_metadata.toArray();
        int i = 0;
        while (i < params.length) {
            Map param_metadata3 = (Map)params[i];
            if (param_metadata3.get("number") != null) {
                ParameterEditor param_editor2 = new ParameterEditor(param_metadata3);
                this.params_editor.add(param_editor2);
            }
            ++i;
        }
        boolean numbseperator_added = this.params_editor.size() == 0;
        int i2 = 0;
        while (i2 < params.length) {
            String name;
            Map param_metadata4 = (Map)params[i2];
            if (param_metadata4.get("number") == null && !"output".equals(name = (String)param_metadata4.get("name")) && !"input".equals(name)) {
                if (!numbseperator_added) {
                    this.addParamSeperator();
                    numbseperator_added = true;
                }
                param_editor = new ParameterEditor(param_metadata4);
                this.params_editor.add(param_editor);
            }
            ++i2;
        }
        boolean inout_added = this.params_editor.size() == 0;
        int i3 = 0;
        while (i3 < params.length) {
            param_metadata2 = (Map)params[i3];
            if (param_metadata2.get("number") == null && "input".equals(param_metadata2.get("name"))) {
                if (!inout_added) {
                    this.addParamSeperator();
                    inout_added = true;
                }
                param_editor = new ParameterEditor(param_metadata2);
                this.params_editor.add(param_editor);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < params.length) {
            param_metadata2 = (Map)params[i3];
            if (param_metadata2.get("number") == null && "output".equals(param_metadata2.get("name"))) {
                if (!inout_added) {
                    this.addParamSeperator();
                    inout_added = true;
                }
                param_editor = new ParameterEditor(param_metadata2);
                this.params_editor.add(param_editor);
            }
            ++i3;
        }
        this.constrains.weighty = 1.0;
        this.paramspanel.add((Component)new JPanel(), this.constrains);
        this.getRootPane().setDefaultButton(ok_button);
        this.setTitle(title);
        this.setModal(true);
    }

    private class ParameterEditor {
        private static final long serialVersionUID = 1L;
        JCheckBox checkbox = new JCheckBox();
        JTextField textfield = null;
        JComboBox combobox = null;
        String name = "";
        int number = -1;

        public void setValue(String value) {
            this.checkbox.setSelected(true);
            if (this.textfield != null) {
                this.textfield.setEnabled(true);
                this.textfield.setText(value);
            }
            if (this.combobox != null) {
                this.combobox.setEnabled(true);
                this.combobox.setSelectedItem(value);
            }
        }

        public String getValue() {
            if (!this.checkbox.isSelected()) {
                return null;
            }
            if (this.textfield != null) {
                return this.textfield.getText();
            }
            if (this.combobox != null) {
                return this.combobox.getSelectedItem().toString();
            }
            return null;
        }

        public ParameterEditor(Map param_metadata) {
            Integer number = (Integer)param_metadata.get("number");
            String name = (String)param_metadata.get("name");
            String description = (String)param_metadata.get("description");
            String defaultval = (String)param_metadata.get("default");
            String unit = (String)param_metadata.get("unit");
            List options = (List)param_metadata.get("options");
            if (options != null) {
                this.combobox = new JComboBox<Object>(options.toArray());
                this.combobox.setEditable(true);
            } else {
                this.textfield = new JTextField();
                this.textfield.setPreferredSize(new Dimension(30, this.textfield.getPreferredSize().height));
            }
            this.name = name;
            if (number != null) {
                this.number = number;
            }
            if (description == null) {
                description = name;
            }
            String text = name;
            if (number != null) {
                text = number + ". " + text;
            }
            this.checkbox.setText(description);
            this.checkbox.addActionListener(new ActionListener(this){
                final /* synthetic */ ParameterEditor this$1;
                {
                    this.this$1 = parameterEditor;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$1.textfield != null) {
                        this.this$1.textfield.setEnabled(this.this$1.checkbox.isSelected());
                    }
                    if (this.this$1.combobox != null) {
                        this.this$1.combobox.setEnabled(this.this$1.checkbox.isSelected());
                    }
                }
            });
            ((FunctionCallEditor)FunctionCallEditor.this).constrains.gridx = 0;
            FunctionCallEditor.this.paramspanel.add((Component)this.checkbox, FunctionCallEditor.this.constrains);
            ((FunctionCallEditor)FunctionCallEditor.this).constrains.gridx = 1;
            ((FunctionCallEditor)FunctionCallEditor.this).constrains.weightx = 1.0;
            ((FunctionCallEditor)FunctionCallEditor.this).constrains.fill = 2;
            if (defaultval == null) {
                defaultval = "";
            }
            if (this.textfield != null) {
                this.textfield.setText(defaultval);
                this.textfield.setEnabled(false);
                FunctionCallEditor.this.paramspanel.add((Component)this.textfield, FunctionCallEditor.this.constrains);
            }
            if (this.combobox != null) {
                this.combobox.setSelectedItem(defaultval);
                this.combobox.setEnabled(false);
                FunctionCallEditor.this.paramspanel.add((Component)this.combobox, FunctionCallEditor.this.constrains);
            }
            ((FunctionCallEditor)FunctionCallEditor.this).constrains.fill = 0;
            ((FunctionCallEditor)FunctionCallEditor.this).constrains.weightx = 0.0;
            ((FunctionCallEditor)FunctionCallEditor.this).constrains.gridx = 2;
            if (unit != null) {
                FunctionCallEditor.this.paramspanel.add((Component)new JLabel(unit), FunctionCallEditor.this.constrains);
            }
            ((FunctionCallEditor)FunctionCallEditor.this).constrains.gridx = 3;
            FunctionCallEditor.this.paramspanel.add((Component)new JLabel("   " + text + "   "), FunctionCallEditor.this.constrains);
            ++((FunctionCallEditor)FunctionCallEditor.this).constrains.gridy;
        }
    }
}

