/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaData {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_NUMBER = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_MIDI = 4;
    public static final int TYPE_AUDIO = 8;
    public static final int TYPE_AUDIO_AND_NUMBER = 9;
    public static final int TYPE_CONTROL = 16;
    public static final int DIRECTION_UNKNOWN = 0;
    public static final int DIRECTION_IN = 1;
    public static final int DIRECTION_OUT = 2;
    public static final int DIRECTION_INOUT = 3;
    ArrayList parameters = new ArrayList();
    String description;
    boolean has_varargs = false;

    public void setHasVarargs(boolean value) {
        this.has_varargs = value;
    }

    public boolean hasVarargs() {
        return this.has_varargs;
    }

    public String getDescription() {
        return this.description;
    }

    public MetaData(String description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List getParameters() {
        return this.parameters;
    }

    public Map add(int number, String name, String description, String defaultvalue, String unit, int paramtype, int direction) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (number > 0) {
            map.put("number", new Integer(number));
        }
        if (name != null) {
            map.put("name", name.toLowerCase());
        }
        map.put("type", new Integer(paramtype));
        map.put("direction", new Integer(direction));
        if (description != null) {
            map.put("description", description);
        }
        if (unit != null) {
            map.put("unit", unit);
        }
        if (defaultvalue != null) {
            map.put("default", defaultvalue);
        }
        this.parameters.add(map);
        return map;
    }
}

